/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.parser;

import jaredbgreat.dldungeons.parser.CharSet;
import java.util.Arrays;

public class Tokenizer {
    private final CharSet delim;
    private String[] tokens;
    private int token = 0;
    private String in;
    private int position = 0;
    private int size = 0;
    private char next = '\u0000';
    private char[] scratchpad;
    boolean onTokens = false;
    boolean keepQuotes = false;

    public Tokenizer(String input, String delims) {
        this.keepQuotes = false;
        this.delim = new CharSet(delims);
        this.in = input;
        this.readTokens();
    }

    public Tokenizer(String input, String delims, boolean keepQuotes) {
        this.keepQuotes = keepQuotes;
        this.delim = new CharSet(delims);
        this.in = input;
        this.readTokens();
    }

    private void nextChar() {
        this.next = this.in.charAt(this.position);
        if (this.next == '\\') {
            this.readEscape();
        }
        ++this.position;
    }

    private void readTokens() {
        this.tokens = new String[this.in.length() / 5 + 1];
        this.scratchpad = new char[this.in.length()];
        while (this.position < this.in.length()) {
            this.nextChar();
            if (this.delim.contains(this.next)) {
                if (!this.onTokens) continue;
                this.addToken();
                this.onTokens = false;
                this.size = 0;
                continue;
            }
            this.onTokens = true;
            if (this.next == '\"') {
                this.readQuote();
                continue;
            }
            this.scratchpad[this.size] = this.next;
            ++this.size;
        }
        if (this.onTokens) {
            this.addToken();
            this.onTokens = false;
            this.size = 0;
        }
        this.tokens = Arrays.copyOf(this.tokens, this.token);
        this.token = 0;
    }

    private void addToken() {
        if (this.token >= this.tokens.length) {
            int newCapacity = Math.min(this.tokens.length * 2, this.tokens.length + 16);
            this.tokens = Arrays.copyOf(this.tokens, newCapacity);
        }
        this.tokens[this.token] = new String(this.scratchpad, 0, this.size);
        ++this.token;
    }

    private void readQuote() {
        this.onTokens = true;
        this.addToken();
        this.size = 0;
        if (this.keepQuotes) {
            this.scratchpad[this.size++] = 34;
        }
        do {
            this.nextChar();
            this.scratchpad[this.size++] = this.next;
        } while (this.position < this.in.length() && this.next != '\"');
        if (!this.keepQuotes && this.next == '\"') {
            --this.size;
        }
        this.addToken();
        ++this.position;
        this.size = 0;
    }

    private void readEscape() {
        do {
            this.onTokens = true;
            ++this.position;
            if (this.position >= this.in.length()) {
                return;
            }
            this.next = this.in.charAt(this.position);
            switch (this.next) {
                case '\"': {
                    this.scratchpad[this.size] = 34;
                    break;
                }
                case '\'': {
                    this.scratchpad[this.size] = 39;
                    break;
                }
                case 'n': {
                    this.scratchpad[this.size] = 10;
                    break;
                }
                case 'r': {
                    this.scratchpad[this.size] = 13;
                    break;
                }
                case 't': {
                    this.scratchpad[this.size] = 9;
                    break;
                }
                case 'f': {
                    this.scratchpad[this.size] = 12;
                    break;
                }
                case 'b': {
                    this.scratchpad[this.size] = 8;
                    break;
                }
                case '0': {
                    this.scratchpad[this.size] = '\u0000';
                    break;
                }
                case 's': {
                    this.scratchpad[this.size] = 32;
                    break;
                }
                default: {
                    this.scratchpad[this.size] = this.next;
                }
            }
            ++this.size;
            ++this.position;
            this.next = this.in.charAt(this.position);
        } while (this.next == '\\');
    }

    public int countTokens() {
        return this.tokens.length;
    }

    public boolean hasMoreTokens() {
        return this.token < this.tokens.length;
    }

    public String nextToken() {
        if (this.hasMoreTokens()) {
            return this.tokens[this.token++];
        }
        return null;
    }

    public void reset() {
        this.token = 0;
    }

    public String getToken(int index) {
        if (index >= 0 && index < this.tokens.length) {
            return this.tokens[index];
        }
        return null;
    }
}

