/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.pieces.chests;

import cpw.mods.fml.common.eventhandler.Event;
import jaredbgreat.dldungeons.ConfigHandler;
import jaredbgreat.dldungeons.api.DLDEvent;
import jaredbgreat.dldungeons.builder.DBlock;
import jaredbgreat.dldungeons.pieces.chests.LootCategory;
import jaredbgreat.dldungeons.pieces.chests.LootType;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;

public class BasicChest {
    public int mx;
    public int my;
    public int mz;
    public int level;
    private static int A1 = 2;
    private static int B1 = 1;
    private static int C1 = 2;

    public BasicChest(int x, int y, int z, int level) {
        this.mx = x;
        this.my = y;
        this.mz = z;
        this.level = level;
    }

    public void place(World world, int x, int y, int z, Random random) {
        this.level += random.nextInt(2);
        if (this.level >= 7) {
            this.level = 6;
        }
        DBlock.placeChest(world, x, y, z);
        if (world.func_147439_a(x, y, z) != DBlock.chest) {
            return;
        }
        TileEntityChest contents = (TileEntityChest)world.func_147438_o(x, y, z);
        if (contents == null) {
            System.err.println("DLDUNGEONS: Error, tile entity not found for chest");
            return;
        }
        if (this.addVanillaLoot(random)) {
            this.vanillaChest(contents, random);
        }
        int which = random.nextInt(3);
        switch (which) {
            case 0: {
                this.fillChest(contents, LootType.HEAL, random);
                break;
            }
            case 1: {
                this.fillChest(contents, LootType.GEAR, random);
                break;
            }
            case 2: {
                this.fillChest(contents, LootType.RANDOM, random);
            }
        }
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)new DLDEvent.AfterChestTileEntity(world, contents, which, x, y, z, random, this.level));
    }

    private void vanillaChest(TileEntityChest contents, Random random) {
        ChestGenHooks chinf;
        int which = random.nextInt(6);
        switch (which) {
            case 0: {
                chinf = ChestGenHooks.getInfo((String)"bonusChest");
                break;
            }
            case 1: {
                chinf = ChestGenHooks.getInfo((String)"pyramidDesertyChest");
                break;
            }
            case 2: {
                chinf = ChestGenHooks.getInfo((String)"pyramidJungleChest");
                break;
            }
            case 3: {
                chinf = ChestGenHooks.getInfo((String)"mineshaftCorridor");
                break;
            }
            case 4: {
                chinf = ChestGenHooks.getInfo((String)"villageBlacksmith");
                break;
            }
            default: {
                chinf = ChestGenHooks.getInfo((String)"dungeonChest");
            }
        }
        WeightedRandomChestContent.func_76293_a((Random)random, (WeightedRandomChestContent[])chinf.getItems(random), (IInventory)contents, (int)chinf.getCount(random));
    }

    protected void fillChest(TileEntityChest chest, LootType kind, Random random) {
        ItemStack treasure;
        int num = random.nextInt(A1 + this.level / B1) + C1;
        for (int i = 0; i < num; ++i) {
            ItemStack treasure2 = LootCategory.getLoot(kind, this.level, random);
            if (treasure2 == null) continue;
            chest.func_70299_a(random.nextInt(27), treasure2);
        }
        if (random.nextBoolean() && (treasure = LootCategory.getLoot(LootType.RANDOM, this.level, random)) != null) {
            chest.func_70299_a(random.nextInt(27), treasure);
        }
    }

    protected boolean addVanillaLoot(Random random) {
        boolean out = ConfigHandler.stingyLoot ? random.nextInt(21) < this.level * 2 : random.nextInt(21) < this.level + 7;
        return out && ConfigHandler.vanillaLoot;
    }

    public static void setBasicLootNumbers(int a, int b, int c) {
        A1 = a;
        B1 = b;
        C1 = c;
    }
}

