/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.rooms;

import jaredbgreat.dldungeons.ConfigHandler;
import jaredbgreat.dldungeons.Difficulty;
import jaredbgreat.dldungeons.pieces.Doorway;
import jaredbgreat.dldungeons.pieces.Shapes;
import jaredbgreat.dldungeons.pieces.Spawner;
import jaredbgreat.dldungeons.pieces.chests.BasicChest;
import jaredbgreat.dldungeons.pieces.chests.TreasureChest;
import jaredbgreat.dldungeons.pieces.chests.WeakChest;
import jaredbgreat.dldungeons.planner.Dungeon;
import jaredbgreat.dldungeons.planner.RoomSeed;
import jaredbgreat.dldungeons.planner.Route;
import jaredbgreat.dldungeons.planner.Symmetry;
import jaredbgreat.dldungeons.planner.astar.DoorQueue;
import jaredbgreat.dldungeons.planner.features.Cutout;
import jaredbgreat.dldungeons.planner.features.Depression;
import jaredbgreat.dldungeons.planner.features.FeatureAdder;
import jaredbgreat.dldungeons.planner.features.IslandPlatform;
import jaredbgreat.dldungeons.planner.features.IslandRoom;
import jaredbgreat.dldungeons.planner.features.Pillar;
import jaredbgreat.dldungeons.planner.features.Pool;
import jaredbgreat.dldungeons.rooms.AbstractRoom;
import jaredbgreat.dldungeons.themes.ThemeFlags;
import jaredbgreat.dldungeons.themes.ThemeType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class Room
extends AbstractRoom {
    private static int lootBonus = 0;
    public int id;
    public static final Room roomNull = new Room();
    public int beginX;
    public int midX;
    public int endX;
    public int beginZ;
    public int midZ;
    public int endZ;
    public int floorY;
    public int nFloorY;
    public int ceilY;
    public int nCeilY;
    public int y;
    public float realX;
    public float realZ;
    public boolean hasWholePattern;
    public Symmetry sym;
    public int orientation;
    public boolean XFlip;
    public boolean ZFlip;
    public Shapes shape = Shapes.X;
    public ArrayList<RoomSeed> childSeeds;
    public boolean isNode;
    public boolean isSubroom;
    public boolean hasEntrance;
    public boolean hasSpawners;
    public ArrayList<Spawner> spawners;
    public ArrayList<BasicChest> chests;
    public ArrayList<Doorway> doors;
    public ArrayList<DoorQueue> connections;
    public ArrayList<Doorway> topDoors;
    public Doorway midpoint;

    private Room() {
        this.id = 0;
    }

    public void preFinalize() {
        this.childSeeds.clear();
        this.childSeeds = null;
        this.spawners.clear();
        this.chests.clear();
        this.spawners = null;
        this.chests = null;
        this.doors = null;
    }

    public Room(int beginX, int endX, int beginZ, int endZ, int floorY, int ceilY, Dungeon dungeon, Room parent, Room previous) {
        super(dungeon, previous);
        int i;
        dungeon.rooms.add(this);
        this.id = dungeon.rooms.realSize();
        this.childSeeds = new ArrayList();
        this.spawners = new ArrayList();
        this.chests = new ArrayList();
        this.doors = new ArrayList();
        this.connections = new ArrayList();
        dungeon.planter.add(this);
        this.isNode = previous == null;
        this.isSubroom = parent != null;
        boolean bl = this.hasEntrance = this.isNode && dungeon.entrances.use(dungeon.random);
        if (this.hasEntrance) {
            ++dungeon.numEntrances;
        }
        this.hasSpawners = false;
        this.sym = Symmetry.getSymmetry(dungeon);
        this.orientation = dungeon.random.nextInt(4);
        this.XFlip = dungeon.random.nextBoolean();
        this.ZFlip = dungeon.random.nextBoolean();
        this.beginX = beginX;
        this.endX = endX;
        this.beginZ = beginZ;
        this.endZ = endZ;
        this.floorY = floorY;
        this.ceilY = ceilY;
        this.midX = beginX + (endX - beginX) / 2;
        this.midZ = beginZ + (endZ - beginZ) / 2;
        this.realX = (float)(endX - beginX) / 2.0f + (float)beginX + 1.0f;
        this.realZ = (float)(endZ - beginZ) / 2.0f + (float)beginZ + 1.0f;
        dungeon.spawners.addRoom((endX - beginX) * (endZ - beginZ));
        if (this.isNode) {
            this.degenerateFloors = false;
            this.doors.add(new Doorway(this.midX, this.midZ, dungeon.random.nextBoolean()));
        }
        if (this.isSubroom && parent.sky) {
            this.sky = this.sky && !dungeon.outside.use(dungeon.random);
        }
        for (i = beginX + 1; i < endX; ++i) {
            for (int j = beginZ + 1; j < endZ; ++j) {
                if (dungeon.map.room[i][j] == 0) {
                    dungeon.map.room[i][j] = this.id;
                }
                byte by = (byte)ceilY;
                dungeon.map.nCeilY[i][j] = by;
                dungeon.map.ceilY[i][j] = by;
                byte by2 = (byte)floorY;
                dungeon.map.nFloorY[i][j] = by2;
                dungeon.map.floorY[i][j] = by2;
                if (!this.sky) {
                    dungeon.map.ceiling[i][j] = this.cielingBlock;
                }
                dungeon.map.floor[i][j] = this.floorBlock;
                dungeon.map.wall[i][j] = this.wallBlock1;
                dungeon.map.hasLiquid[i][j] = false;
                dungeon.map.isWall[i][j] = false;
            }
        }
        for (i = beginX; i <= endX; ++i) {
            this.assignEdge(dungeon, i, beginZ);
            this.assignEdge(dungeon, i, endZ);
        }
        for (i = beginZ; i <= endZ; ++i) {
            this.assignEdge(dungeon, beginX, i);
            this.assignEdge(dungeon, endX, i);
        }
        this.doorways(dungeon);
        this.midpoint = new Doorway(this.midX, this.midZ, dungeon.random.nextBoolean());
    }

    public Room plan(Dungeon dungeon, Room parent) {
        if (!dungeon.complexity.use(dungeon.random) && !this.isNode) {
            this.hasWholePattern = true;
            if (dungeon.liquids.use(dungeon.random)) {
                this.walkway(dungeon);
            } else if (!this.sky && (dungeon.complexity.use(dungeon.random) || dungeon.symmetry.use(dungeon.random))) {
                this.cutin(dungeon);
            }
        } else {
            this.addFeatures(dungeon);
        }
        if (this.hasEntrance) {
            for (int i = (int)this.realX - 2; i < (int)this.realX + 2; ++i) {
                for (int j = (int)this.realZ - 2; j < (int)this.realZ + 2; ++j) {
                    dungeon.map.floorY[i][j] = (byte)this.floorY;
                    dungeon.map.hasLiquid[i][j] = false;
                    dungeon.map.isWall[i][j] = false;
                }
            }
        }
        if (parent == null) {
            this.addSpawners(dungeon);
        }
        return this;
    }

    private void assignEdge(Dungeon dungeon, int x, int z) {
        if (dungeon.map.room[x][z] == 0 || ((Room)dungeon.rooms.get((int)dungeon.map.room[x][z])).sky && !this.sky || this.isSubroom) {
            dungeon.map.room[x][z] = this.id;
            if (!this.sky) {
                dungeon.map.ceiling[x][z] = this.cielingBlock;
            }
            dungeon.map.floor[x][z] = this.floorBlock;
            dungeon.map.wall[x][z] = this.wallBlock1;
            dungeon.map.hasLiquid[x][z] = false;
            dungeon.map.isWall[x][z] = !this.sky;
            dungeon.map.isFence[x][z] = this.fenced;
        }
        if (dungeon.map.ceilY[x][z] < (byte)this.ceilY) {
            dungeon.map.ceilY[x][z] = (byte)this.ceilY;
        }
        if (dungeon.map.nCeilY[x][z] < (byte)this.ceilY) {
            dungeon.map.nCeilY[x][z] = (byte)this.ceilY;
        }
        if (dungeon.map.floorY[x][z] < (byte)this.floorY) {
            dungeon.map.floorY[x][z] = (byte)this.floorY;
        }
        if (dungeon.map.nFloorY[x][z] > (byte)this.nFloorY || dungeon.map.nFloorY[x][z] == 0) {
            dungeon.map.nFloorY[x][z] = (byte)this.floorY;
        }
    }

    public void addFeatures(Dungeon dungeon) {
        ArrayList<FeatureAdder> features = new ArrayList<FeatureAdder>();
        features.add(new IslandPlatform(dungeon.verticle));
        features.add(new Depression(dungeon.verticle));
        features.add(new Pool(dungeon.liquids));
        if (!this.sky) {
            features.add(new Cutout(dungeon.complexity));
            features.add(new Pillar(dungeon.pillars));
        }
        features.add(new IslandRoom(dungeon.islands));
        features.trimToSize();
        Collections.shuffle(features, dungeon.random);
        if (dungeon.complexity.value <= 0) {
            return;
        }
        int tries = (this.endX - this.beginX + this.endZ - this.beginZ) / (4 + this.sym.level);
        for (int i = 0; i <= tries; ++i) {
            FeatureAdder feat;
            Iterator iterator = features.iterator();
            while (iterator.hasNext() && !(feat = (FeatureAdder)iterator.next()).addFeature(dungeon, this)) {
            }
        }
    }

    protected void addSpawners(Dungeon dungeon) {
        int lev;
        String mob;
        int y;
        int z;
        int x;
        if (ConfigHandler.difficulty == Difficulty.NONE || !this.isNode && !ConfigHandler.difficulty.addmob(dungeon.random) || this.hasEntrance && !ConfigHandler.difficulty.entrancemobs) {
            return;
        }
        boolean multibonus = false;
        if (ConfigHandler.difficulty.multimob(dungeon.random) || this.isNode) {
            int tmp = this.endX - this.beginX > this.endZ - this.beginZ ? this.endX - this.beginX : this.endZ - this.beginZ;
            int num = dungeon.random.nextInt(2 + tmp / 8) + 1;
            for (int i = 0; i < num; ++i) {
                tmp = this.endX - this.beginX - 3;
                x = dungeon.random.nextInt(tmp) + this.beginX + 2;
                tmp = this.endZ - this.beginZ - 3;
                z = dungeon.random.nextInt(tmp) + this.beginZ + 2;
                y = dungeon.random.nextInt(4) == 0 ? dungeon.map.ceilY[x][z] : dungeon.map.floorY[x][z];
                int lev2 = this.levAdjust(ConfigHandler.difficulty.moblevel(dungeon.random), dungeon);
                if (lev2 < 0) continue;
                mob = dungeon.theme.allMobs[lev2].get(dungeon.random.nextInt(dungeon.theme.allMobs[lev2].size()));
                Spawner s = new Spawner(x, y, z, this.id, lev2, mob);
                this.spawners.add(s);
                dungeon.spawners.addSpawner(s);
            }
        } else {
            int tmp = (this.endX - this.beginX) / 2;
            x = dungeon.random.nextInt(tmp) + this.beginX + tmp / 2;
            tmp = (this.endZ - this.beginZ) / 2;
            z = dungeon.random.nextInt(tmp) + this.beginZ + tmp / 2;
            y = dungeon.random.nextInt(4) == 0 ? dungeon.map.floorY[x][z] : dungeon.map.ceilY[x][z];
            lev = this.levAdjust(ConfigHandler.difficulty.moblevel(dungeon.random), dungeon);
            if (lev >= 0) {
                mob = dungeon.theme.allMobs[lev].get(dungeon.random.nextInt(dungeon.theme.allMobs[lev].size()));
                Spawner s = new Spawner(x, y, z, this.id, lev, mob);
                this.spawners.add(s);
                dungeon.spawners.addSpawner(s);
            }
        }
        if (this.isNode) {
            x = (int)this.realX;
            z = (int)this.realZ;
            y = dungeon.map.hasLiquid[x][z] ? dungeon.map.ceilY[x][z] : dungeon.map.floorY[x][z] - 1;
            lev = this.levAdjust(ConfigHandler.difficulty.nodelevel(dungeon.random), dungeon);
            if (lev >= 0) {
                mob = dungeon.theme.allMobs[lev].get(dungeon.random.nextInt(dungeon.theme.allMobs[lev].size()));
                this.spawners.add(new Spawner(x, y, z, this.id, lev, mob));
            }
        }
    }

    private int levAdjust(int lev, Dungeon dungeon) {
        while (dungeon.theme.allMobs[lev].isEmpty()) {
            if (--lev >= 0) continue;
            return -1;
        }
        return lev;
    }

    public void addChests(Dungeon dungeon) {
        byte y;
        int z;
        int x;
        if (ConfigHandler.difficulty == Difficulty.NONE || this.hasEntrance) {
            return;
        }
        boolean bl = this.hasSpawners = this.spawners.size() > 0;
        if (!this.hasSpawners && dungeon.random.nextInt(5) > 0) {
            return;
        }
        int lev = 0;
        int n = this.spawners.size();
        for (int i = 0; i < n; ++i) {
            lev = Math.max(lev, this.spawners.get(i).getLevel());
        }
        if (n > 1) {
            ++lev;
        }
        if (this.isNode && !this.hasEntrance) {
            ++lev;
        }
        if (dungeon.theme.flags.contains((Object)ThemeFlags.HARD)) {
            ++lev;
        } else if (dungeon.theme.flags.contains((Object)ThemeFlags.EASY)) {
            --lev;
        }
        lev += lootBonus + dungeon.random.nextInt(1);
        if (!this.hasSpawners) {
            int tmp = this.endX - this.beginX - 3;
            x = dungeon.random.nextInt(tmp) + this.beginX + 2;
            tmp = this.endZ - this.beginZ - 3;
            z = dungeon.random.nextInt(tmp) + this.beginZ + 2;
            y = dungeon.map.floorY[x][z];
            this.chests.add(new WeakChest(x, y, z));
        } else if (dungeon.random.nextBoolean() && !this.isNode) {
            int tmp = this.endX - this.beginX - 3;
            x = dungeon.random.nextInt(tmp) + this.beginX + 2;
            tmp = this.endZ - this.beginZ - 3;
            z = dungeon.random.nextInt(tmp) + this.beginZ + 2;
            y = dungeon.map.floorY[x][z];
            this.chests.add(new BasicChest(x, y, z, lev));
        } else {
            int ms = Math.max(n, 2);
            int num = this.isNode ? Math.min(ms, dungeon.random.nextInt(2 + ms / 2) + 2) : dungeon.random.nextInt(1 + ms / 2) + 1;
            for (int i = 0; i < num; ++i) {
                int tmp = this.endX - this.beginX - 3;
                x = dungeon.random.nextInt(tmp) + this.beginX + 2;
                tmp = this.endZ - this.beginZ - 3;
                z = dungeon.random.nextInt(tmp) + this.beginZ + 2;
                y = dungeon.map.floorY[x][z];
                this.chests.add(new BasicChest(x, y, z, lev));
            }
        }
        if (this.isNode) {
            x = (int)this.realX;
            z = (int)this.realZ;
            y = dungeon.map.floorY[x][z];
            this.chests.add(new TreasureChest(x, y, z, lev));
        }
    }

    protected void doorways(Dungeon dungeon) {
        int num = dungeon.random.nextInt(2 + (this.endX - this.beginX + this.endZ - this.beginZ) / (this.sym.level * 8 + 8) + dungeon.subrooms.value / (2 + this.sym.level)) + 1;
        for (int i = 0; i < num; ++i) {
            this.doorway(dungeon);
        }
    }

    protected void addDoor(Dungeon dungeon, int x, int z, boolean xOriented) {
        this.doors.add(new Doorway(x, z, xOriented));
        dungeon.map.isDoor[x][z] = true;
    }

    protected void doorway(Dungeon dungeon) {
        int oppZ;
        int z;
        int oppX;
        int x;
        int xExtend = 0;
        int zExtend = 0;
        int xSeedDir = 0;
        int zSeedDir = 0;
        int wall = dungeon.random.nextInt(4);
        switch (wall) {
            case 0: {
                x = this.beginX;
                oppX = this.endX;
                z = dungeon.random.nextInt(this.endZ - this.beginZ - 3) + 2;
                oppZ = this.endZ - z;
                z += this.beginZ;
                xSeedDir = -1;
                zSeedDir = 0;
                zExtend = dungeon.random.nextInt(3) - 1;
                break;
            }
            case 1: {
                z = this.beginZ;
                oppZ = this.endZ;
                x = dungeon.random.nextInt(this.endX - this.beginX - 3) + 2;
                oppX = this.endX - x;
                x += this.beginX;
                xSeedDir = 0;
                zSeedDir = -1;
                xExtend = dungeon.random.nextInt(3) - 1;
                break;
            }
            case 2: {
                x = this.endX;
                oppX = this.beginX;
                z = dungeon.random.nextInt(this.endZ - this.beginZ - 3) + 2;
                oppZ = this.endZ - z;
                z += this.beginZ;
                xSeedDir = 1;
                zSeedDir = 0;
                zExtend = dungeon.random.nextInt(3) - 1;
                break;
            }
            case 3: {
                z = this.endZ;
                oppZ = this.beginZ;
                x = dungeon.random.nextInt(this.endX - this.beginX - 3) + 2;
                oppX = this.endX - x;
                x += this.beginX;
                xSeedDir = 0;
                zSeedDir = 1;
                xExtend = dungeon.random.nextInt(3) - 1;
                break;
            }
            default: {
                x = this.beginX;
                oppX = this.endX;
                z = dungeon.random.nextInt(this.endZ - this.beginZ - 3) + 2;
                oppZ = this.endZ - z;
                z += this.beginZ;
                xSeedDir = -1;
                zSeedDir = 0;
                zExtend = dungeon.random.nextInt(3) - 1;
            }
        }
        this.addDoor(dungeon, x, z, xSeedDir != 0);
        this.addDoor(dungeon, x + xExtend, z + zExtend, xSeedDir != 0);
        this.childSeeds.add(new RoomSeed(x + xSeedDir, this.floorY, z + zSeedDir));
        switch (this.sym) {
            case NONE: {
                break;
            }
            case TR1: {
                oppX = (int)(this.realX + ((float)z - this.realZ) / (float)(this.endZ - this.beginZ) * (float)(this.endX - this.beginX));
                if (oppX < 1) {
                    oppX = 1;
                }
                if (oppX > dungeon.size.width - 2) {
                    oppX = dungeon.size.width - 2;
                }
                if ((oppZ = (int)(this.realZ + ((float)x - this.realX) / (float)(this.endX - this.beginX) * (float)(this.endZ - this.beginZ))) < 1) {
                    oppZ = 1;
                }
                if (oppZ > dungeon.size.width - 2) {
                    oppZ = dungeon.size.width - 2;
                }
                this.addDoor(dungeon, oppX, oppZ, zSeedDir != 0);
                this.addDoor(dungeon, oppX + xExtend, oppZ + zExtend, zSeedDir != 0);
                this.childSeeds.add(new RoomSeed(oppX + zSeedDir, this.floorY, oppZ + xSeedDir));
                break;
            }
            case TR2: {
                oppX = (int)(this.realX + ((float)z - this.realZ) / (float)(this.endZ - this.beginZ) * (float)(this.endX - this.beginX));
                if (oppX < 1) {
                    oppX = 1;
                }
                if (oppX > dungeon.size.width - 2) {
                    oppX = dungeon.size.width - 2;
                }
                oppZ = (int)(this.realZ + ((float)x - this.realX) / (float)(this.endX - this.beginX) * (float)(this.endZ - this.beginZ));
                if ((oppZ = this.endZ - (oppZ - this.beginZ)) < 1) {
                    oppZ = 1;
                }
                if (oppZ > dungeon.size.width - 2) {
                    oppZ = dungeon.size.width - 2;
                }
                this.addDoor(dungeon, oppX, oppZ, zSeedDir != 0);
                this.addDoor(dungeon, oppX + xExtend, oppZ + zExtend, zSeedDir != 0);
                this.childSeeds.add(new RoomSeed(oppX + zSeedDir, this.floorY, oppZ - xSeedDir));
                break;
            }
            case X: {
                this.addDoor(dungeon, oppX, z, xSeedDir != 0);
                this.addDoor(dungeon, oppX - xExtend, z + zExtend, xSeedDir != 0);
                this.childSeeds.add(new RoomSeed(oppX - xSeedDir, this.floorY, z + zSeedDir));
                break;
            }
            case Z: {
                this.addDoor(dungeon, x, oppZ, xSeedDir != 0);
                this.addDoor(dungeon, x + xExtend, oppZ - zExtend, xSeedDir != 0);
                this.childSeeds.add(new RoomSeed(x + xSeedDir, this.floorY, oppZ - zSeedDir));
                break;
            }
            case XZ: {
                this.addDoor(dungeon, oppX, z, xSeedDir != 0);
                this.addDoor(dungeon, oppX - xExtend, z + zExtend, xSeedDir != 0);
                this.childSeeds.add(new RoomSeed(oppX - xSeedDir, this.floorY, z + zSeedDir));
                this.addDoor(dungeon, x, oppZ, xSeedDir != 0);
                this.addDoor(dungeon, x + xExtend, oppZ - zExtend, xSeedDir != 0);
                this.childSeeds.add(new RoomSeed(x + xSeedDir, this.floorY, oppZ - zSeedDir));
                this.addDoor(dungeon, oppX, oppZ, xSeedDir != 0);
                this.addDoor(dungeon, oppX - xExtend, oppZ - zExtend, xSeedDir != 0);
                this.childSeeds.add(new RoomSeed(oppX - xSeedDir, this.floorY, oppZ - zSeedDir));
                break;
            }
            case R: {
                this.addDoor(dungeon, oppX, oppZ, xSeedDir != 0);
                this.addDoor(dungeon, oppX - xExtend, oppZ - zExtend, xSeedDir != 0);
                this.childSeeds.add(new RoomSeed(oppX - xSeedDir, this.floorY, oppZ - zSeedDir));
                break;
            }
            case SW: {
                this.addDoor(dungeon, oppX, z, xSeedDir != 0);
                this.addDoor(dungeon, oppX - xExtend, z + zExtend, xSeedDir != 0);
                this.childSeeds.add(new RoomSeed(oppX - xSeedDir, this.floorY, z + zSeedDir));
                this.addDoor(dungeon, x, oppZ, xSeedDir != 0);
                this.addDoor(dungeon, x + xExtend, oppZ - zExtend, xSeedDir != 0);
                this.childSeeds.add(new RoomSeed(x + xSeedDir, this.floorY, oppZ - zSeedDir));
                this.addDoor(dungeon, oppX, oppZ, xSeedDir != 0);
                this.addDoor(dungeon, oppX - xExtend, oppZ - zExtend, xSeedDir != 0);
                this.childSeeds.add(new RoomSeed(oppX - xSeedDir, this.floorY, oppZ - zSeedDir));
            }
        }
    }

    public Room connector(Dungeon dungeon, int dir, int xdim, int zdim, int height, Route source) {
        int z;
        int x;
        int xExtend = 0;
        int zExtend = 0;
        int xSeedDir = 0;
        int zSeedDir = 0;
        switch (dir) {
            case 2: {
                x = this.beginX;
                int oppX = this.endX;
                int oppZ = z = (int)this.realZ;
                xSeedDir = -1;
                zSeedDir = 0;
                zExtend = dungeon.random.nextInt(3) - 1;
                break;
            }
            case 3: {
                z = this.beginZ;
                int oppZ = this.endZ;
                int oppX = x = (int)this.realX;
                xSeedDir = 0;
                zSeedDir = -1;
                xExtend = dungeon.random.nextInt(3) - 1;
                break;
            }
            case 0: {
                x = this.endX;
                int oppX = this.beginX;
                int oppZ = z = (int)this.realZ;
                xSeedDir = 1;
                zSeedDir = 0;
                zExtend = dungeon.random.nextInt(3) - 1;
                break;
            }
            case 1: {
                z = this.endZ;
                int oppZ = this.beginZ;
                int oppX = x = (int)this.realX;
                xSeedDir = 0;
                zSeedDir = 1;
                xExtend = dungeon.random.nextInt(3) - 1;
                break;
            }
            default: {
                x = this.beginX;
                int oppX = this.endX;
                int oppZ = z = (int)this.realZ;
                z += this.beginZ;
                xSeedDir = -1;
                zSeedDir = 0;
                zExtend = dungeon.random.nextInt(3) - 1;
            }
        }
        this.addDoor(dungeon, x, z, xSeedDir != 0);
        this.addDoor(dungeon, x + xExtend, z + zExtend, xSeedDir != 0);
        if (x + xSeedDir >= dungeon.size.width || x + xSeedDir < 0 || z + zSeedDir >= dungeon.size.width || z + zSeedDir < 0) {
            return null;
        }
        if (dungeon.map.room[x + xSeedDir][z + zSeedDir] != 0) {
            return (Room)dungeon.rooms.get(dungeon.map.room[x + xSeedDir][z + zSeedDir]);
        }
        if (dir % 2 == 0) {
            return new RoomSeed(x + xSeedDir, this.floorY, z + zSeedDir).growRoomZ(xdim, zdim, height, dungeon, null, this);
        }
        return new RoomSeed(x + xSeedDir, this.floorY, z + zSeedDir).growRoomX(xdim, zdim, height, dungeon, null, this);
    }

    private void walkway(Dungeon dungeon) {
        int drop = dungeon.theme.type.contains((Object)ThemeType.SWAMP) ? 1 : 2;
        this.shape = Shapes.wholeShape(this.sym, dungeon.random);
        for (int i = this.beginX; i <= this.endX; ++i) {
            for (int j = this.beginZ; j <= this.endZ; ++j) {
                byte[] byArray = dungeon.map.floorY[i];
                int n = j;
                byArray[n] = (byte)(byArray[n] - drop);
                dungeon.map.hasLiquid[i][j] = true;
            }
        }
        this.shape.family[this.orientation].drawWalkway(dungeon, this, this.realX, this.realZ, (byte)(this.endX - this.beginX + 1), (byte)(this.endZ - this.beginZ + 1), this.XFlip, this.ZFlip);
    }

    private void cutin(Dungeon dungeon) {
        this.shape = Shapes.wholeShape(this.sym, dungeon.random);
        for (int i = this.beginX; i <= this.endX; ++i) {
            for (int j = this.beginZ; j <= this.endZ; ++j) {
                dungeon.map.isWall[i][j] = true;
            }
        }
        this.shape.family[this.orientation].drawCutin(dungeon, this, this.realX, this.realZ, (byte)(this.endX - this.beginX - 1), (byte)(this.endZ - this.beginZ - 1), this.XFlip, this.ZFlip);
    }

    public boolean plantChildren(Dungeon dungeon) {
        boolean result = false;
        for (RoomSeed planted : this.childSeeds) {
            int ymod;
            int roomHeight;
            int zdim;
            int xdim;
            if (dungeon.rooms.realSize() >= dungeon.size.maxRooms) {
                return false;
            }
            int height = dungeon.baseHeight;
            int x = dungeon.random.nextInt(dungeon.size.width);
            int z = dungeon.random.nextInt(dungeon.size.width);
            if (height > dungeon.theme.maxY) {
                height = dungeon.baseHeight;
            }
            if (height < dungeon.theme.minY) {
                height = dungeon.baseHeight;
            }
            if (planted.growRoom(xdim, zdim, roomHeight = dungeon.random.nextInt(dungeon.verticle.value / 2 + (ymod = (xdim = dungeon.random.nextInt(dungeon.size.maxRoomSize - 5) + 6) <= (zdim = dungeon.random.nextInt(dungeon.size.maxRoomSize - 5) + 6) ? (int)Math.sqrt(xdim) : (int)Math.sqrt(zdim)) + 1) + 2, dungeon, null, this) == null) continue;
            result = true;
        }
        return result;
    }

    public void addToConnections(Doorway door) {
        if (this.id < 1) {
            return;
        }
        if (this.connections.isEmpty()) {
            DoorQueue pq = new DoorQueue(door.otherside);
            pq.add(door);
            this.connections.add(pq);
        } else {
            boolean added = false;
            for (DoorQueue pq : this.connections) {
                if (!pq.isRoom(door.otherside)) continue;
                pq.add(door);
                added = true;
                break;
            }
            if (!added) {
                DoorQueue pq = new DoorQueue(door.otherside);
                pq.add(door);
                this.connections.add(pq);
            }
        }
    }

    public static void setLootBonus(int bonus) {
        lootBonus = bonus;
    }
}

