/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.command;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import openmods.calc.BigIntCalculator;
import openmods.calc.Calculator;
import openmods.calc.CompiledFunction;
import openmods.calc.Constant;
import openmods.calc.DoubleCalculator;
import openmods.calc.FixedSymbol;
import openmods.calc.FractionCalculator;
import openmods.calc.ICalculatorFrame;
import openmods.calc.IExecutable;
import openmods.calc.ISymbol;
import openmods.calc.StackValidationException;
import openmods.config.simpler.ConfigurableClassAdapter;
import openmods.utils.Stack;
import org.apache.commons.lang3.math.Fraction;

public class CalcState {
    private final SenderHolder senderHolder = new SenderHolder();
    private Calculator<?> active = CalculatorType.DOUBLE.createCalculator(this.senderHolder);
    private Calculator<?> prev;
    public Calculator.ExprType exprType = Calculator.ExprType.INFIX;
    private Stack<Calculator<?>> calculatorStack = Stack.create();
    private Map<String, Calculator<?>> calculatorMap = Maps.newHashMap();

    public Calculator<?> getActiveCalculator() {
        return this.active;
    }

    public Set<String> getActiveProperties() {
        return ConfigurableClassAdapter.getFor(this.active.getClass()).keys();
    }

    public String getActiveProperty(String key) {
        return ConfigurableClassAdapter.getFor(this.active.getClass()).get(this.active, key);
    }

    public void setActiveProperty(String key, String value) {
        ConfigurableClassAdapter.getFor(this.active.getClass()).set(this.active, key, value);
    }

    private void setActiveCalculator(Calculator<?> newCalculator) {
        this.prev = this.active;
        this.active = newCalculator;
    }

    public void restorePreviousCalculator() {
        Calculator<?> tmp = this.active;
        this.active = this.prev;
        this.prev = tmp;
    }

    public void createCalculator(CalculatorType type) {
        this.setActiveCalculator(type.createCalculator(this.senderHolder));
    }

    public int pushCalculator() {
        this.calculatorStack.push(this.active);
        return this.calculatorStack.size();
    }

    public int popCalculator() {
        this.setActiveCalculator(this.calculatorStack.pop());
        return this.calculatorStack.size();
    }

    public void nameCalculator(String name) {
        this.calculatorMap.put(name, this.active);
    }

    public Set<String> getCalculatorsNames() {
        return Collections.unmodifiableSet(this.calculatorMap.keySet());
    }

    public void loadCalculator(String name) {
        Calculator<?> newCalculator = this.calculatorMap.get(name);
        if (newCalculator == null) {
            throw new NoSuchNameException(name);
        }
        this.setActiveCalculator(newCalculator);
    }

    private static <E> void compileAndExecute(Calculator<E> calculator, Calculator.ExprType exprType, String expr) {
        IExecutable<E> executable = calculator.compile(exprType, expr);
        calculator.execute(executable);
    }

    public void compileAndExecute(ICommandSender sender, final String expr) {
        this.senderHolder.call(sender, new IFunction<Void>(){

            @Override
            public Void call() {
                CalcState.compileAndExecute(CalcState.this.active, CalcState.this.exprType, expr);
                return null;
            }
        });
    }

    private static <E> E compileExecuteAndPop(Calculator<E> calculator, Calculator.ExprType exprType, String expr) {
        IExecutable<E> executable = calculator.compile(exprType, expr);
        return calculator.executeAndPop(executable);
    }

    private static <E> String compileExecuteAndPrint(Calculator<E> calculator, Calculator.ExprType exprType, String expr) {
        E result = CalcState.compileExecuteAndPop(calculator, exprType, expr);
        return calculator.toString(result);
    }

    public String compileExecuteAndPrint(ICommandSender sender, final String expr) {
        return this.senderHolder.call(sender, new IFunction<String>(){

            @Override
            public String call() {
                return CalcState.compileExecuteAndPrint(CalcState.this.active, CalcState.this.exprType, expr);
            }
        });
    }

    private static <E> E compileAndSetGlobalSymbol(Calculator<E> calculator, Calculator.ExprType exprType, String id, String expr) {
        E value = CalcState.compileExecuteAndPop(calculator, exprType, expr);
        calculator.setGlobalSymbol(id, Constant.create(value));
        return value;
    }

    public Object compileAndSetGlobalSymbol(ICommandSender sender, final String id, final String expr) {
        return this.senderHolder.call(sender, new IFunction<Object>(){

            @Override
            public Object call() {
                return CalcState.compileAndSetGlobalSymbol(CalcState.this.active, CalcState.this.exprType, id, expr);
            }
        });
    }

    private static <E> void compileAndDefineGlobalFunction(Calculator<E> calculator, Calculator.ExprType exprType, String id, int argCount, String bodyExpr) {
        IExecutable<E> funcBody = calculator.compile(exprType, bodyExpr);
        calculator.setGlobalSymbol(id, new CompiledFunction<E>(argCount, 1, funcBody));
    }

    public void compileAndDefineGlobalFunction(ICommandSender sender, final String id, final int argCount, final String expr) {
        this.senderHolder.call(sender, new IFunction<Void>(){

            @Override
            public Void call() {
                CalcState.compileAndDefineGlobalFunction(CalcState.this.active, CalcState.this.exprType, id, argCount, expr);
                return null;
            }
        });
    }

    public static enum CalculatorType {
        DOUBLE{

            @Override
            public Calculator<?> newCalculator(final SenderHolder holder) {
                DoubleCalculator calculator = new DoubleCalculator();
                calculator.setGlobalSymbol("$x", new FixedSymbol<Double>(0, 1){

                    @Override
                    public void execute(ICalculatorFrame<Double> frame) {
                        frame.stack().push(Double.valueOf(holder.getX()));
                    }
                });
                calculator.setGlobalSymbol("$y", new FixedSymbol<Double>(0, 1){

                    @Override
                    public void execute(ICalculatorFrame<Double> frame) {
                        frame.stack().push(Double.valueOf(holder.getY()));
                    }
                });
                calculator.setGlobalSymbol("$z", new FixedSymbol<Double>(0, 1){

                    @Override
                    public void execute(ICalculatorFrame<Double> frame) {
                        frame.stack().push(Double.valueOf(holder.getZ()));
                    }
                });
                return calculator;
            }
        }
        ,
        FRACTION{

            @Override
            public Calculator<?> newCalculator(final SenderHolder holder) {
                FractionCalculator calculator = new FractionCalculator();
                calculator.setGlobalSymbol("$x", new FixedSymbol<Fraction>(0, 1){

                    @Override
                    public void execute(ICalculatorFrame<Fraction> frame) {
                        frame.stack().push(Fraction.getFraction((int)holder.getX(), (int)1));
                    }
                });
                calculator.setGlobalSymbol("$y", new FixedSymbol<Fraction>(0, 1){

                    @Override
                    public void execute(ICalculatorFrame<Fraction> frame) {
                        frame.stack().push(Fraction.getFraction((int)holder.getY(), (int)1));
                    }
                });
                calculator.setGlobalSymbol("$z", new FixedSymbol<Fraction>(0, 1){

                    @Override
                    public void execute(ICalculatorFrame<Fraction> frame) {
                        frame.stack().push(Fraction.getFraction((int)holder.getZ(), (int)1));
                    }
                });
                return calculator;
            }
        }
        ,
        BIGINT{

            @Override
            public Calculator<?> newCalculator(final SenderHolder holder) {
                BigIntCalculator calculator = new BigIntCalculator();
                calculator.setGlobalSymbol("$x", new FixedSymbol<BigInteger>(0, 1){

                    @Override
                    public void execute(ICalculatorFrame<BigInteger> frame) {
                        frame.stack().push(BigInteger.valueOf(holder.getX()));
                    }
                });
                calculator.setGlobalSymbol("$y", new FixedSymbol<BigInteger>(0, 1){

                    @Override
                    public void execute(ICalculatorFrame<BigInteger> frame) {
                        frame.stack().push(BigInteger.valueOf(holder.getY()));
                    }
                });
                calculator.setGlobalSymbol("$z", new FixedSymbol<BigInteger>(0, 1){

                    @Override
                    public void execute(ICalculatorFrame<BigInteger> frame) {
                        frame.stack().push(BigInteger.valueOf(holder.getZ()));
                    }
                });
                return calculator;
            }
        };


        public Calculator<?> createCalculator(SenderHolder holder) {
            return holder.addPrinter(this.newCalculator(holder));
        }

        protected abstract Calculator<?> newCalculator(SenderHolder var1);
    }

    private static class SenderHolder {
        private ICommandSender sender;

        private SenderHolder() {
        }

        public int getX() {
            Preconditions.checkNotNull((Object)this.sender, (Object)"DERP");
            return this.sender.func_82114_b().field_71574_a;
        }

        public int getY() {
            Preconditions.checkNotNull((Object)this.sender, (Object)"DERP");
            return this.sender.func_82114_b().field_71572_b;
        }

        public int getZ() {
            Preconditions.checkNotNull((Object)this.sender, (Object)"DERP");
            return this.sender.func_82114_b().field_71573_c;
        }

        public <E> Calculator<E> addPrinter(final Calculator<E> calculator) {
            calculator.setGlobalSymbol("p", new ISymbol<E>(){

                @Override
                public void execute(ICalculatorFrame<E> frame, Optional<Integer> argumentsCount, Optional<Integer> returnsCount) {
                    Preconditions.checkNotNull((Object)SenderHolder.this.sender, (Object)"DERP");
                    if (returnsCount.isPresent() && (Integer)returnsCount.get() != 0) {
                        throw new StackValidationException("This function does not return any values", new Object[0]);
                    }
                    Stack stack = frame.stack();
                    int in = (Integer)argumentsCount.or((Object)1);
                    ArrayList results = Lists.newArrayListWithExpectedSize((int)in);
                    for (int i = 0; i < in; ++i) {
                        Object value = stack.pop();
                        results.add(calculator.toString(value));
                    }
                    String result = ": " + Joiner.on((String)" ").join((Iterable)results);
                    SenderHolder.this.sender.func_145747_a((IChatComponent)new ChatComponentText(result));
                }
            });
            return calculator;
        }

        public <E> E call(ICommandSender sender, IFunction<E> function) {
            this.sender = sender;
            E result = function.call();
            this.sender = null;
            return result;
        }
    }

    private static interface IFunction<E> {
        public E call();
    }

    public static class NoSuchNameException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NoSuchNameException(String message) {
            super(message);
        }
    }
}

