/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.command;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import openmods.calc.Calculator;
import openmods.calc.command.CalcState;
import openmods.calc.command.CommandCalcBase;
import openmods.config.simpler.ConfigurableClassAdapter;
import openmods.utils.CommandUtils;
import openmods.utils.Stack;

public class CommandCalcConfig
extends CommandCalcBase {
    private static final String NAME = "=config";
    private static final String COMMAND_LOAD = "load";
    private static final String COMMAND_STORE = "store";
    private static final String COMMAND_POP = "pop";
    private static final String COMMAND_PUSH = "push";
    private static final String COMMAND_NEW = "new";
    private static final String COMMAND_GET = "get";
    private static final String COMMAND_SET = "set";
    private static final String COMMAND_MODE = "mode";
    private static Set<String> SUB_COMMANDS = ImmutableSet.of((Object)"new", (Object)"pop", (Object)"push", (Object)"load", (Object)"store", (Object)"get", (Object[])new String[]{"set", "mode"});

    public CommandCalcConfig(CalcState state) {
        super(NAME, state);
    }

    public String func_71518_a(ICommandSender sender) {
        return "=config new " + Arrays.toString((Object[])CalcState.CalculatorType.values()) + " OR " + NAME + " " + COMMAND_PUSH + " OR " + NAME + " " + COMMAND_POP + " OR " + NAME + " " + COMMAND_STORE + " <name> OR " + NAME + " " + COMMAND_LOAD + " <name> OR " + NAME + " " + COMMAND_GET + " <option> OR" + NAME + " " + COMMAND_SET + " <option> <value> OR " + NAME + " " + COMMAND_MODE + " " + Arrays.toString((Object[])Calculator.ExprType.values());
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length < 1) {
            throw new SyntaxErrorException();
        }
        String subCommand = args[0];
        if (subCommand.equalsIgnoreCase(COMMAND_NEW)) {
            if (args.length < 2) {
                throw CommandUtils.error("openmodslib.command.calc_no_type", new Object[0]);
            }
            String type = args[1].toUpperCase(Locale.ENGLISH);
            try {
                CalcState.CalculatorType newType = CalcState.CalculatorType.valueOf(type);
                this.state.createCalculator(newType);
            }
            catch (IllegalArgumentException e) {
                throw CommandUtils.error("openmodslib.command.calc_invalid_type", Joiner.on((char)',').join((Object[])CalcState.CalculatorType.values()));
            }
        } else if (subCommand.equalsIgnoreCase(COMMAND_PUSH)) {
            int size = this.state.pushCalculator();
            CommandUtils.respond(sender, "openmodslib.command.calc_after_push", size);
        } else if (subCommand.equalsIgnoreCase(COMMAND_POP)) {
            try {
                int size = this.state.popCalculator();
                CommandUtils.respond(sender, "openmodslib.command.calc_after_pop", size);
            }
            catch (Stack.StackUnderflowException e) {
                CommandUtils.error("openmodslib.command.calc_stack_underflow", new Object[0]);
            }
        } else if (subCommand.equalsIgnoreCase(COMMAND_STORE)) {
            if (args.length < 2) {
                throw CommandUtils.error("openmodslib.command.calc_no_name", new Object[0]);
            }
            String name = args[1];
            this.state.nameCalculator(name);
        } else if (subCommand.equalsIgnoreCase(COMMAND_LOAD)) {
            if (args.length < 2) {
                throw CommandUtils.error("openmodslib.command.calc_no_name", new Object[0]);
            }
            String name = args[1];
            try {
                this.state.loadCalculator(name);
            }
            catch (CalcState.NoSuchNameException e) {
                CommandUtils.error("openmodslib.command.calc_invalid_name", new Object[0]);
            }
        } else if (subCommand.equalsIgnoreCase(COMMAND_GET)) {
            if (args.length < 2) {
                throw CommandUtils.error("openmodslib.command.calc_no_key", new Object[0]);
            }
            String key = args[1];
            try {
                this.state.getActiveProperty(key);
            }
            catch (ConfigurableClassAdapter.NoSuchPropertyException e) {
                CommandUtils.error("openmodslib.command.calc_invalid_key", new Object[0]);
            }
        } else if (subCommand.equalsIgnoreCase(COMMAND_SET)) {
            if (args.length < 2) {
                throw CommandUtils.error("openmodslib.command.calc_no_key", new Object[0]);
            }
            if (args.length < 3) {
                throw CommandUtils.error("openmodslib.command.calc_no_value", new Object[0]);
            }
            String key = args[1];
            String value = args[2];
            try {
                this.state.setActiveProperty(key, value);
            }
            catch (ConfigurableClassAdapter.NoSuchPropertyException e) {
                CommandUtils.error("openmodslib.command.calc_invalid_key", new Object[0]);
            }
            catch (Exception e) {
                CommandUtils.error("openmodslib.command.calc_cant_set", new Object[0]);
            }
        } else if (subCommand.equalsIgnoreCase(COMMAND_MODE)) {
            String type = args[1].toUpperCase(Locale.ENGLISH);
            try {
                this.state.exprType = Calculator.ExprType.valueOf(type);
            }
            catch (IllegalArgumentException e) {
                throw CommandUtils.error("openmodslib.command.calc_invalid_mode", Joiner.on((char)',').join((Object[])Calculator.ExprType.values()));
            }
        } else {
            throw new SyntaxErrorException();
        }
    }

    @Override
    public List<?> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            return null;
        }
        if (args.length == 1) {
            return CommandUtils.filterPrefixes(args[0], SUB_COMMANDS);
        }
        String subCommand = args[0];
        if (subCommand.equalsIgnoreCase(COMMAND_NEW)) {
            CalcState.CalculatorType[] values = CalcState.CalculatorType.values();
            Iterable<String> types = CommandCalcConfig.stringifyList((Object[])values);
            return CommandUtils.filterPrefixes(args[1], types);
        }
        if (subCommand.equalsIgnoreCase(COMMAND_MODE)) {
            Calculator.ExprType[] values = Calculator.ExprType.values();
            Iterable<String> types = CommandCalcConfig.stringifyList((Object[])values);
            return CommandUtils.filterPrefixes(args[1], types);
        }
        if (subCommand.equalsIgnoreCase(COMMAND_LOAD)) {
            return CommandUtils.filterPrefixes(args[1], this.state.getCalculatorsNames());
        }
        if (subCommand.equalsIgnoreCase(COMMAND_GET) || subCommand.equalsIgnoreCase(COMMAND_SET)) {
            return CommandUtils.filterPrefixes(args[1], this.state.getActiveProperties());
        }
        return null;
    }

    private static Iterable<String> stringifyList(Object ... values) {
        return Iterables.transform(Arrays.asList(values), (Function)new Function<Object, String>(){

            @Nullable
            public String apply(@Nullable Object input) {
                return String.valueOf(input).toLowerCase(Locale.ENGLISH);
            }
        });
    }
}

