/*
 * Decompiled with CFR 0.152.
 */
package openmods.config.gui;

import com.google.common.collect.Lists;
import cpw.mods.fml.client.config.DummyConfigElement;
import cpw.mods.fml.client.config.GuiConfig;
import cpw.mods.fml.client.config.GuiConfigEntries;
import cpw.mods.fml.client.config.IConfigElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Property;
import openmods.config.game.AbstractFeatureManager;
import openmods.config.game.FeatureRegistry;
import openmods.config.properties.ConfigProcessing;
import openmods.config.properties.ConfigPropertyMeta;

public class OpenModsConfigScreen
extends GuiConfig {
    public OpenModsConfigScreen(GuiScreen parent, String modId, String title) {
        super(parent, OpenModsConfigScreen.createConfigElements(modId), modId, false, true, title);
    }

    private static List<IConfigElement> createConfigElements(String modId) {
        IConfigElement<?> config;
        ArrayList result = Lists.newArrayList();
        IConfigElement<?> features = OpenModsConfigScreen.createFeatureEntries(modId);
        if (features != null) {
            result.add(features);
        }
        if ((config = OpenModsConfigScreen.createConfigEntries(modId)) != null) {
            result.add(config);
        }
        return result;
    }

    protected static IConfigElement<?> createFeatureEntries(String modId) {
        AbstractFeatureManager manager = FeatureRegistry.instance.getManager(modId);
        if (manager == null) {
            return null;
        }
        ArrayList categories = Lists.newArrayList();
        for (String category : manager.getCategories()) {
            ArrayList categoryEntries = Lists.newArrayList();
            for (String feature : manager.getFeaturesInCategory(category)) {
                Property property = FeatureRegistry.instance.getProperty(modId, category, feature);
                if (property == null) continue;
                categoryEntries.add(new ConfigElement(property));
            }
            categories.add(new CategoryElement(category, "openmodslib.config.features." + category, (List)categoryEntries));
        }
        return new CategoryElement("features", "openmodslib.config.features", (List)categories);
    }

    private static IConfigElement<?> createConfigEntries(String modId) {
        ConfigProcessing.ModConfig config = ConfigProcessing.getConfig(modId);
        if (config == null) {
            return null;
        }
        ArrayList categories = Lists.newArrayList();
        for (String category : config.getCategories()) {
            ArrayList categoryEntries = Lists.newArrayList();
            for (String value : config.getValues(category)) {
                ConfigPropertyMeta meta = config.getValue(category, value);
                categoryEntries.add(new ConfigElement(meta.getProperty()));
            }
            categories.add(new CategoryElement(category, "openmodslib.config.category." + category, (List)categoryEntries));
        }
        return new CategoryElement("config", "openmodslib.config.config", (List<IConfigElement>)categories, EntryWithWarning.class);
    }

    public static class EntryWithWarning
    extends GuiConfigEntries.CategoryEntry {
        public EntryWithWarning(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            return new GuiConfig((GuiScreen)this.owningScreen, this.configElement.getChildElements(), this.owningScreen.modID, this.owningScreen.allRequireWorldRestart || this.configElement.requiresWorldRestart(), this.owningScreen.allRequireMcRestart || this.configElement.requiresMcRestart(), this.owningScreen.title, I18n.func_135052_a((String)"openmodslib.config.update_warning", (Object[])new Object[0]));
        }
    }

    private static class CategoryElement
    extends DummyConfigElement.DummyCategoryElement {
        private CategoryElement(String name, String langKey, List<IConfigElement> childElements) {
            super(name, langKey, childElements);
        }

        public CategoryElement(String name, String langKey, List<IConfigElement> childElements, Class<? extends GuiConfigEntries.IConfigEntry> customListEntryClass) {
            super(name, langKey, childElements, customListEntryClass);
        }

        public String getComment() {
            return null;
        }
    }
}

