/*
 * Decompiled with CFR 0.152.
 */
package openmods.datastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import openmods.datastore.DataStoreKey;
import openmods.datastore.DataStoreManager;
import openmods.datastore.DataStoreWrapper;
import openmods.datastore.IDataVisitor;
import openmods.utils.io.IStreamReader;
import openmods.utils.io.IStreamSerializer;
import openmods.utils.io.IStreamWriter;
import openmods.utils.io.TypeRW;

public class DataStoreBuilder<K, V> {
    private final DataStoreManager owner;
    private final DataStoreKey<K, V> key;
    private final Class<? extends K> keyClass;
    private final Class<? extends V> valueClass;
    private IStreamWriter<K> keyWriter;
    private IStreamWriter<V> valueWriter;
    private IStreamReader<K> keyReader;
    private IStreamReader<V> valueReader;
    private List<IDataVisitor<K, V>> visitors = Lists.newArrayList();
    private final Map<K, V> values = Maps.newHashMap();

    DataStoreBuilder(DataStoreManager owner, DataStoreKey<K, V> key, Class<? extends K> keyClass, Class<? extends V> valueClass) {
        this.owner = owner;
        this.key = key;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
    }

    public DataStoreKey<K, V> register() {
        Preconditions.checkNotNull(this.keyWriter, (Object)"Key writer not set");
        Preconditions.checkNotNull(this.valueWriter, (Object)"Value writer not set");
        Preconditions.checkNotNull(this.keyReader, (Object)"Key reader not set");
        Preconditions.checkNotNull(this.valueReader, (Object)"Value reader not set");
        DataStoreWrapper<K, V> wrapper = new DataStoreWrapper<K, V>(this.values, this.keyWriter, this.valueWriter, this.keyReader, this.valueReader);
        for (IDataVisitor<K, V> visitor : this.visitors) {
            wrapper.addVisitor(visitor);
        }
        wrapper.activateLocalData();
        this.owner.register(this.key, wrapper);
        return this.key;
    }

    public boolean isRegistered(K key) {
        return this.values.containsKey(key);
    }

    public void addEntry(K key, V value) {
        Preconditions.checkNotNull(key, (Object)"Null key not allowed");
        Preconditions.checkNotNull(value, (Object)"Null values not allowed");
        V prev = this.values.put(key, value);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Replacing value for key %s: %s -> %s, id: %s", (Object[])new Object[]{key, prev, value, this.key.id});
    }

    private <T> TypeRW<T> getDefaultReaderWriter(Class<? extends T> cls) {
        TypeRW<?> rw = TypeRW.UNIVERSAL_SERIALIZERS.get(cls);
        Preconditions.checkNotNull(rw, (String)"Can't find default reader/writer for class %s, id: %s", (Object[])new Object[]{cls, this.key.id});
        return rw;
    }

    public void setDefaultKeyWriter() {
        this.keyWriter = this.getDefaultReaderWriter(this.keyClass);
    }

    public void setDefaultValueWriter() {
        this.valueWriter = this.getDefaultReaderWriter(this.valueClass);
    }

    public void setDefaultKeyReader() {
        this.keyReader = this.getDefaultReaderWriter(this.keyClass);
    }

    public void setDefaultValueReader() {
        this.valueReader = this.getDefaultReaderWriter(this.valueClass);
    }

    public void setDefaultKeyReaderWriter() {
        this.setDefaultKeyWriter();
        this.setDefaultKeyReader();
    }

    public void setDefaultValueReaderWriter() {
        this.setDefaultValueWriter();
        this.setDefaultValueReader();
    }

    public void setDefaultReadersWriters() {
        this.setDefaultKeyReaderWriter();
        this.setDefaultValueReaderWriter();
    }

    public void setKeyWriter(IStreamWriter<K> keyWriter) {
        this.keyWriter = keyWriter;
    }

    public void setValueWriter(IStreamWriter<V> valueWriter) {
        this.valueWriter = valueWriter;
    }

    public void setKeyReaderWriter(IStreamSerializer<K> rw) {
        this.keyReader = rw;
        this.keyWriter = rw;
    }

    public void setKeyReader(IStreamReader<K> keyReader) {
        this.keyReader = keyReader;
    }

    public void setValueReader(IStreamReader<V> valueReader) {
        this.valueReader = valueReader;
    }

    public void setValueReaderWriter(IStreamSerializer<V> rw) {
        this.valueReader = rw;
        this.valueWriter = rw;
    }

    public void addVisitor(IDataVisitor<K, V> visitor) {
        this.visitors.add(visitor);
    }
}

