/*
 * Decompiled with CFR 0.152.
 */
package openmods.entity;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import openmods.entity.IEntityLoadListener;

public class DelayedEntityLoadManager {
    public static final DelayedEntityLoadManager instance = new DelayedEntityLoadManager();
    private Multimap<Integer, IEntityLoadListener> delayedLoads = Multimaps.newSetMultimap(new HashMap(), (Supplier)new Supplier<Set<IEntityLoadListener>>(){

        public Set<IEntityLoadListener> get() {
            return Sets.newSetFromMap(new WeakHashMap());
        }
    });

    private DelayedEntityLoadManager() {
    }

    @SubscribeEvent
    public void onEntityCreate(EntityJoinWorldEvent evt) {
        Entity entity = evt.entity;
        for (IEntityLoadListener callback : this.delayedLoads.removeAll((Object)entity.func_145782_y())) {
            callback.onEntityLoaded(entity);
        }
    }

    public void registerLoadListener(World world, IEntityLoadListener listener, int entityId) {
        Entity entity = world.func_73045_a(entityId);
        if (entity == null) {
            this.delayedLoads.put((Object)entityId, (Object)listener);
        } else {
            listener.onEntityLoaded(entity);
        }
    }
}

