/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.rpc;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import openmods.datastore.IDataVisitor;
import openmods.network.rpc.MethodParamsCodec;
import org.apache.commons.lang3.ClassUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class MethodIdRegistry
implements IDataVisitor<String, Integer> {
    private final Set<Class<?>> registeredInterfaces = Sets.newHashSet();
    private final BiMap<java.lang.reflect.Method, Integer> methodIds = HashBiMap.create();

    public boolean isClassRegistered(Class<?> cls) {
        return this.registeredInterfaces.contains(cls);
    }

    public int methodToId(java.lang.reflect.Method method) {
        Integer id = (Integer)this.methodIds.get((Object)method);
        Preconditions.checkNotNull((Object)id, (String)"Method %s is ignored or not registered", (Object[])new Object[]{method});
        return id;
    }

    public java.lang.reflect.Method idToMethod(int id) {
        java.lang.reflect.Method method = (java.lang.reflect.Method)this.methodIds.inverse().get((Object)id);
        Preconditions.checkNotNull((Object)method, (String)"Unregistered method id %s", (Object[])new Object[]{id});
        return method;
    }

    @Override
    public void begin(int size) {
        this.registeredInterfaces.clear();
        this.methodIds.clear();
    }

    private static java.lang.reflect.Method identifyMethod(String methodDesc) throws Exception {
        String[] parts = methodDesc.split(";", 3);
        Preconditions.checkArgument((parts.length == 3 ? 1 : 0) != 0, (String)"Method descriptor has %d fields", (Object[])new Object[]{parts.length});
        Class<?> declaringCls = Class.forName(parts[0]);
        Method method = new Method(parts[1], parts[2]);
        Type[] argTypes = method.getArgumentTypes();
        Class<?>[] argCls = MethodIdRegistry.convertTypesToClasses(argTypes, declaringCls.getClassLoader());
        try {
            return declaringCls.getMethod(method.getName(), argCls);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Can't find method, class %s has methods %s", declaringCls, Arrays.toString(declaringCls.getMethods())), e);
        }
    }

    private static Class<?>[] convertTypesToClasses(Type[] argTypes, ClassLoader loader) throws ClassNotFoundException {
        Class[] argCls = new Class[argTypes.length];
        for (int i = 0; i < argCls.length; ++i) {
            argCls[i] = ClassUtils.getClass((ClassLoader)loader, (String)argTypes[i].getClassName(), (boolean)false);
        }
        return argCls;
    }

    @Override
    public void entry(String methodDesc, Integer id) {
        java.lang.reflect.Method method;
        try {
            method = MethodIdRegistry.identifyMethod(methodDesc);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(String.format("Malformed entry '%s' in method id %d", methodDesc, id), e);
        }
        MethodParamsCodec.create(method).validate();
        this.methodIds.put((Object)method, (Object)id);
        Class<?> declaringClass = method.getDeclaringClass();
        this.registeredInterfaces.add(declaringClass);
    }

    @Override
    public void end() {
    }
}

