/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.senders;

import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.channel.Channel;
import net.minecraft.entity.player.EntityPlayer;
import openmods.network.senders.IPacketSender;
import openmods.network.senders.ITargetedPacketSender;
import openmods.network.senders.PacketSenderBase;
import openmods.network.senders.TargetedPacketSenderBase;

public class FmlPacketSenderFactory {
    public static ITargetedPacketSender<EntityPlayer> createPlayerSender(Channel channel) {
        return new FmlTargetedPacketSender<EntityPlayer>(channel, FMLOutboundHandler.OutboundTarget.PLAYER){

            @Override
            protected void configureChannel(Channel channel, EntityPlayer player) {
                super.configureChannel(channel, player);
                this.setTargetAttr(channel, player);
            }
        };
    }

    public static ITargetedPacketSender<Integer> createDimensionSender(Channel channel) {
        return new FmlTargetedPacketSender<Integer>(channel, FMLOutboundHandler.OutboundTarget.DIMENSION){

            @Override
            protected void configureChannel(Channel channel, Integer dimensionId) {
                super.configureChannel(channel, dimensionId);
                this.setTargetAttr(channel, dimensionId);
            }
        };
    }

    public static ITargetedPacketSender<NetworkRegistry.TargetPoint> createPointSender(Channel channel) {
        return new FmlTargetedPacketSender<NetworkRegistry.TargetPoint>(channel, FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT){

            @Override
            protected void configureChannel(Channel channel, NetworkRegistry.TargetPoint point) {
                super.configureChannel(channel, point);
                this.setTargetAttr(channel, point);
            }
        };
    }

    public static IPacketSender createSender(Channel channel, FMLOutboundHandler.OutboundTarget target) {
        return new FmlPacketSender(channel, target);
    }

    private static class FmlTargetedPacketSender<T>
    extends TargetedPacketSenderBase<T> {
        private final FMLOutboundHandler.OutboundTarget selector;

        public FmlTargetedPacketSender(Channel channel, FMLOutboundHandler.OutboundTarget target) {
            super(channel);
            this.selector = target;
        }

        @Override
        protected void configureChannel(Channel channel, T target) {
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)this.selector);
        }
    }

    private static class FmlPacketSender
    extends PacketSenderBase {
        private final FMLOutboundHandler.OutboundTarget target;

        public FmlPacketSender(Channel channel, FMLOutboundHandler.OutboundTarget target) {
            super(channel);
            this.target = target;
        }

        @Override
        protected void configureChannel(Channel channel) {
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)this.target);
        }
    }
}

