/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import openmods.sync.SyncableObjectBase;
import openmods.utils.ByteUtils;
import openmods.utils.ItemUtils;

public class SyncableItemStack
extends SyncableObjectBase {
    private static final String TAG_TAG = "tag";
    private static final String TAG_DAMAGE = "Damage";
    private static final String TAG_COUNT = "Count";
    private static final String TAG_ID = "id";
    private ItemStack stack;

    @Override
    public void readFromStream(DataInputStream stream) throws IOException {
        int length = ByteUtils.readVLI(stream);
        if (length > 0) {
            int itemId = stream.readInt();
            byte size = stream.readByte();
            short damage = stream.readShort();
            NBTTagCompound deserialized = new NBTTagCompound();
            deserialized.func_74768_a(TAG_ID, itemId);
            deserialized.func_74774_a(TAG_COUNT, size);
            deserialized.func_74777_a(TAG_DAMAGE, damage);
            if (--length > 0) {
                NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)ByteStreams.limit((InputStream)stream, (long)length));
                deserialized.func_74782_a(TAG_TAG, (NBTBase)tag);
            }
            this.stack = ItemStack.func_77949_a((NBTTagCompound)deserialized);
        } else {
            this.stack = null;
        }
    }

    @Override
    public void writeToStream(DataOutputStream stream) throws IOException {
        if (this.stack != null) {
            NBTTagCompound serialized = new NBTTagCompound();
            this.stack.func_77955_b(serialized);
            int id = serialized.func_74762_e(TAG_ID);
            byte size = serialized.func_74771_c(TAG_COUNT);
            short damage = serialized.func_74765_d(TAG_DAMAGE);
            int payloadSize = 1;
            byte[] tagBytes = null;
            if (serialized.func_74764_b(TAG_TAG)) {
                NBTTagCompound tag = serialized.func_74775_l(TAG_TAG);
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)buffer);
                tagBytes = buffer.toByteArray();
                payloadSize += tagBytes.length;
            }
            ByteUtils.writeVLI(stream, payloadSize);
            stream.writeInt(id);
            stream.writeByte(size);
            stream.writeShort(damage);
            if (tagBytes != null) {
                stream.write(tagBytes);
            }
        } else {
            stream.writeByte(0);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String name) {
        if (this.stack != null) {
            NBTTagCompound serialized = ItemUtils.writeStack(this.stack);
            nbt.func_74782_a(name, (NBTBase)serialized);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String name) {
        if (nbt.func_150297_b(name, 10)) {
            NBTTagCompound serialized = nbt.func_74775_l(name);
            this.stack = ItemUtils.readStack(serialized);
        } else {
            this.stack = null;
        }
    }

    public void set(ItemStack stack) {
        this.stack = stack != null ? stack.func_77946_l() : null;
        this.markDirty();
    }

    public ItemStack get() {
        return this.stack;
    }
}

