/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapData;
import twilightforest.TFMapPacketHandler;
import twilightforest.TFMazeMapData;

public class ItemTFMazeMap
extends ItemMap {
    public static final String STR_ID = "mazemap";
    private static final int YSEARCH = 3;
    protected boolean mapOres;

    protected ItemTFMazeMap(boolean par2MapOres) {
        this.mapOres = par2MapOres;
    }

    @SideOnly(value=Side.CLIENT)
    public static TFMazeMapData getMPMapData(int par0, World par1World) {
        String mapName = "mazemap_" + par0;
        TFMazeMapData mapData = (TFMazeMapData)par1World.func_72943_a(TFMazeMapData.class, mapName);
        if (mapData == null) {
            mapData = new TFMazeMapData(mapName);
            par1World.func_72823_a(mapName, (WorldSavedData)mapData);
        }
        return mapData;
    }

    public TFMazeMapData getMapData(ItemStack par1ItemStack, World par2World) {
        TFMazeMapData mapData = (TFMazeMapData)par2World.func_72943_a(TFMazeMapData.class, "mazemap_" + par1ItemStack.func_77960_j());
        if (mapData == null && !par2World.field_72995_K) {
            par1ItemStack.func_77964_b(par2World.func_72841_b(STR_ID));
            String mapName = "mazemap_" + par1ItemStack.func_77960_j();
            mapData = new TFMazeMapData(mapName);
            mapData.field_76201_a = par2World.func_72912_H().func_76079_c();
            mapData.field_76199_b = par2World.func_72912_H().func_76074_e();
            mapData.field_76197_d = 0;
            mapData.field_76200_c = par2World.field_73011_w.field_76574_g;
            mapData.func_76185_a();
            par2World.func_72823_a(mapName, (WorldSavedData)mapData);
        }
        return mapData;
    }

    public void updateMapData(World par1World, Entity par2Entity, TFMazeMapData par3MapData) {
        int yDraw = MathHelper.func_76128_c((double)(par2Entity.field_70163_u - (double)par3MapData.yCenter));
        if (par1World.field_73011_w.field_76574_g == par3MapData.field_76200_c && yDraw > -3 && yDraw < 3) {
            int xSize = 128;
            int zSize = 128;
            int xCenter = par3MapData.field_76201_a;
            int zCenter = par3MapData.field_76199_b;
            int xDraw = MathHelper.func_76128_c((double)(par2Entity.field_70165_t - (double)xCenter)) + xSize / 2;
            int zDraw = MathHelper.func_76128_c((double)(par2Entity.field_70161_v - (double)zCenter)) + zSize / 2;
            int drawSize = 16;
            MapData.MapInfo mapInfo = par3MapData.func_82568_a((EntityPlayer)par2Entity);
            ++mapInfo.field_82569_d;
            for (int xStep = xDraw - drawSize + 1; xStep < xDraw + drawSize; ++xStep) {
                if ((xStep & 0xF) != (mapInfo.field_82569_d & 0xF)) continue;
                int highNumber = 255;
                int lowNumber = 0;
                for (int zStep = zDraw - drawSize - 1; zStep < zDraw + drawSize; ++zStep) {
                    byte tintedColor;
                    byte existingColor;
                    if (xStep < 0 || zStep < -1 || xStep >= xSize || zStep >= zSize) continue;
                    int xOffset = xStep - xDraw;
                    int zOffset = zStep - zDraw;
                    boolean var20 = xOffset * xOffset + zOffset * zOffset > (drawSize - 2) * (drawSize - 2);
                    int xDraw2 = xCenter + xStep - xSize / 2;
                    int zDraw2 = zCenter + zStep - zSize / 2;
                    Chunk chunk = par1World.func_72938_d(xDraw2, zDraw2);
                    int x15 = xDraw2 & 0xF;
                    int z15 = zDraw2 & 0xF;
                    int heightValue = par3MapData.yCenter;
                    Block blockID = chunk.func_150810_a(x15, heightValue, z15);
                    int tint = 1;
                    int colorIndex = 0;
                    if (blockID == Blocks.field_150348_b && this.mapOres) {
                        for (int i = -3; i <= 3; ++i) {
                            Block searchID = chunk.func_150810_a(x15, heightValue + i, z15);
                            if (searchID == Blocks.field_150348_b) continue;
                            blockID = searchID;
                            if (i > 0) {
                                tint = 2;
                            }
                            if (i >= 0) break;
                            tint = 0;
                            break;
                        }
                    }
                    if (blockID != Blocks.field_150350_a) {
                        MapColor mapColor = blockID.func_149688_o().func_151565_r();
                        colorIndex = mapColor.field_76290_q;
                    }
                    if (this.mapOres) {
                        if (blockID == Blocks.field_150365_q) {
                            colorIndex = MapColor.field_151654_J.field_76290_q;
                        } else if (blockID == Blocks.field_150352_o) {
                            colorIndex = MapColor.field_151647_F.field_76290_q;
                        } else if (blockID == Blocks.field_150366_p) {
                            colorIndex = MapColor.field_151668_h.field_76290_q;
                        } else if (blockID == Blocks.field_150369_x) {
                            colorIndex = MapColor.field_151652_H.field_76290_q;
                        } else if (blockID == Blocks.field_150450_ax || blockID == Blocks.field_150439_ay) {
                            colorIndex = MapColor.field_151645_D.field_76290_q;
                        } else if (blockID == Blocks.field_150482_ag) {
                            colorIndex = MapColor.field_151648_G.field_76290_q;
                        } else if (blockID == Blocks.field_150412_bA) {
                            colorIndex = MapColor.field_151653_I.field_76290_q;
                        } else if (blockID != Blocks.field_150350_a && blockID.func_149739_a().toLowerCase().contains("ore")) {
                            colorIndex = MapColor.field_151671_v.field_76290_q;
                        }
                    }
                    if (zStep < 0 || xOffset * xOffset + zOffset * zOffset >= drawSize * drawSize || var20 && (xStep + zStep & 1) == 0 || (existingColor = par3MapData.field_76198_e[xStep + zStep * xSize]) == (tintedColor = (byte)(colorIndex * 4 + tint))) continue;
                    if (highNumber > zStep) {
                        highNumber = zStep;
                    }
                    if (lowNumber < zStep) {
                        lowNumber = zStep;
                    }
                    par3MapData.field_76198_e[xStep + zStep * xSize] = tintedColor;
                }
                if (highNumber > lowNumber) continue;
                par3MapData.func_76194_a(xStep, highNumber, lowNumber);
            }
        }
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean isActiveItem) {
        if (!par2World.field_72995_K) {
            TFMazeMapData mapData = this.getMapData(par1ItemStack, par2World);
            if (par3Entity instanceof EntityPlayer) {
                MapData.MapCoord mapCoord;
                EntityPlayer player = (EntityPlayer)par3Entity;
                mapData.func_76191_a(player, par1ItemStack);
                int yProximity = MathHelper.func_76128_c((double)(player.field_70163_u - (double)mapData.yCenter));
                if ((yProximity < -3 || yProximity > 3) && (mapCoord = (MapData.MapCoord)mapData.field_76203_h.get(player.func_70005_c_())) != null) {
                    mapCoord.field_76216_a = (byte)6;
                }
            }
            if (isActiveItem) {
                this.updateMapData(par2World, par3Entity, mapData);
            }
        }
    }

    public void func_77622_d(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        par1ItemStack.func_77964_b(par2World.func_72841_b(STR_ID));
        String mapName = "mazemap_" + par1ItemStack.func_77960_j();
        TFMazeMapData mapData = new TFMazeMapData(mapName);
        par2World.func_72823_a(mapName, (WorldSavedData)mapData);
        mapData.field_76201_a = MathHelper.func_76128_c((double)par3EntityPlayer.field_70165_t);
        mapData.yCenter = MathHelper.func_76128_c((double)par3EntityPlayer.field_70163_u);
        mapData.field_76199_b = MathHelper.func_76128_c((double)par3EntityPlayer.field_70161_v);
        mapData.field_76197_d = 0;
        mapData.field_76200_c = par2World.field_73011_w.field_76574_g;
        mapData.func_76185_a();
    }

    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return this.mapOres ? EnumRarity.epic : EnumRarity.uncommon;
    }

    public boolean func_77636_d(ItemStack par1ItemStack) {
        return false;
    }

    public Packet func_150911_c(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        byte[] mapBytes = this.getMapData(par1ItemStack, par2World).func_76193_a(par1ItemStack, par2World, par3EntityPlayer);
        if (mapBytes == null) {
            return null;
        }
        short uniqueID = (short)par1ItemStack.func_77960_j();
        return TFMapPacketHandler.makeMagicMapPacket(STR_ID, uniqueID, mapBytes);
    }

    public String func_77653_i(ItemStack par1ItemStack) {
        return ("" + StatCollector.func_74838_a((String)(this.func_77657_g(par1ItemStack) + ".name")) + " #" + par1ItemStack.func_77960_j()).trim();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("TwilightForest:" + this.func_77658_a().substring(5));
    }
}

