/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.world.TFGenHollowTree;

public class TFGenHollowStump
extends TFGenHollowTree {
    @Override
    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int radius = rand.nextInt(2) + 2;
        if (!this.isAreaClear(world, rand, x - radius, y, z - radius, 2 * radius, 6, 2 * radius)) {
            return false;
        }
        this.buildTrunk(world, rand, x, y, z, radius, 6);
        this.buildBranchRing(world, rand, x, y, z, radius, 3, 2, 6, 0, 0.75, 0.0, 3, 5, 3, false);
        this.buildBranchRing(world, rand, x, y, z, radius, 1, 2, 8, 0, 0.9, 0.0, 3, 5, 3, false);
        return true;
    }

    @Override
    protected void buildTrunk(World world, Random random, int x, int y, int z, int diameter, int maxHeight) {
        int dz;
        int dx;
        int hollow = diameter / 2;
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                for (int dy = -4; dy < 0; ++dy) {
                    int az;
                    int ax = Math.abs(dx);
                    int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.5);
                    if (dist > diameter) continue;
                    if (TFGenHollowStump.hasAirAround((IBlockAccess)world, dx + x, dy + y, dz + z)) {
                        this.setBlockAndMetadata(world, dx + x, dy + y, dz + z, this.treeBlock, dist > hollow ? this.treeMeta : this.branchMeta);
                        continue;
                    }
                    this.setBlockAndMetadata(world, dx + x, dy + y, dz + z, this.rootBlock, this.rootMeta);
                }
            }
        }
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                int height = 2 + random.nextInt(3) + random.nextInt(2);
                for (int dy = 0; dy <= height; ++dy) {
                    int az;
                    int ax = Math.abs(dx);
                    int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.5);
                    if (dist > diameter || dist <= hollow) continue;
                    this.setBlockAndMetadata(world, dx + x, dy + y, dz + z, this.treeBlock, this.treeMeta);
                }
            }
        }
    }
}

