/*
 * Decompiled with CFR 0.152.
 */
package mca.ai;

import java.util.Map;
import java.util.SortedMap;
import mca.ai.AIBuild;
import mca.ai.AbstractToggleAI;
import mca.api.CropEntry;
import mca.api.RegistryMCA;
import mca.api.enums.EnumCropCategory;
import mca.api.exception.MappingNotFoundException;
import mca.core.MCA;
import mca.entity.EntityHuman;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import radixcore.data.BlockObj;
import radixcore.data.WatchedBoolean;
import radixcore.math.Point3D;
import radixcore.util.BlockHelper;
import radixcore.util.RadixLogic;
import radixcore.util.RadixMath;
import radixcore.util.SchematicHandler;

public class AIFarming
extends AbstractToggleAI {
    private static final int FARM_INTERVAL = 20;
    private WatchedBoolean isAIActive;
    private Point3D farmCenterPoint;
    private Point3D harvestTargetPoint;
    private int apiId;
    private int radius;
    private int seedsRequired;
    private int activityInterval;
    private boolean doCreate;
    private boolean isBuildingFarm;
    private boolean farmCreatedFlag;
    private String schematic;

    public AIFarming(EntityHuman owner) {
        super(owner);
        this.isAIActive = new WatchedBoolean(false, 42, owner.getDataWatcherEx());
        this.farmCenterPoint = Point3D.ZERO;
        this.harvestTargetPoint = Point3D.ZERO;
        this.schematic = "none";
    }

    @Override
    public void setIsActive(boolean value) {
        this.isAIActive.setValue((Object)value);
    }

    @Override
    public boolean getIsActive() {
        return this.isAIActive.getBoolean();
    }

    @Override
    public void onUpdateCommon() {
    }

    @Override
    public void onUpdateClient() {
    }

    @Override
    public void onUpdateServer() {
        try {
            if (!MCA.getConfig().allowFarmingChore) {
                this.notifyAssigningPlayer("\u00a7CThis chore is disabled.");
                this.reset();
                return;
            }
            if (this.activityInterval <= 0) {
                this.activityInterval = 20;
                if (this.doCreate) {
                    if (!this.isBuildingFarm) {
                        boolean canStart;
                        CropEntry entry = RegistryMCA.getCropEntryById(this.apiId);
                        int y = RadixLogic.getSpawnSafeTopLevel((World)this.owner.field_70170_p, (int)((int)this.owner.field_70165_t), (int)((int)this.owner.field_70161_v));
                        Block groundBlock = BlockHelper.getBlock((World)this.owner.field_70170_p, (int)((int)this.owner.field_70165_t), (int)(y - 1), (int)((int)this.owner.field_70161_v));
                        if (groundBlock != Blocks.field_150349_c || groundBlock != Blocks.field_150354_m || groundBlock != Blocks.field_150346_d) {
                            groundBlock = Blocks.field_150349_c;
                        }
                        if (!(canStart = this.owner.getAI(AIBuild.class).startBuilding(this.schematic, true, groundBlock, entry))) {
                            EntityPlayer assigningPlayer = this.getAssigningPlayer();
                            if (assigningPlayer != null) {
                                this.owner.say("build.fail.tooclose", assigningPlayer);
                            }
                            this.reset();
                            return;
                        }
                        this.owner.getInventory().removeCountOfItem(entry.getSeedItem(), this.seedsRequired);
                        this.isBuildingFarm = true;
                    } else if (this.isBuildingFarm && !this.owner.getAI(AIBuild.class).getIsActive()) {
                        this.owner.damageHeldItem(30);
                        this.isBuildingFarm = false;
                        this.reset();
                    }
                } else {
                    double delta = RadixMath.getDistanceToXYZ((double)this.owner.field_70165_t, (double)this.owner.field_70163_u, (double)this.owner.field_70161_v, (double)this.harvestTargetPoint.dPosX, (double)this.harvestTargetPoint.dPosY, (double)this.harvestTargetPoint.dPosZ);
                    if (this.harvestTargetPoint.iPosX == 0 && this.harvestTargetPoint.iPosY == 0 && this.harvestTargetPoint.iPosZ == 0) {
                        for (int id : RegistryMCA.getCropEntryIDs()) {
                            CropEntry entry = RegistryMCA.getCropEntryById(id);
                            if (entry.getCategory() == EnumCropCategory.SUGARCANE) {
                                Point3D nearestHarvest = RadixLogic.getFirstNearestBlockWithMeta((Entity)this.owner, (Block)entry.getHarvestBlock(), (int)entry.getHarvestBlockMeta(), (int)this.radius);
                                if (nearestHarvest == null) {
                                    this.harvestTargetPoint = Point3D.ZERO;
                                    continue;
                                }
                                int yMod = 0;
                                while (BlockHelper.getBlock((World)this.owner.field_70170_p, (int)nearestHarvest.iPosX, (int)(nearestHarvest.iPosY + yMod), (int)nearestHarvest.iPosZ) != Blocks.field_150349_c && BlockHelper.getBlock((World)this.owner.field_70170_p, (int)nearestHarvest.iPosX, (int)(nearestHarvest.iPosY + yMod), (int)nearestHarvest.iPosZ) != Blocks.field_150346_d) {
                                    if (--yMod >= -10) continue;
                                    this.reset();
                                    break;
                                }
                                Point3D modHarvestPoint = new Point3D(nearestHarvest.iPosX, nearestHarvest.iPosY + yMod + 2, nearestHarvest.iPosZ);
                                if (BlockHelper.getBlock((World)this.owner.field_70170_p, (int)modHarvestPoint.iPosX, (int)modHarvestPoint.iPosY, (int)modHarvestPoint.iPosZ) == entry.getHarvestBlock()) {
                                    this.harvestTargetPoint = modHarvestPoint;
                                    this.apiId = id;
                                    break;
                                }
                                this.harvestTargetPoint = Point3D.ZERO;
                                continue;
                            }
                            this.harvestTargetPoint = RadixLogic.getFirstNearestBlockWithMeta((Entity)this.owner, (Block)entry.getHarvestBlock(), (int)entry.getHarvestBlockMeta(), (int)this.radius);
                            if (this.harvestTargetPoint == null) {
                                this.harvestTargetPoint = Point3D.ZERO;
                                continue;
                            }
                            this.apiId = id;
                            break;
                        }
                    }
                    if (delta >= 2.0 && this.owner.func_70661_as().func_75500_f()) {
                        this.owner.func_70661_as().func_75492_a(this.harvestTargetPoint.dPosX, this.harvestTargetPoint.dPosY, this.harvestTargetPoint.dPosZ, (double)this.owner.getSpeed());
                    }
                    if (delta < 2.5) {
                        CropEntry entry = RegistryMCA.getCropEntryById(this.apiId);
                        this.owner.func_71038_i();
                        this.owner.damageHeldItem(2);
                        if (entry.getCategory() != EnumCropCategory.SUGARCANE) {
                            BlockHelper.setBlock((World)this.owner.field_70170_p, (int)this.harvestTargetPoint.iPosX, (int)(this.harvestTargetPoint.iPosY - 1), (int)this.harvestTargetPoint.iPosZ, (Block)Blocks.field_150458_ak);
                            BlockHelper.setBlock((World)this.owner.field_70170_p, (int)this.harvestTargetPoint.iPosX, (int)this.harvestTargetPoint.iPosY, (int)this.harvestTargetPoint.iPosZ, (Block)entry.getCropBlock());
                        } else {
                            BlockHelper.setBlock((World)this.owner.field_70170_p, (int)this.harvestTargetPoint.iPosX, (int)this.harvestTargetPoint.iPosY, (int)this.harvestTargetPoint.iPosZ, (Block)Blocks.field_150350_a);
                        }
                        for (ItemStack stack : entry.getStacksOnHarvest()) {
                            if (stack == null) continue;
                            this.addItemStackToInventory(stack);
                        }
                        this.harvestTargetPoint = Point3D.ZERO;
                    }
                }
            }
            --this.activityInterval;
        }
        catch (MappingNotFoundException e) {
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.isAIActive.setValue((Object)false);
        this.seedsRequired = 0;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("isFarmingActive", this.isAIActive.getBoolean().booleanValue());
        this.farmCenterPoint.writeToNBT("farmCenterPoint", nbt);
        this.harvestTargetPoint.writeToNBT("harvestTargetPoint", nbt);
        nbt.func_74768_a("apiId", this.apiId);
        nbt.func_74768_a("farmingActivityInterval", this.activityInterval);
        nbt.func_74757_a("farmCreatedFlag", this.farmCreatedFlag);
        nbt.func_74768_a("radius", this.radius);
        nbt.func_74757_a("doCreate", this.doCreate);
        nbt.func_74778_a("schematic", this.schematic);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.isAIActive.setValue((Object)nbt.func_74767_n("isFarmingActive"));
        this.farmCenterPoint = Point3D.readFromNBT((String)"farmCenterPoint", (NBTTagCompound)nbt);
        this.harvestTargetPoint = Point3D.readFromNBT((String)"harvestTargetPoint", (NBTTagCompound)nbt);
        this.apiId = nbt.func_74762_e("apiId");
        this.activityInterval = nbt.func_74762_e("farmingActivityInterval");
        this.farmCreatedFlag = nbt.func_74767_n("farmCreatedFlag");
        this.radius = nbt.func_74762_e("radius");
        this.doCreate = nbt.func_74767_n("doCreate");
        this.schematic = nbt.func_74779_i("schematic");
    }

    public void startFarming(EntityPlayer player, int apiId, int radius, boolean doCreate) {
        try {
            CropEntry entry = RegistryMCA.getCropEntryById(apiId);
            switch (entry.getCategory()) {
                case WHEAT: {
                    this.schematic = "/assets/mca/schematic/wheat1.schematic";
                    break;
                }
                case MELON: {
                    this.schematic = "/assets/mca/schematic/melon1.schematic";
                    break;
                }
                case SUGARCANE: {
                    this.schematic = "/assets/mca/schematic/sugarcane1.schematic";
                }
            }
            SortedMap schematicData = SchematicHandler.readSchematic((String)this.schematic);
            this.seedsRequired = SchematicHandler.countOccurencesOfBlockObj((Map)schematicData, (BlockObj)new BlockObj(Blocks.field_150325_L, entry.getCategory().getReferenceMeta()));
            if (doCreate && !this.owner.getInventory().containsCountOf(entry.getSeedItem(), this.seedsRequired)) {
                this.owner.say("farming.noseeds", player, entry.getCropName().toLowerCase(), this.seedsRequired);
                return;
            }
            if (player != null && !this.owner.getInventory().contains(ItemHoe.class)) {
                this.owner.say("farming.nohoe", player);
                return;
            }
            this.assigningPlayer = player != null ? player.func_110124_au().toString() : "none";
            this.activityInterval = 0;
            this.apiId = apiId;
            this.radius = radius;
            this.doCreate = doCreate;
            this.farmCenterPoint = new Point3D(this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v);
            this.harvestTargetPoint = Point3D.ZERO;
            this.farmCreatedFlag = false;
            this.isBuildingFarm = false;
            this.isAIActive.setValue((Object)true);
            this.owner.setHeldItem(this.owner.getInventory().getBestItemOfType(ItemHoe.class).func_77973_b());
        }
        catch (MappingNotFoundException e) {
            this.reset();
        }
    }

    @Override
    protected String getName() {
        return "Farming";
    }
}

