/*
 * Decompiled with CFR 0.152.
 */
package mca.core.forge;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mca.core.MCA;
import mca.core.minecraft.ModAchievements;
import mca.core.minecraft.ModItems;
import mca.data.NBTPlayerData;
import mca.data.PlayerData;
import mca.data.PlayerDataCollection;
import mca.entity.EntityGrimReaper;
import mca.entity.EntityHuman;
import mca.enums.EnumBabyState;
import mca.enums.EnumProfession;
import mca.enums.EnumProfessionGroup;
import mca.items.ItemGemCutter;
import mca.packets.PacketPlaySoundOnPlayer;
import mca.packets.PacketPlayerDataLogin;
import mca.packets.PacketSpawnLightning;
import mca.packets.PacketSyncConfig;
import mca.util.Utilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiLanguage;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.Vec3;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import radixcore.math.Point3D;
import radixcore.util.BlockHelper;
import radixcore.util.RadixLogic;
import radixcore.util.RadixMath;
import radixcore.util.SchematicHandler;

public class EventHooksFML {
    public static boolean playPortalAnimation;
    private static int summonCounter;
    private static Point3D summonPos;
    private static World summonWorld;
    private int clientTickCounter;
    private int serverTickCounter;

    @SubscribeEvent
    public void onConfigChanges(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.modID.equals("MCA")) {
            MCA.getConfig().getInstance().save();
            MCA.getConfig().syncConfiguration();
        }
    }

    @SubscribeEvent
    public void playerLoggedInEventHandler(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerDataCollection dataCollection = PlayerDataCollection.get();
        EntityPlayer player = event.player;
        NBTPlayerData nbtData = null;
        PlayerData oldData = new PlayerData(player);
        boolean setPermanentId = false;
        if (oldData.dataExists()) {
            oldData = (PlayerData)oldData.readDataFromFile(event.player, PlayerData.class, null);
            dataCollection.migrateOldPlayerData(player, oldData);
            nbtData = dataCollection.getPlayerData(player.func_110124_au());
        } else if (dataCollection.getPlayerData(player.func_110124_au()) == null) {
            NBTPlayerData nbtPlayerData = new NBTPlayerData();
            dataCollection.putPlayerData(player.func_110124_au(), nbtPlayerData);
            nbtData = nbtPlayerData;
            setPermanentId = true;
        } else {
            nbtData = dataCollection.getPlayerData(player.func_110124_au());
        }
        if (nbtData != null) {
            MCA.getPacketHandler().sendPacketToPlayer(new PacketPlayerDataLogin(nbtData), (EntityPlayerMP)player);
            if (setPermanentId) {
                nbtData.setPermanentId(RadixLogic.generatePermanentEntityId((Entity)player));
            }
            if (!nbtData.getHasChosenDestiny() && !player.field_71071_by.func_146028_b((Item)ModItems.crystalBall) && MCA.getConfig().giveCrystalBall) {
                player.field_71071_by.func_70441_a(new ItemStack((Item)ModItems.crystalBall));
            }
        }
        MCA.getPacketHandler().sendPacketToPlayer(new PacketSyncConfig(MCA.getConfig()), (EntityPlayerMP)event.player);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void clientTickEventHandler(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen currentScreen = mc.field_71462_r;
        if (currentScreen instanceof GuiMainMenu && MCA.myPlayerData != null) {
            playPortalAnimation = false;
            MCA.destinyCenterPoint = null;
            MCA.destinySpawnFlag = false;
            MCA.myPlayerData = null;
            MCA.resetConfig();
        }
        if (currentScreen instanceof GuiLanguage) {
            MCA.reloadLanguage = true;
        } else if (MCA.reloadLanguage) {
            MCA.reloadLanguage = false;
            MCA.getLanguageManager().loadLanguage(MCA.getLanguageManager().getGameLanguageID());
        }
        if (playPortalAnimation) {
            EntityClientPlayerMP player = mc.field_71439_g;
            if (player == null) {
                return;
            }
            player.field_71080_cy = player.field_71086_bY;
            player.field_71086_bY -= 0.0125f;
            if (player.field_71086_bY <= 0.0f) {
                playPortalAnimation = false;
            }
        }
        if (this.clientTickCounter <= 0) {
            this.clientTickCounter = 10;
            if (MCA.destinySpawnFlag) {
                SchematicHandler.spawnStructureRelativeToPoint((String)"/assets/mca/schematic/destiny-test.schematic", (Point3D)MCA.destinyCenterPoint, (World)mc.field_71441_e);
            }
        } else {
            --this.clientTickCounter;
        }
    }

    @SubscribeEvent
    public void serverTickEventHandler(TickEvent.ServerTickEvent event) {
        if (summonCounter > 0) {
            Utilities.spawnParticlesAroundPointS("portal", summonWorld, EventHooksFML.summonPos.iPosX, EventHooksFML.summonPos.iPosY, EventHooksFML.summonPos.iPosZ, 2);
            if (--summonCounter % 40 == 0) {
                double dX = EventHooksFML.summonPos.iPosX + EventHooksFML.summonWorld.field_73012_v.nextInt(6) * (RadixLogic.getBooleanWithProbability((int)50) ? 1 : -1);
                double dZ = EventHooksFML.summonPos.iPosZ + EventHooksFML.summonWorld.field_73012_v.nextInt(6) * (RadixLogic.getBooleanWithProbability((int)50) ? 1 : -1);
                double y = RadixLogic.getSpawnSafeTopLevel((World)summonWorld, (int)((int)dX), (int)((int)dZ));
                NetworkRegistry.TargetPoint lightningTarget = new NetworkRegistry.TargetPoint(EventHooksFML.summonWorld.field_73011_w.field_76574_g, dX, y, dZ, 64.0);
                EntityLightningBolt lightning = new EntityLightningBolt(summonWorld, dX, y, dZ);
                summonWorld.func_72838_d((Entity)lightning);
                MCA.getPacketHandler().sendPacketToAllAround(new PacketSpawnLightning(new Point3D(dX, y, dZ)), lightningTarget);
                if (summonCounter == 80) {
                    NetworkRegistry.TargetPoint summonTarget = new NetworkRegistry.TargetPoint(EventHooksFML.summonWorld.field_73011_w.field_76574_g, (double)EventHooksFML.summonPos.iPosX, (double)EventHooksFML.summonPos.iPosY, (double)EventHooksFML.summonPos.iPosZ, 32.0);
                    MCA.getPacketHandler().sendPacketToAllAround(new PacketPlaySoundOnPlayer("mca:reaper.summon"), summonTarget);
                }
            }
            if (summonCounter == 0) {
                EntityGrimReaper reaper = new EntityGrimReaper(summonWorld);
                reaper.func_70107_b(EventHooksFML.summonPos.iPosX, EventHooksFML.summonPos.iPosY, EventHooksFML.summonPos.iPosZ);
                summonWorld.func_72838_d((Entity)reaper);
                summonPos = null;
                summonWorld = null;
            }
        }
        if (this.serverTickCounter <= 0 && MCA.getConfig().guardSpawnRate > 0) {
            ArrayList<EntityHuman> humans = new ArrayList<EntityHuman>();
            for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
                for (Object obj : world.field_72996_f) {
                    if (!(obj instanceof EntityHuman)) continue;
                    humans.add((EntityHuman)((Object)obj));
                }
            }
            if (!humans.isEmpty()) {
                for (int i = 0; i < 3; ++i) {
                    int numberOfVillagersAroundMe;
                    int neededNumberOfGuards;
                    EntityHuman human = (EntityHuman)((Object)humans.get(RadixMath.getNumberInRange((int)0, (int)(humans.size() - 1))));
                    List villagersAroundMe = RadixLogic.getAllEntitiesOfTypeWithinDistance(EntityHuman.class, (Entity)human, (int)50);
                    int numberOfGuardsAroundMe = this.getNumberOfGuardsFromEntityList(villagersAroundMe);
                    if (numberOfGuardsAroundMe >= (neededNumberOfGuards = (numberOfVillagersAroundMe = villagersAroundMe.size() - numberOfGuardsAroundMe) / MCA.getConfig().guardSpawnRate)) continue;
                    EntityHuman guard = new EntityHuman(human.field_70170_p, RadixLogic.getBooleanWithProbability((int)50), EnumProfession.Guard.getId(), false);
                    Vec3 pos = RandomPositionGenerator.func_75463_a((EntityCreature)human, (int)10, (int)1);
                    if (pos == null) continue;
                    Point3D posAsPoint = new Point3D(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                    if (!BlockHelper.canBlockSeeTheSky((World)human.field_70170_p, (int)posAsPoint.iPosX, (int)((int)human.field_70163_u), (int)posAsPoint.iPosZ)) continue;
                    guard.func_70107_b(pos.field_72450_a, (int)human.field_70163_u, pos.field_72449_c);
                    human.field_70170_p.func_72838_d((Entity)guard);
                }
            }
            this.serverTickCounter = 1200;
        }
        if (this.serverTickCounter <= 0 && MCA.getConfig().replenishEmptyVillages && RadixLogic.getBooleanWithProbability((int)25)) {
            for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
                block4: for (Object obj : world.field_72982_D.func_75540_b()) {
                    Village village = (Village)obj;
                    int populationCapacity = village.func_75567_c();
                    int population = 0;
                    double posX = village.func_75577_a().field_71574_a;
                    double posY = village.func_75577_a().field_71572_b;
                    double posZ = village.func_75577_a().field_71573_c;
                    for (Entity entity : RadixLogic.getAllEntitiesWithinDistanceOfCoordinates((World)world, (double)posX, (double)posY, (double)posZ, (int)village.func_75568_b())) {
                        if (!(entity instanceof EntityHuman)) continue;
                        EntityHuman human = (EntityHuman)entity;
                        if (human.getProfessionGroup() != EnumProfessionGroup.Guard) {
                            ++population;
                        }
                        if (human.getBabyState() == EnumBabyState.NONE) continue;
                        ++population;
                    }
                    if (population >= populationCapacity) continue;
                    for (int tries = 0; tries < 3; ++tries) {
                        posX += (double)(world.field_73012_v.nextInt(village.func_75568_b()) * (RadixLogic.getBooleanWithProbability((int)50) ? 1 : -1));
                        posZ += (double)(world.field_73012_v.nextInt(village.func_75568_b()) * (RadixLogic.getBooleanWithProbability((int)50) ? 1 : -1));
                        double dY = RadixLogic.getSpawnSafeTopLevel((World)world, (int)((int)(posX += 0.5)), (int)((int)(posZ += 0.5)));
                        if (!(dY - posY <= 4.0)) continue;
                        Point3D pointOfSpawn = new Point3D(posX, dY, posZ);
                        MCA.naturallySpawnVillagers(pointOfSpawn, (World)world, -1);
                        continue block4;
                    }
                }
            }
        }
        --this.serverTickCounter;
    }

    @SubscribeEvent
    public void itemCraftedEventHandler(PlayerEvent.ItemCraftedEvent event) {
        Item craftedItem = event.crafting.func_77973_b();
        EntityPlayer player = event.player;
        if (craftedItem == ModItems.diamondDust) {
            player.func_71029_a((StatBase)ModAchievements.craftDiamondDust);
        } else if (craftedItem == ModItems.coloredDiamondDust) {
            player.func_71029_a((StatBase)ModAchievements.craftColoredDiamondDust);
        } else if (craftedItem == ModItems.diamondHeart || craftedItem == ModItems.diamondOval || craftedItem == ModItems.diamondSquare || craftedItem == ModItems.diamondStar || craftedItem == ModItems.diamondTiny || craftedItem == ModItems.diamondTriangle || craftedItem == ModItems.coloredDiamondHeart || craftedItem == ModItems.coloredDiamondOval || craftedItem == ModItems.coloredDiamondSquare || craftedItem == ModItems.coloredDiamondStar || craftedItem == ModItems.coloredDiamondTiny || craftedItem == ModItems.coloredDiamondTriangle) {
            player.func_71029_a((StatBase)ModAchievements.craftShapedDiamond);
        } else if (craftedItem == ModItems.engagementRingHeart || craftedItem == ModItems.engagementRingOval || craftedItem == ModItems.engagementRingSquare || craftedItem == ModItems.engagementRingStar || craftedItem == ModItems.engagementRingTiny || craftedItem == ModItems.engagementRingTriangle || craftedItem == ModItems.ringHeartColored || craftedItem == ModItems.ringOvalColored || craftedItem == ModItems.ringSquareColored || craftedItem == ModItems.ringStarColored || craftedItem == ModItems.ringTinyColored || craftedItem == ModItems.ringTriangleColored || craftedItem == ModItems.engagementRingHeartRG || craftedItem == ModItems.engagementRingOvalRG || craftedItem == ModItems.engagementRingSquareRG || craftedItem == ModItems.engagementRingStarRG || craftedItem == ModItems.engagementRingTinyRG || craftedItem == ModItems.engagementRingTriangleRG || craftedItem == ModItems.ringHeartColoredRG || craftedItem == ModItems.ringOvalColoredRG || craftedItem == ModItems.ringSquareColoredRG || craftedItem == ModItems.ringStarColoredRG || craftedItem == ModItems.ringTinyColoredRG || craftedItem == ModItems.ringTriangleColoredRG) {
            player.func_71029_a((StatBase)ModAchievements.craftShapedRing);
        }
        for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
            ItemStack stack = event.craftMatrix.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemGemCutter) && stack.func_77973_b() != ModItems.needleAndString) continue;
            stack.func_96631_a(1, event.player.func_70681_au());
            if (stack.func_77960_j() >= stack.func_77958_k()) break;
            event.player.field_71071_by.func_70441_a(stack);
            break;
        }
    }

    @SubscribeEvent
    public void itemSmeltedEventHandler(PlayerEvent.ItemSmeltedEvent event) {
        Item smeltedItem = event.smelting.func_77973_b();
        EntityPlayer player = event.player;
        if (smeltedItem == ModItems.coloredDiamond) {
            player.func_71029_a((StatBase)ModAchievements.smeltColoredDiamond);
        }
    }

    public static void setReaperSummonPoint(World worldObj, Point3D point) {
        summonWorld = worldObj;
        summonPos = point;
        summonCounter = 120;
    }

    private int getNumberOfGuardsFromEntityList(List<Entity> entityList) {
        int returnValue = 0;
        for (Entity entity : entityList) {
            EntityHuman human;
            if (!(entity instanceof EntityHuman) || (human = (EntityHuman)entity).getProfessionGroup() != EnumProfessionGroup.Guard) continue;
            ++returnValue;
        }
        return returnValue;
    }
}

