/*
 * Decompiled with CFR 0.152.
 */
package mca.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import mca.core.MCA;
import mca.core.minecraft.ModAchievements;
import mca.core.minecraft.ModItems;
import mca.data.NBTPlayerData;
import mca.enums.EnumInteraction;
import mca.packets.PacketOpenBabyNameGUI;
import mca.packets.PacketOpenPrompt;
import mca.util.MarriageHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import radixcore.packets.AbstractPacket;

public class PacketInteractWithPlayerS
extends AbstractPacket
implements IMessage,
IMessageHandler<PacketInteractWithPlayerS, IMessage> {
    private int interactionId;
    private int entityId;

    public PacketInteractWithPlayerS() {
    }

    public PacketInteractWithPlayerS(int interactionId, int entityId) {
        this.interactionId = interactionId;
        this.entityId = entityId;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.interactionId = byteBuf.readInt();
        this.entityId = byteBuf.readInt();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.interactionId);
        byteBuf.writeInt(this.entityId);
    }

    public IMessage onMessage(PacketInteractWithPlayerS packet, MessageContext context) {
        EntityPlayer sender = this.getPlayer(context);
        EntityPlayer target = (EntityPlayer)sender.field_70170_p.func_73045_a(packet.entityId);
        NBTPlayerData senderData = MCA.getPlayerData(sender);
        NBTPlayerData targetData = MCA.getPlayerData(target);
        EnumInteraction interaction = EnumInteraction.fromId(packet.interactionId);
        boolean senderHasWeddingRing = false;
        for (ItemStack stack : sender.field_71071_by.field_70462_a) {
            Item item;
            if (stack == null || (item = stack.func_77973_b()) != ModItems.weddingRing && item != ModItems.weddingRingRG) continue;
            senderHasWeddingRing = true;
        }
        block0 : switch (interaction) {
            case ASKTOMARRY: {
                if (targetData.getSpousePermanentId() != 0 || targetData.getIsEngaged()) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(MCA.getLanguageManager().getString("interactionp.marry.fail.targetalreadymarried", new Object[]{target.func_70005_c_()})));
                    break;
                }
                if (senderData.getSpousePermanentId() != 0 || senderData.getIsEngaged()) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(MCA.getLanguageManager().getString("interactionp.marry.fail.alreadymarried")));
                    break;
                }
                if (!senderHasWeddingRing) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(MCA.getLanguageManager().getString("interactionp.marry.fail.noweddingring")));
                    break;
                }
                sender.func_145747_a((IChatComponent)new ChatComponentText(MCA.getLanguageManager().getString("interactionp.marry.sent", new Object[]{target.func_70005_c_()})));
                MCA.getPacketHandler().sendPacketToPlayer(new PacketOpenPrompt(sender, target, interaction), (EntityPlayerMP)target);
                break;
            }
            case DIVORCE: {
                MarriageHandler.endMarriage(sender, target);
                sender.func_145747_a((IChatComponent)new ChatComponentText(MCA.getLanguageManager().getString("\u00a7C" + MCA.getLanguageManager().getString("interactionp.divorce.notify", new Object[]{target.func_70005_c_()}))));
                target.func_145747_a((IChatComponent)new ChatComponentText(MCA.getLanguageManager().getString("\u00a7C" + MCA.getLanguageManager().getString("interactionp.divorce.notify", new Object[]{sender.func_70005_c_()}))));
                break;
            }
            case HAVEBABY: {
                if (senderData.getShouldHaveBaby()) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(MCA.getLanguageManager().getString("interactionp.havebaby.fail.alreadyexists", new Object[]{target.func_70005_c_()})));
                    break;
                }
                sender.func_145747_a((IChatComponent)new ChatComponentText(MCA.getLanguageManager().getString("interactionp.havebaby.sent", new Object[]{target.func_70005_c_()})));
                MCA.getPacketHandler().sendPacketToPlayer(new PacketOpenPrompt(sender, target, interaction), (EntityPlayerMP)target);
                break;
            }
            case ASKTOMARRY_ACCEPT: {
                sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7A" + MCA.getLanguageManager().getString("interactionp.marry.success", new Object[]{target.func_70005_c_()})));
                target.func_145747_a((IChatComponent)new ChatComponentText("\u00a7A" + MCA.getLanguageManager().getString("interactionp.marry.success", new Object[]{sender.func_70005_c_()})));
                MarriageHandler.startMarriage(sender, target);
                for (int i = 0; i < target.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack = target.field_71071_by.func_70301_a(i);
                    if (stack == null || stack.func_77973_b() != ModItems.weddingRing && stack.func_77973_b() != ModItems.weddingRingRG) continue;
                    target.field_71071_by.func_146026_a(stack.func_77973_b());
                    break block0;
                }
                break;
            }
            case HAVEBABY_ACCEPT: {
                senderData.setShouldHaveBaby(true);
                targetData.setShouldHaveBaby(true);
                boolean isMale = new Random().nextBoolean();
                ItemStack stack = new ItemStack((Item)(isMale ? ModItems.babyBoy : ModItems.babyGirl));
                target.field_71071_by.func_70441_a(stack);
                Achievement achievement = isMale ? ModAchievements.babyBoy : ModAchievements.babyGirl;
                sender.func_71029_a((StatBase)achievement);
                target.func_71029_a((StatBase)achievement);
                MCA.getPacketHandler().sendPacketToPlayer(new PacketOpenBabyNameGUI(isMale), (EntityPlayerMP)target);
            }
        }
        return null;
    }
}

