/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fiskfille.heroes.common.arrowtype.ArrowType;
import fiskfille.heroes.common.hero.Hero;
import fiskfille.heroes.common.hero.speedster.Speedster;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class SuperHeroesAPI {
    private static List<Hero> heroes = Lists.newArrayList();
    private static List<Block> unphasables = Lists.newArrayList();
    private static Map<ItemStack, ArrowType> arrowTypes = Maps.newLinkedHashMap();

    public static void registerHero(Hero hero) {
        if (!heroes.contains(hero)) {
            heroes.add(hero);
        } else {
            Logger.getLogger("[HeroAPI]").log(Level.WARNING, hero.getName() + " has already been registered!");
        }
    }

    public static List<Hero> getHeroes() {
        return heroes;
    }

    public static Hero getHeroFromName(String name) {
        for (Hero hero : heroes) {
            if (!hero.getName().equals(name)) continue;
            return hero;
        }
        return null;
    }

    public static void registerUnphasable(Block block) {
        if (!unphasables.contains(block)) {
            unphasables.add(block);
        } else {
            Logger.getLogger("[HeroAPI]").log(Level.WARNING, "'" + block.func_149739_a() + "' has already been defined as unphasable!");
        }
    }

    public static List<Block> getUnphasables() {
        return unphasables;
    }

    public static List<Speedster> getSpeedsters() {
        ArrayList list = Lists.newArrayList();
        for (Hero hero : heroes) {
            if (!(hero instanceof Speedster)) continue;
            list.add((Speedster)hero);
        }
        return list;
    }

    public static void registerArrowType(Item item, int metadata, ArrowType arrowType) {
        arrowTypes.put(new ItemStack(item, 1, metadata), arrowType);
    }

    public static Map<ItemStack, ArrowType> getArrowTypes() {
        return arrowTypes;
    }

    public static ArrowType getArrowTypeForItem(Item item, int metadata) {
        for (Map.Entry<ItemStack, ArrowType> e : arrowTypes.entrySet()) {
            ItemStack itemstack = e.getKey();
            if (itemstack == null || itemstack.func_77973_b() != item || itemstack.func_77960_j() != metadata) continue;
            return e.getValue();
        }
        return null;
    }

    public static ItemStack getItemForId(int id) {
        int i = 0;
        for (Map.Entry<ItemStack, ArrowType> e : arrowTypes.entrySet()) {
            if (i == id) {
                return e.getKey();
            }
            ++i;
        }
        return null;
    }

    public static ItemStack getItemForArrowType(ArrowType type) {
        for (Map.Entry<ItemStack, ArrowType> e : arrowTypes.entrySet()) {
            if (type != e.getValue()) continue;
            return e.getKey();
        }
        return null;
    }

    public static ArrowType getArrowTypeFromId(int id) {
        int i = 0;
        for (Map.Entry<ItemStack, ArrowType> e : arrowTypes.entrySet()) {
            if (i == id) {
                return e.getValue();
            }
            ++i;
        }
        return null;
    }

    public static int getArrowTypeId(ArrowType type) {
        int id = 0;
        for (Map.Entry<ItemStack, ArrowType> e : arrowTypes.entrySet()) {
            if (e.getValue() == type) {
                return id;
            }
            ++id;
        }
        return 0;
    }
}

