/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.client.gui;

import cpw.mods.fml.client.GuiScrollingList;
import fiskfille.heroes.client.gui.GuiSuitFabricator;
import fiskfille.heroes.common.helper.SHHelper;
import fiskfille.heroes.common.helper.SHRenderHelper;
import fiskfille.heroes.common.hero.Hero;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiHeroList
extends GuiScrollingList {
    private final Minecraft client;
    protected final int listWidth;
    protected final int listHeight;
    protected final int top;
    protected final int bottom;
    private final int right;
    protected final int left;
    protected final int slotHeight;
    private static int scrollUpActionId;
    private static int scrollDownActionId;
    protected static int mouseX;
    protected static int mouseY;
    private static float initialMouseClickY;
    private static float scrollFactor;
    private static float scrollDistance;
    private static int selectedIndex;
    private static long lastClickTime;
    private static boolean field_25123_p;
    private static boolean field_27262_q;
    private static int field_27261_r;
    private GuiSuitFabricator parent;
    private List<Hero> heroes;

    public GuiHeroList(GuiSuitFabricator gui, List<Hero> list, int xSize, int ySize, int listWidth) {
        this(Minecraft.func_71410_x(), listWidth, gui.field_146295_m, (gui.field_146295_m - ySize) / 2 + 18, (gui.field_146295_m - ySize) / 2 + 18 + 70, (gui.field_146294_l - xSize) / 2 + 15, 11);
        this.parent = gui;
        this.heroes = list;
    }

    public GuiHeroList(Minecraft client, int width, int height, int top, int bottom, int left, int entryHeight) {
        super(client, width, height, top, bottom, left, entryHeight);
        this.client = client;
        this.listWidth = width;
        this.listHeight = height;
        this.top = top;
        this.bottom = bottom;
        this.slotHeight = entryHeight;
        this.left = left;
        this.right = width + left;
    }

    public void func_27258_a(boolean p_27258_1_) {
        field_25123_p = p_27258_1_;
    }

    protected void func_27259_a(boolean p_27259_1_, int p_27259_2_) {
        field_27262_q = p_27259_1_;
        field_27261_r = p_27259_2_;
        if (!p_27259_1_) {
            field_27261_r = 0;
        }
    }

    protected int getSize() {
        return this.heroes.size();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.parent.selectHero(index);
    }

    protected boolean isSelected(int index) {
        return this.parent.heroSelected(index);
    }

    protected void drawBackground() {
    }

    protected int getContentHeight() {
        return this.getSize() * 11;
    }

    protected void drawSlot(int listIndex, int var2, int y, int var4, Tessellator var5) {
        Hero hero = this.heroes.get(listIndex);
        if (hero != null) {
            boolean unicode = this.parent.getFontRenderer().func_82883_a();
            this.parent.getFontRenderer().func_78264_a(true);
            String s = SHHelper.formatHero(hero);
            String s1 = this.parent.getFontRenderer().func_78269_a(s, this.listWidth - 10 - this.parent.getFontRenderer().func_78256_a("..."));
            if (this.parent.getFontRenderer().func_78256_a(s) > this.parent.getFontRenderer().func_78256_a(s1)) {
                s1 = s1 + "...";
            }
            this.parent.getFontRenderer().func_78276_b(s1, this.left + 3, y - 1, 0xFFFFFF);
            this.parent.getFontRenderer().func_78264_a(unicode);
        }
    }

    public int func_27256_c(int p_27256_1_, int p_27256_2_) {
        int var3 = this.left + 1;
        int var4 = this.left + this.listWidth - 7;
        int var5 = p_27256_2_ - this.top - field_27261_r + (int)scrollDistance - 4;
        int var6 = var5 / this.slotHeight;
        return p_27256_1_ >= var3 && p_27256_1_ <= var4 && var6 >= 0 && var5 >= 0 && var6 < this.getSize() ? var6 : -1;
    }

    public void registerScrollButtons(List p_22240_1_, int p_22240_2_, int p_22240_3_) {
        scrollUpActionId = p_22240_2_;
        scrollDownActionId = p_22240_3_;
    }

    private void applyScrollLimits() {
        int i = this.getContentHeight() - (this.bottom - this.top - 4);
        if (i < 0) {
            i /= 2;
        }
        if (scrollDistance < 0.0f) {
            scrollDistance = 0.0f;
        }
        if (scrollDistance > (float)i) {
            scrollDistance = i;
        }
    }

    public void actionPerformed(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == scrollUpActionId) {
                scrollDistance -= (float)(this.slotHeight * 2 / 3);
                initialMouseClickY = -2.0f;
                this.applyScrollLimits();
            } else if (button.field_146127_k == scrollDownActionId) {
                scrollDistance += (float)(this.slotHeight * 2 / 3);
                initialMouseClickY = -2.0f;
                this.applyScrollLimits();
            }
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        int var14;
        int k;
        int l;
        int j;
        int i;
        SHRenderHelper.startGlScissor(this.left, this.top, this.listWidth, this.bottom - this.top);
        GuiHeroList.mouseX = mouseX;
        GuiHeroList.mouseY = mouseY;
        this.drawBackground();
        int listLength = this.getSize();
        int scrollBarXStart = this.left + this.listWidth - 6;
        int scrollBarXEnd = scrollBarXStart + 6;
        int boxLeft = this.left;
        int boxRight = scrollBarXStart - 1;
        if (Mouse.isButtonDown((int)0)) {
            if (initialMouseClickY == -1.0f) {
                boolean flag = true;
                if (mouseY >= this.top && mouseY <= this.bottom) {
                    i = mouseY - this.top - field_27261_r + (int)scrollDistance - 4;
                    j = i / this.slotHeight;
                    if (mouseX >= boxLeft && mouseX <= boxRight && j >= 0 && i >= 0 && j < listLength) {
                        boolean var12 = j == selectedIndex && System.currentTimeMillis() - lastClickTime < 250L;
                        this.elementClicked(j, var12);
                        selectedIndex = j;
                        lastClickTime = System.currentTimeMillis();
                    } else if (mouseX >= boxLeft && mouseX <= boxRight && i < 0) {
                        this.func_27255_a(mouseX - boxLeft, mouseY - this.top + (int)scrollDistance - 4);
                        flag = false;
                    }
                    if (mouseX >= scrollBarXStart && mouseX <= scrollBarXEnd) {
                        scrollFactor = -1.0f;
                        l = this.getContentHeight() - (this.bottom - this.top - 4);
                        if (l < 1) {
                            l = 1;
                        }
                        if ((k = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getContentHeight())) < 32) {
                            k = 32;
                        }
                        if (k > this.bottom - this.top - 8) {
                            k = this.bottom - this.top - 8;
                        }
                        scrollFactor /= (float)(this.bottom - this.top - k) / (float)l;
                    } else {
                        scrollFactor = 1.0f;
                    }
                    initialMouseClickY = flag ? (float)mouseY : -2.0f;
                } else {
                    initialMouseClickY = -2.0f;
                }
            } else if (initialMouseClickY >= 0.0f) {
                scrollDistance -= ((float)mouseY - initialMouseClickY) * scrollFactor;
                initialMouseClickY = mouseY;
            }
        } else {
            int wheel = Mouse.getDWheel();
            if (wheel != 0) {
                if (wheel > 0) {
                    wheel = -1;
                } else if (wheel < 0) {
                    wheel = 1;
                }
                scrollDistance += (float)(wheel * this.slotHeight / 2);
            }
            initialMouseClickY = -1.0f;
        }
        this.applyScrollLimits();
        Tessellator var18 = Tessellator.field_78398_a;
        if (this.client.field_71441_e != null) {
            this.drawGradientRect(this.left, this.top, this.right, this.bottom, -1072689136, -804253680);
        } else {
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2912);
            this.client.field_71446_o.func_110577_a(Gui.field_110325_k);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float var17 = 32.0f;
            var18.func_78382_b();
            var18.func_78378_d(0x202020);
            var18.func_78374_a((double)this.left, (double)this.bottom, 0.0, (double)((float)this.left / var17), (double)((float)(this.bottom + (int)scrollDistance) / var17));
            var18.func_78374_a((double)this.right, (double)this.bottom, 0.0, (double)((float)this.right / var17), (double)((float)(this.bottom + (int)scrollDistance) / var17));
            var18.func_78374_a((double)this.right, (double)this.top, 0.0, (double)((float)this.right / var17), (double)((float)(this.top + (int)scrollDistance) / var17));
            var18.func_78374_a((double)this.left, (double)this.top, 0.0, (double)((float)this.left / var17), (double)((float)(this.top + (int)scrollDistance) / var17));
            var18.func_78381_a();
        }
        i = this.top + 4 - (int)scrollDistance;
        if (field_27262_q) {
            this.func_27260_a(boxRight, i, var18);
        }
        for (j = 0; j < listLength; ++j) {
            l = i + j * this.slotHeight + field_27261_r;
            k = this.slotHeight - 4;
            if (l > this.bottom || l + k < this.top) continue;
            if (field_25123_p && this.isSelected(j)) {
                var14 = boxLeft;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3553);
                var18.func_78382_b();
                var18.func_78378_d(0x808080);
                var18.func_78374_a((double)var14, (double)(l + k + 2), 0.0, 0.0, 1.0);
                var18.func_78374_a((double)boxRight, (double)(l + k + 2), 0.0, 1.0, 1.0);
                var18.func_78374_a((double)boxRight, (double)(l - 2), 0.0, 1.0, 0.0);
                var18.func_78374_a((double)var14, (double)(l - 2), 0.0, 0.0, 0.0);
                var18.func_78378_d(0);
                var18.func_78374_a((double)(var14 + 1), (double)(l + k + 1), 0.0, 0.0, 1.0);
                var18.func_78374_a((double)(boxRight - 1), (double)(l + k + 1), 0.0, 1.0, 1.0);
                var18.func_78374_a((double)(boxRight - 1), (double)(l - 1), 0.0, 1.0, 0.0);
                var18.func_78374_a((double)(var14 + 1), (double)(l - 1), 0.0, 0.0, 0.0);
                var18.func_78381_a();
                GL11.glEnable((int)3553);
            }
            this.drawSlot(j, boxRight, l, k, var18);
        }
        GL11.glDisable((int)2929);
        int var20 = 4;
        if (this.client.field_71441_e == null) {
            this.overlayBackground(0, this.top, 255, 255);
            this.overlayBackground(this.bottom, this.listHeight, 255, 255);
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3553);
        var18.func_78382_b();
        var18.func_78384_a(0, 0);
        var18.func_78374_a((double)this.left, (double)(this.top + var20), 0.0, 0.0, 1.0);
        var18.func_78374_a((double)this.right, (double)(this.top + var20), 0.0, 1.0, 1.0);
        var18.func_78384_a(0, 255);
        var18.func_78374_a((double)this.right, (double)this.top, 0.0, 1.0, 0.0);
        var18.func_78374_a((double)this.left, (double)this.top, 0.0, 0.0, 0.0);
        var18.func_78381_a();
        var18.func_78382_b();
        var18.func_78384_a(0, 255);
        var18.func_78374_a((double)this.left, (double)this.bottom, 0.0, 0.0, 1.0);
        var18.func_78374_a((double)this.right, (double)this.bottom, 0.0, 1.0, 1.0);
        var18.func_78384_a(0, 0);
        var18.func_78374_a((double)this.right, (double)(this.bottom - var20), 0.0, 1.0, 0.0);
        var18.func_78374_a((double)this.left, (double)(this.bottom - var20), 0.0, 0.0, 0.0);
        var18.func_78381_a();
        l = this.getContentHeight() - (this.bottom - this.top - 4);
        if (l > 0) {
            k = (this.bottom - this.top) * (this.bottom - this.top) / this.getContentHeight();
            if (k < 32) {
                k = 32;
            }
            if (k > this.bottom - this.top - 8) {
                k = this.bottom - this.top - 8;
            }
            if ((var14 = (int)scrollDistance * (this.bottom - this.top - k) / l + this.top) < this.top) {
                var14 = this.top;
            }
            var18.func_78382_b();
            var18.func_78384_a(0, 255);
            var18.func_78374_a((double)scrollBarXStart, (double)this.bottom, 0.0, 0.0, 1.0);
            var18.func_78374_a((double)scrollBarXEnd, (double)this.bottom, 0.0, 1.0, 1.0);
            var18.func_78374_a((double)scrollBarXEnd, (double)this.top, 0.0, 1.0, 0.0);
            var18.func_78374_a((double)scrollBarXStart, (double)this.top, 0.0, 0.0, 0.0);
            var18.func_78381_a();
            var18.func_78382_b();
            var18.func_78384_a(0x808080, 255);
            var18.func_78374_a((double)scrollBarXStart, (double)(var14 + k), 0.0, 0.0, 1.0);
            var18.func_78374_a((double)scrollBarXEnd, (double)(var14 + k), 0.0, 1.0, 1.0);
            var18.func_78374_a((double)scrollBarXEnd, (double)var14, 0.0, 1.0, 0.0);
            var18.func_78374_a((double)scrollBarXStart, (double)var14, 0.0, 0.0, 0.0);
            var18.func_78381_a();
            var18.func_78382_b();
            var18.func_78384_a(0xC0C0C0, 255);
            var18.func_78374_a((double)scrollBarXStart, (double)(var14 + k - 1), 0.0, 0.0, 1.0);
            var18.func_78374_a((double)(scrollBarXEnd - 1), (double)(var14 + k - 1), 0.0, 1.0, 1.0);
            var18.func_78374_a((double)(scrollBarXEnd - 1), (double)var14, 0.0, 1.0, 0.0);
            var18.func_78374_a((double)scrollBarXStart, (double)var14, 0.0, 0.0, 0.0);
            var18.func_78381_a();
        }
        this.func_27257_b(mouseX, mouseY);
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        SHRenderHelper.endGlScissor();
    }

    private void overlayBackground(int p_22239_1_, int p_22239_2_, int p_22239_3_, int p_22239_4_) {
        Tessellator tessellator = Tessellator.field_78398_a;
        this.client.field_71446_o.func_110577_a(Gui.field_110325_k);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        tessellator.func_78382_b();
        tessellator.func_78384_a(0x404040, p_22239_4_);
        tessellator.func_78374_a(0.0, (double)p_22239_2_, 0.0, 0.0, (double)((float)p_22239_2_ / f));
        tessellator.func_78374_a((double)this.listWidth + 30.0, (double)p_22239_2_, 0.0, (double)((float)(this.listWidth + 30) / f), (double)((float)p_22239_2_ / f));
        tessellator.func_78384_a(0x404040, p_22239_3_);
        tessellator.func_78374_a((double)this.listWidth + 30.0, (double)p_22239_1_, 0.0, (double)((float)(this.listWidth + 30) / f), (double)((float)p_22239_1_ / f));
        tessellator.func_78374_a(0.0, (double)p_22239_1_, 0.0, 0.0, (double)((float)p_22239_1_ / f));
        tessellator.func_78381_a();
    }

    static {
        initialMouseClickY = -2.0f;
        selectedIndex = -1;
        lastClickTime = 0L;
        field_25123_p = true;
    }
}

