/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import fiskfille.heroes.client.treadmill.Treadmill;
import fiskfille.heroes.common.ability.Ability;
import fiskfille.heroes.common.config.SHConfig;
import fiskfille.heroes.common.container.InventoryQuiver;
import fiskfille.heroes.common.data.DataManager;
import fiskfille.heroes.common.data.SHData;
import fiskfille.heroes.common.data.SHPlayerData;
import fiskfille.heroes.common.helper.QuiverHelper;
import fiskfille.heroes.common.helper.SHHelper;
import fiskfille.heroes.common.helper.SHRenderHelper;
import fiskfille.heroes.common.helper.SpeedsterHelper;
import fiskfille.heroes.common.helper.TemperatureHelper;
import fiskfille.heroes.common.hero.Hero;
import fiskfille.heroes.common.item.ModItems;
import fiskfille.heroes.common.utilitybelt.EnumUtilityBelt;
import fiskfille.heroes.common.utilitybelt.UtilityBeltHandler;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeHooks;
import org.lwjgl.opengl.GL11;

public class GuiOverlay
extends Gui {
    private Minecraft mc = Minecraft.func_71410_x();
    private RenderItem itemRenderer = new RenderItem();
    private FontRenderer fontRenderer;
    public static final ResourceLocation icons = new ResourceLocation("fiskheroes", "textures/gui/icons.png");
    public static final ResourceLocation widgets = new ResourceLocation("fiskheroes", "textures/gui/widgets.png");
    protected int remainingHighlightTicks;
    protected ItemStack highlightingItemStack;
    protected int massWarningTimer;
    protected int maxMassWarningTimer = 15;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (!event.isCanceled()) {
            int width = event.resolution.func_78326_a();
            int height = event.resolution.func_78328_b();
            EntityClientPlayerMP player = this.mc.field_71439_g;
            this.fontRenderer = this.mc.field_71466_p;
            if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR) {
                this.renderIcons(event, width, height, (EntityPlayer)player);
                this.renderQuiverHotbar(event, width, height, (EntityPlayer)player);
                this.renderQuiverArrowHightlight(event, width, height, (EntityPlayer)player);
                this.renderTreadmillOverlay(event, width, height, (EntityPlayer)player);
                if (!this.mc.field_71442_b.func_78747_a() && this.mc.field_71442_b.func_78755_b()) {
                    this.renderArmorProtection(event, width, height, (EntityPlayer)player);
                    this.renderCryokinesis(event, width, height, (EntityPlayer)player, true);
                    this.renderShrinkCooldown(event, width, height, (EntityPlayer)player, true);
                    this.renderTemperature(event, width, height, (EntityPlayer)player);
                } else {
                    this.renderCryokinesis(event, width, height, (EntityPlayer)player, false);
                    this.renderShrinkCooldown(event, width, height, (EntityPlayer)player, false);
                }
            }
        }
    }

    public void renderIcons(RenderGameOverlayEvent.Pre event, int width, int height, EntityPlayer player) {
        int y;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Hero hero = SHHelper.getHero(player);
        ArrayList activeAbilities = Lists.newArrayList();
        int x = SHConfig.hudAlignLeft ? 0 : width;
        int n = y = SHConfig.hudAlignTop ? 0 : height - 5;
        if (hero != null) {
            int y1;
            for (Ability ability : hero.getAbilities()) {
                if (!ability.renderIcon(player)) continue;
                activeAbilities.add(ability);
            }
            this.mc.func_110434_K().func_110577_a(icons);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            int size = activeAbilities.size();
            if (size > 0) {
                GL11.glDisable((int)3553);
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.func_73729_b(x - (SHConfig.hudAlignLeft ? 0 : size * 22 + 1), (y += SHConfig.hudAlignTop ? 0 : -17) - (SHConfig.hudAlignTop ? 0 : 1), 0, 0, size * 22 + 1, 23);
                GL11.glEnable((int)3553);
            }
            for (int i = 0; i < size; ++i) {
                this.mc.func_110434_K().func_110577_a(icons);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Ability ability = (Ability)activeAbilities.get(i);
                int x1 = x + (SHConfig.hudAlignLeft ? (size - 1) * 22 : -22) - i * 22;
                y1 = y;
                this.func_73729_b(x1, y1, size > 2 ? (i == size - 1 ? 22 : (i == 0 ? 66 : 44)) : (size == 2 ? (i == 0 ? 66 : 22) : 0), 234, 22, 22);
                if (ability == Ability.utilityBelt) {
                    EnumUtilityBelt type = SHHelper.getUtilityBelt(player);
                    if (type == EnumUtilityBelt.FISTS) continue;
                    float f = UtilityBeltHandler.getCooldownCompletion(type);
                    int progress = (int)(f * 18.0f);
                    GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    this.func_73729_b(x1 + 2, y1 + 2, 18 + type.ordinal() * 18, 18, 18, 18);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (progress > 0) {
                        this.func_73729_b(x1 + 2, y1 + 2, 0, 18, progress, 18);
                        this.func_73729_b(x1 + 2, y1 + 2, 18 + type.ordinal() * 18, 18, progress, 18);
                    }
                    int usesLeft = type.maxUses - UtilityBeltHandler.timesUsed[type.ordinal()];
                    this.func_73731_b(this.fontRenderer, (usesLeft <= 0 ? EnumChatFormatting.RED : "") + "" + usesLeft, x1 + 21 - this.fontRenderer.func_78256_a(usesLeft + ""), y1 + 22 - this.fontRenderer.field_78288_b, -1);
                    continue;
                }
                this.func_73729_b(x1 + 2, y1 + 2, ability.getX(), ability.getY(), 18, 18);
            }
            if (activeAbilities.contains(Ability.superSpeed)) {
                int n2 = SHConfig.hudAlignTop ? 25 : -7;
                LinkedHashMap map = Maps.newLinkedHashMap();
                LinkedHashMap map1 = Maps.newLinkedHashMap();
                LinkedHashMap map2 = Maps.newLinkedHashMap();
                y1 = y += n2;
                int maxWidth = 0;
                for (int j = 0; j <= SpeedsterHelper.getMaxSpeedSetting(player); ++j) {
                    String type = SpeedsterHelper.getSpeedSettingList(player).get(j);
                    if (!map.containsKey(type)) {
                        map.put(type, 1);
                        continue;
                    }
                    map.put(type, (Integer)map.get(type) + 1);
                }
                int cap = 10;
                for (Map.Entry e : map.entrySet()) {
                    Object type = (String)e.getKey();
                    int n3 = (Integer)e.getValue();
                    map1.put(e.getKey(), n3);
                    while (n3 > cap) {
                        type = "-" + (String)type;
                        map1.put(type, Math.min(n3 -= cap, cap));
                    }
                }
                for (Map.Entry e : map1.entrySet()) {
                    map2.put(e.getKey(), Math.min((Integer)e.getValue(), cap));
                }
                int index = 0;
                int rows = 0;
                for (Map.Entry entry : map2.entrySet()) {
                    String type = (String)entry.getKey();
                    int amount = (Integer)entry.getValue();
                    int x1 = x + (SHConfig.hudAlignLeft ? 2 : -2);
                    int width1 = amount * 3 + amount - 1;
                    Vec3 color = SpeedsterHelper.getTrailType(player).getTrailColor();
                    while (type.startsWith("-")) {
                        type = type.substring(1);
                    }
                    if (type.equals("natural")) {
                        color = Vec3.func_72443_a((double)0.5, (double)0.7, (double)0.0);
                    } else if (type.equals("tachyon")) {
                        color = Vec3.func_72443_a((double)0.7, (double)0.2, (double)0.2);
                    } else if (type.equals("velocity9")) {
                        color = Vec3.func_72443_a((double)0.2, (double)0.2, (double)0.5);
                    }
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.drawBox(x1, y, width1);
                    maxWidth = Math.max(maxWidth, width1);
                    for (int j = 0; j < amount; ++j) {
                        this.drawBar(x1 - (SHConfig.hudAlignLeft ? -j * 4 - 1 : (j + 1) * 4), y + 1, color, index <= SHData.getInt(player, 1));
                        ++index;
                    }
                    y += SHConfig.hudAlignTop ? 4 : -4;
                    ++rows;
                }
                if (rows == 1) {
                    y += SHConfig.hudAlignTop ? 4 : -4;
                }
                String s = SHData.getInt(player, 1) + 1 + "";
                this.func_73731_b(this.mc.field_71466_p, s, x - (SHConfig.hudAlignLeft ? -maxWidth - 8 : maxWidth + 8 + this.mc.field_71466_p.func_78256_a(s)), !SHConfig.hudAlignTop ? Math.min(y1 + 4 - rows * 2, y1 + 4) - this.mc.field_71466_p.field_78288_b / 2 - 1 : Math.max(y1 - this.mc.field_71466_p.field_78288_b / 2 + rows * 2, y1), -1);
            }
        }
        if (SHHelper.canRunSuperSpeed(player) && SHData.getBoolean(player, 0) && SHData.getInt(player, 1) >= 0 && (!activeAbilities.isEmpty() || SHData.getInt(player, 31) > 0)) {
            int kmph = (int)Math.round(DataManager.getVelocity(player));
            float multiplier = (float)kmph / SpeedsterHelper.getPlayerTopSpeed(player);
            int i = Math.min((int)(100.0f * multiplier), 100);
            String s = SHConfig.useMiles ? Math.round((float)kmph * 0.6213712f) + " mph" : kmph + " km/h";
            this.func_73731_b(this.mc.field_71466_p, s, SHConfig.hudAlignLeft ? 4 : width - 4 - this.mc.field_71466_p.func_78256_a(s), y += SHConfig.hudAlignTop ? 5 : -this.mc.field_71466_p.field_78288_b, 0xFFFFFF);
            GL11.glDisable((int)3553);
            Vec3 color = SpeedsterHelper.getTrailType(player).getTrailColor();
            float shadeFactor = 0.25f;
            SHRenderHelper.setVecColor(Vec3.func_72443_a((double)(color.field_72450_a * (double)shadeFactor), (double)(color.field_72448_b * (double)shadeFactor), (double)(color.field_72449_c * (double)shadeFactor)));
            this.func_73729_b(SHConfig.hudAlignLeft ? 4 : width - 4 - i + 1, (y += SHConfig.hudAlignTop ? this.mc.field_71466_p.field_78288_b + 3 : -3) - (SHConfig.hudAlignTop ? 0 : 2) + 1, 0, 0, i, 2);
            SHRenderHelper.setVecColor(color);
            this.func_73729_b(SHConfig.hudAlignLeft ? 4 : width - 4 - i, y - (SHConfig.hudAlignTop ? 0 : 2), 0, 0, i, 2);
            GL11.glEnable((int)3553);
            if (SHData.getInt(player, 31) > 0) {
                s = StringUtils.func_76337_a((int)SHData.getInt(player, 31));
                this.func_73731_b(this.mc.field_71466_p, s, SHConfig.hudAlignLeft ? 4 : width - 4 - this.mc.field_71466_p.func_78256_a(s), y += SHConfig.hudAlignTop ? 8 : -6 - this.mc.field_71466_p.field_78288_b, 0xFFFFFF);
            }
        }
        int i = UtilityBeltHandler.utilityBeltCooldown;
        int max = 25;
        if (i > 0) {
            this.mc.func_110434_K().func_110577_a(icons);
            x = width / 2 - 18;
            y = height / 2;
            float alpha = (float)(i > max / 2 ? max : i * 2) / (float)max;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            GL11.glTranslatef((float)x, (float)y, (float)0.0f);
            this.func_73729_b(0, 0, 18 + SHData.getInt(player, 37) * 18, 18, 18, 18);
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)3042);
    }

    public void drawBar(int x, int y, Vec3 color, boolean filled) {
        float contrast = filled ? 0.3f : 0.4f;
        float f = filled ? 1.0f : 0.25f;
        GL11.glColor4d((double)((color.field_72450_a + (double)contrast) * (double)f), (double)((color.field_72448_b + (double)contrast) * (double)f), (double)((color.field_72449_c + (double)contrast) * (double)f), (double)1.0);
        this.func_73729_b(x, y, 91, 254, 3, 2);
        GL11.glColor4d((double)(color.field_72450_a * (double)f), (double)(color.field_72448_b * (double)f), (double)(color.field_72449_c * (double)f), (double)1.0);
        this.func_73729_b(x, y, 94, 254, 3, 2);
        GL11.glColor4d((double)((color.field_72450_a - (double)contrast) * (double)f), (double)((color.field_72448_b - (double)contrast) * (double)f), (double)((color.field_72449_c - (double)contrast) * (double)f), (double)1.0);
        this.func_73729_b(x, y, 97, 254, 3, 2);
    }

    public void drawBox(int x, int y, int width) {
        int u = 89;
        int v = 252;
        int height = 4;
        if (!SHConfig.hudAlignLeft) {
            x -= width + 2;
        }
        this.func_73729_b(x, y, 88, 252, 1, 4);
        this.func_73729_b(x + width + 1, y, 90, 252, 1, 4);
        float f = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 1), (double)(y + height), (double)this.field_73735_i, (double)((float)u * f), (double)((float)(v + height) * f));
        tessellator.func_78374_a((double)(x + 1 + width), (double)(y + height), (double)this.field_73735_i, (double)((float)u * f), (double)((float)(v + height) * f));
        tessellator.func_78374_a((double)(x + 1 + width), (double)y, (double)this.field_73735_i, (double)((float)u * f), (double)((float)v * f));
        tessellator.func_78374_a((double)(x + 1), (double)y, (double)this.field_73735_i, (double)((float)u * f), (double)((float)v * f));
        tessellator.func_78381_a();
    }

    public void drawLightning(int x, int y, Vec3 color) {
        float contrast = 0.4f;
        GL11.glColor4d((double)(color.field_72450_a + (double)contrast), (double)(color.field_72448_b + (double)contrast), (double)(color.field_72449_c + (double)contrast), (double)1.0);
        this.func_73729_b(x, y, 0, 223, 11, 11);
        GL11.glColor4d((double)color.field_72450_a, (double)color.field_72448_b, (double)color.field_72449_c, (double)1.0);
        this.func_73729_b(x, y, 11, 223, 11, 11);
        GL11.glColor4d((double)(color.field_72450_a - (double)contrast), (double)(color.field_72448_b - (double)contrast), (double)(color.field_72449_c - (double)contrast), (double)1.0);
        this.func_73729_b(x, y, 22, 223, 11, 11);
    }

    public void renderQuiverHotbar(RenderGameOverlayEvent.Pre event, int width, int height, EntityPlayer player) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (QuiverHelper.getEquippedQuiver(player) != null && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ModItems.compoundBow) {
            int x = SHConfig.quiverHotbarAlignLeft ? 0 : width - 22;
            int y = height / 2 - 51;
            InventoryQuiver quiver = QuiverHelper.getQuiverInventory(player);
            this.mc.func_110434_K().func_110577_a(widgets);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3042);
            this.func_73729_b(x, y, 0, 0, 22, 102);
            this.func_73729_b(x - 1, y - 1 + SHData.getInt(player, 3) * 20, 22, 0, 24, 24);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)32826);
            RenderHelper.func_74520_c();
            for (int i = 0; i < 5; ++i) {
                ItemStack itemstack = quiver.func_70301_a(i);
                if (itemstack == null) continue;
                this.itemRenderer.func_82406_b(this.mc.field_71466_p, this.mc.func_110434_K(), itemstack, x + 3, y + 3 + 20 * i);
                this.itemRenderer.func_77021_b(this.mc.field_71466_p, this.mc.func_110434_K(), itemstack, x + 3, y + 3 + 20 * i);
            }
            RenderHelper.func_74518_a();
            GL11.glDisable((int)32826);
        }
    }

    public void renderQuiverArrowHightlight(RenderGameOverlayEvent.Pre event, int width, int height, EntityPlayer player) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (QuiverHelper.getEquippedQuiver(player) != null && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ModItems.compoundBow && this.mc.field_71474_y.field_92117_D && this.remainingHighlightTicks > 0 && this.highlightingItemStack != null) {
            String name = this.highlightingItemStack.func_82833_r();
            int opacity = (int)((float)this.remainingHighlightTicks * 256.0f / 10.0f);
            if (opacity > 255) {
                opacity = 255;
            }
            if (opacity > 0) {
                int y = height / 2 - 51;
                GL11.glPushMatrix();
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                FontRenderer font = this.highlightingItemStack.func_77973_b().getFontRenderer(this.highlightingItemStack);
                FontRenderer fontRenderer = font = font == null ? this.fontRenderer : font;
                if (font != null) {
                    int x = SHConfig.quiverHotbarAlignLeft ? 27 : width - font.func_78256_a(name) - 27;
                    font.func_78261_a(name, x, y + 6 + SHData.getInt(player, 3) * 20, 0xFFFFFF | opacity << 24);
                }
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
            }
        }
    }

    public void renderTreadmillOverlay(RenderGameOverlayEvent.Pre event, int width, int height, EntityPlayer player) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(icons);
        int x = width / 2;
        int y = 10;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        if (SHHelper.isOnTreadmill(player)) {
            int y1;
            int x1;
            int color;
            int cap = SHPlayerData.getData(player).speedXpBarCap();
            int left = x - 91;
            if (cap > 0) {
                int barWidth = 182;
                int filled = (int)(SHData.getFloat(player, 19) * (float)(barWidth + 1));
                this.func_73729_b(left, y, 0, 50, barWidth, 5);
                if (filled > 0) {
                    this.func_73729_b(left, y, 0, 55, filled, 5);
                }
            }
            if (SHData.getInt(player, 17) > 0) {
                color = 16566021;
                String text = SHData.getInt(player, 17) + "";
                x1 = x - (this.fontRenderer.func_78256_a(text) + 8) / 2;
                y1 = y - 1;
                this.fontRenderer.func_78276_b(text, x1 + 1, y1, 0);
                this.fontRenderer.func_78276_b(text, x1 - 1, y1, 0);
                this.fontRenderer.func_78276_b(text, x1, y1 + 1, 0);
                this.fontRenderer.func_78276_b(text, x1, y1 - 1, 0);
                this.fontRenderer.func_78276_b(text, x1, y1, color);
                this.mc.func_110434_K().func_110577_a(icons);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(x - 5 + (this.fontRenderer.func_78256_a(text) - 8) / 2, y - 6, Ability.superSpeed.getX(), Ability.superSpeed.getY(), 18, 18);
            }
            left = x - 45;
            this.func_73729_b(left, y + 12, 0, 60, 91, 5);
            if (Treadmill.timer > 0.0f) {
                this.func_73729_b(left, y + 12, 0, 65, (int)(SHRenderHelper.median(Treadmill.timer, Treadmill.prevTimer) * 91.0f), 5);
            }
            if (Treadmill.nextKey != null) {
                color = 0xFFFFFF;
                String text = GameSettings.func_74298_c((int)Treadmill.nextKey.func_151463_i());
                x1 = x - 48 - this.fontRenderer.func_78256_a(text);
                y1 = y + 11;
                this.fontRenderer.func_78276_b(text, x1 + 1, y1, 0);
                this.fontRenderer.func_78276_b(text, x1 - 1, y1, 0);
                this.fontRenderer.func_78276_b(text, x1, y1 + 1, 0);
                this.fontRenderer.func_78276_b(text, x1, y1 - 1, 0);
                this.fontRenderer.func_78276_b(text, x1, y1, color);
            }
            color = 0xFFFFFF;
            String text = "Streak: " + Treadmill.successCount + "/" + (2 + SHData.getInt(player, 17));
            x1 = x + 50;
            y1 = y + 11;
            this.fontRenderer.func_78276_b(text, x1 + 1, y1, 0);
            this.fontRenderer.func_78276_b(text, x1 - 1, y1, 0);
            this.fontRenderer.func_78276_b(text, x1, y1 + 1, 0);
            this.fontRenderer.func_78276_b(text, x1, y1 - 1, 0);
            this.fontRenderer.func_78276_b(text, x1, y1, color);
        }
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderArmorProtection(RenderGameOverlayEvent.Pre event, int width, int height, EntityPlayer player) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float amount = SHHelper.getArmorProtection(player);
        if (amount > 0.0f) {
            this.mc.func_110434_K().func_110577_a(icons);
            int left = width / 2 - 91;
            int top = height - GuiIngameForge.left_height;
            if (ForgeHooks.getTotalArmorValue((EntityPlayer)this.mc.field_71439_g) == 0) {
                top += 10;
            }
            this.func_73729_b(left, top, 0, 70, 81, 9);
            this.func_73729_b(left + 1, top + 1, 81, 70, (int)(79.0f * amount), 7);
            GuiIngameForge.left_height += 10;
        }
    }

    public void renderCryokinesis(RenderGameOverlayEvent.Pre event, int width, int height, EntityPlayer player, boolean flag) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Hero hero = SHHelper.getHero(player);
        float amount = SHData.getFloat(player, 35);
        if (hero != null && hero.hasAbility(Ability.cryokinesis)) {
            this.mc.func_110434_K().func_110577_a(icons);
            if (flag) {
                int left = width / 2 - 91;
                int top = height - GuiIngameForge.left_height;
                if (ForgeHooks.getTotalArmorValue((EntityPlayer)this.mc.field_71439_g) == 0) {
                    top += 10;
                }
                this.func_73729_b(left, top, 0, 79, 81, 9);
                this.func_73729_b(left + 1, top + 1, 81, 79, (int)(79.0f * amount), 7);
                GuiIngameForge.left_height += 10;
            } else {
                int left = width / 2 - 41;
                int top = height - GuiIngameForge.left_height + 6;
                this.func_73729_b(left, top, 0, 79, 81, 9);
                this.func_73729_b(left + 1, top + 1, 81, 79, (int)(79.0f * amount), 7);
                GuiIngameForge.left_height += 10;
            }
        }
    }

    public void renderShrinkCooldown(RenderGameOverlayEvent.Pre event, int width, int height, EntityPlayer player, boolean flag) {
        float amount = (float)(1200 - SHData.getInt(player, 22)) / 1200.0f;
        if (amount < 1.0f) {
            float f;
            int top;
            int left;
            this.mc.func_110434_K().func_110577_a(icons);
            if (flag) {
                left = width / 2 - 91;
                top = height - GuiIngameForge.left_height;
                if (ForgeHooks.getTotalArmorValue((EntityPlayer)this.mc.field_71439_g) == 0) {
                    top += 14;
                }
                this.func_73729_b(left, top, 91, 60, 81, 5);
                f = 1.0f - amount;
                GL11.glColor4f((float)(f < 0.5f ? f * 2.0f : 1.0f), (float)(f >= 0.5f ? 1.0f - (f - 0.5f) * 2.0f : 1.0f), (float)0.0f, (float)1.0f);
                this.func_73729_b(left, top, 91, 65, (int)(81.0f * amount), 5);
                GuiIngameForge.left_height += 6;
            } else {
                left = width / 2 - 41;
                top = height - GuiIngameForge.left_height + 10;
                this.func_73729_b(left, top, 91, 60, 81, 5);
                f = 1.0f - amount;
                GL11.glColor4f((float)(f < 0.5f ? f * 2.0f : 1.0f), (float)(f >= 0.5f ? 1.0f - (f - 0.5f) * 2.0f : 1.0f), (float)0.0f, (float)1.0f);
                this.func_73729_b(left, top, 91, 65, (int)(81.0f * amount), 5);
                GuiIngameForge.left_height += 6;
            }
        }
        if (this.massWarningTimer > 0) {
            float f = this.massWarningTimer;
            f = f > (float)(this.maxMassWarningTimer / 2) ? (float)this.maxMassWarningTimer - f : f;
            float opacity = MathHelper.func_76131_a((float)(f / (float)this.maxMassWarningTimer * 1.75f), (float)0.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            Color color = new Color(1.0f, 0.0f, 0.0f, opacity);
            int color1 = color.getRGB();
            float x = width / 2;
            float y = height / 2 - 60;
            float scale = 4.0f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y, (float)0.0f);
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            this.func_73732_a(this.fontRenderer, StatCollector.func_74838_a((String)"shrink.mass.warning.line1"), 0, 0, color1);
            GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
            GL11.glPopMatrix();
            x = width / 2;
            y = height / 2 - 20;
            scale = 2.0f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y, (float)0.0f);
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            this.func_73732_a(this.fontRenderer, StatCollector.func_74838_a((String)"shrink.mass.warning.line2"), 0, 0, color1);
            GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
            GL11.glPopMatrix();
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderTemperature(RenderGameOverlayEvent.Pre event, int width, int height, EntityPlayer player) {
        int amount = TemperatureHelper.getTemperatureForGui();
        boolean cold = false;
        if (amount < 0) {
            amount *= -1;
            cold = true;
        }
        if (amount > 0) {
            this.mc.func_110434_K().func_110577_a(icons);
            int left = width / 2 - 91;
            int top = height - GuiIngameForge.left_height;
            if (ForgeHooks.getTotalArmorValue((EntityPlayer)this.mc.field_71439_g) == 0) {
                top += 10;
            }
            for (int i = 0; i < amount; ++i) {
                this.func_73729_b(left + i * 12, top, cold ? 0 : 9, 88, 9, 9);
            }
            GuiIngameForge.left_height += 10;
        }
    }

    public void updateTick() {
        if (this.mc.field_71439_g != null && !this.mc.func_147113_T()) {
            float shrinkCooldown;
            if (QuiverHelper.getEquippedQuiver((EntityPlayer)this.mc.field_71439_g) != null) {
                InventoryQuiver quiver = QuiverHelper.getQuiverInventory((EntityPlayer)this.mc.field_71439_g);
                ItemStack itemstack = quiver.getCurrentArrow();
                if (itemstack == null) {
                    this.remainingHighlightTicks = 0;
                } else if (this.highlightingItemStack != null && itemstack.func_77973_b() == this.highlightingItemStack.func_77973_b() && ItemStack.func_77970_a((ItemStack)itemstack, (ItemStack)this.highlightingItemStack) && (itemstack.func_77984_f() || itemstack.func_77960_j() == this.highlightingItemStack.func_77960_j())) {
                    if (this.remainingHighlightTicks > 0) {
                        --this.remainingHighlightTicks;
                    }
                } else {
                    this.remainingHighlightTicks = 40;
                }
                this.highlightingItemStack = itemstack;
            }
            if ((shrinkCooldown = (float)(1200 - SHData.getInt((EntityPlayer)this.mc.field_71439_g, 22)) / 1200.0f) < 0.2f && this.massWarningTimer == 0) {
                this.massWarningTimer = this.maxMassWarningTimer;
            }
            if (this.massWarningTimer > 0) {
                --this.massWarningTimer;
            }
        }
    }
}

