/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.client.gui.book;

import com.google.common.collect.Lists;
import fiskfille.heroes.client.gui.book.Books;
import fiskfille.heroes.client.gui.book.Chapter;
import fiskfille.heroes.client.gui.book.Page;
import fiskfille.heroes.client.gui.book.PageSummary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.util.StringUtils;

public class Book {
    public List<Page> pages = Lists.newArrayList();
    public List<Page> chapters = Lists.newArrayList();

    public Book addPage(Page page) {
        if (page instanceof Chapter && this.pages.size() % 2 == 1) {
            this.addPage(new Page(this, ""));
        }
        page.pageNumber = this.getTotalPages();
        this.pages.add(page);
        if (page instanceof Chapter && page.pageNumber % 2 == 1) {
            this.addPage(new Page(this, ""));
        }
        return this;
    }

    public Book addAll(Page[] pages) {
        for (Page page : pages) {
            this.addPage(page);
        }
        return this;
    }

    public Book addAll(List<Page> pages) {
        for (Page page : pages) {
            this.addPage(page);
        }
        return this;
    }

    public Book addPageAfter(Page page, Page page1) {
        if (page instanceof Chapter && this.pages.size() % 2 == 1) {
            this.addPageAfter(new Page(this, ""), page1);
        }
        int i = this.pages.indexOf(page1) + 1;
        this.pages.add(i, page);
        for (int j = 0; j < this.pages.size(); ++j) {
            this.pages.get((int)j).pageNumber = j + 1;
        }
        return this;
    }

    public Book addChapterSummary(Chapter chapter) {
        ArrayList<Page> list = new ArrayList<Page>(Books.getPagesInChapter(chapter));
        Collections.sort(list, new Comparator<Page>(){

            @Override
            public int compare(Page arg0, Page arg1) {
                return arg0.getTranslatedHeader().compareTo(arg1.getTranslatedHeader());
            }
        });
        Page page1 = chapter;
        int cap = 13;
        for (int i = 0; i <= list.size() / cap; ++i) {
            int j;
            List<Page> list1 = list.subList(j, (j = i * cap) + cap > list.size() ? list.size() : j + cap);
            PageSummary page2 = new PageSummary(this, chapter, list1);
            this.addPageAfter(page2, page1);
            page1 = page2;
        }
        if (page1.pageNumber % 2 == 0 && this.pages.size() >= page1.pageNumber && StringUtils.func_151246_b((String)this.pages.get((int)page1.pageNumber).content)) {
            this.pages.remove(page1.pageNumber);
            for (int j = 0; j < this.pages.size(); ++j) {
                this.pages.get((int)j).pageNumber = j + 1;
            }
        }
        return this;
    }

    public int getTotalPages() {
        return this.pages.size() + 1;
    }

    public int getTotalPagePairs() {
        return this.getTotalPages() / 2;
    }
}

