/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.client.gui.book;

import com.google.common.collect.Lists;
import fiskfille.heroes.SuperHeroesAPI;
import fiskfille.heroes.client.gui.book.Book;
import fiskfille.heroes.client.gui.book.Chapter;
import fiskfille.heroes.client.gui.book.Page;
import fiskfille.heroes.client.gui.book.PageCharacter;
import fiskfille.heroes.client.gui.book.PageTOC;
import fiskfille.heroes.common.ability.Ability;
import fiskfille.heroes.common.hero.Hero;
import fiskfille.heroes.common.weakness.Weakness;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.util.StringUtils;

public class Books {
    public static Book metahumanLog;

    public static void register() {
        Books.registerMetahumanLog();
    }

    private static void registerMetahumanLog() {
        metahumanLog = new Book();
        ArrayList metahumanLogPages = Lists.newArrayList();
        Chapter chapterPowersAbilities = new Chapter(metahumanLog, "book.metahumanLog.chapter.powersAbilities");
        Chapter chapterWeaknesses = new Chapter(metahumanLog, "book.metahumanLog.chapter.weaknesses");
        Chapter chapterCharacters = new Chapter(metahumanLog, "book.metahumanLog.chapter.characters");
        metahumanLogPages.add(chapterPowersAbilities);
        ArrayList<Ability> abilities = new ArrayList<Ability>(Ability.abilities);
        Collections.sort(abilities, new Comparator<Ability>(){

            @Override
            public int compare(Ability arg0, Ability arg1) {
                return arg0.getNameTranslated().compareTo(arg1.getNameTranslated());
            }
        });
        for (Ability ability : abilities) {
            Page page = new Page(metahumanLog, "book.metahumanLog.page.ability." + ability.getUnconventionalName(), true);
            page.header = "ability.name." + ability.getName();
            metahumanLogPages.add(page);
        }
        metahumanLogPages.add(chapterWeaknesses);
        ArrayList<Weakness> weaknesses = new ArrayList<Weakness>(Weakness.weaknesses);
        Collections.sort(weaknesses, new Comparator<Weakness>(){

            @Override
            public int compare(Weakness arg0, Weakness arg1) {
                return arg0.getNameTranslated().compareTo(arg1.getNameTranslated());
            }
        });
        for (Weakness weakness : weaknesses) {
            Page page = new Page(metahumanLog, "book.metahumanLog.page.weakness." + weakness.getName(), true);
            page.header = "weakness.name." + weakness.getName();
            metahumanLogPages.add(page);
        }
        metahumanLogPages.add(chapterCharacters);
        ArrayList<Hero> arrayList = new ArrayList<Hero>(SuperHeroesAPI.getHeroes());
        Collections.sort(arrayList, new Comparator<Hero>(){

            @Override
            public int compare(Hero arg0, Hero arg1) {
                int i = Integer.compare(arg0.getTier(), arg1.getTier());
                if (i == 0) {
                    return arg0.getName().compareTo(arg1.getName());
                }
                return i;
            }
        });
        for (Hero hero : arrayList) {
            metahumanLogPages.add(new PageCharacter(metahumanLog, hero));
            PageCharacter page = new PageCharacter(metahumanLog, hero);
            page.header = null;
            metahumanLogPages.add(page);
        }
        metahumanLog.addPage(new PageTOC(metahumanLog, metahumanLogPages));
        metahumanLog.addAll(metahumanLogPages);
        metahumanLog.addChapterSummary(chapterPowersAbilities);
        metahumanLog.addChapterSummary(chapterWeaknesses);
        metahumanLog.addChapterSummary(chapterCharacters);
    }

    public static List<Page> getPagesInChapter(Chapter chapter) {
        ArrayList list = Lists.newArrayList();
        Chapter c = null;
        for (Page page : chapter.parent.pages) {
            if (page instanceof Chapter) {
                c = (Chapter)page;
                continue;
            }
            if (StringUtils.func_151246_b((String)page.getTranslatedHeader()) || c != chapter) continue;
            list.add(page);
        }
        return list;
    }
}

