/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.client.render.item;

import fiskfille.heroes.SuperHeroesAPI;
import fiskfille.heroes.client.SuperHeroesAPIClient;
import fiskfille.heroes.client.model.item.ModelCompoundBow;
import fiskfille.heroes.client.render.arrow.ArrowRenderer;
import fiskfille.heroes.common.arrowtype.ArrowType;
import fiskfille.heroes.common.container.InventoryQuiver;
import fiskfille.heroes.common.entity.arrow.EntityTrickArrow;
import fiskfille.heroes.common.event.ClientEventHandler;
import fiskfille.heroes.common.helper.QuiverHelper;
import fiskfille.heroes.common.helper.SHHelper;
import fiskfille.heroes.common.item.ItemCompoundBow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderItemCompoundBow
implements IItemRenderer {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private Minecraft mc = Minecraft.func_71410_x();
    private ResourceLocation texture = new ResourceLocation("fiskheroes", "textures/models/compound_bow.png");
    private ModelCompoundBow model = new ModelCompoundBow();

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        EntityPlayer player = null;
        float drawback = 0.0f;
        if (data.length > 1 && data[1] instanceof EntityPlayer && (player = (EntityPlayer)data[1]).func_71039_bw()) {
            drawback = Math.min(((float)player.func_71057_bx() + ClientEventHandler.renderTick) / ItemCompoundBow.getDrawbackTime(player), 1.0f) / 2.5f;
        }
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.8f, (float)0.7f, (float)0.1f);
            GL11.glRotatef((float)-5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)230.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderBow(player, item);
            this.renderArrow(player, drawback);
            GL11.glPopMatrix();
            GL11.glLineWidth((float)3.0f);
            this.drawCables(drawback, 0.0f, type, 0.0f, 0.0f, 0.0f);
            GL11.glLineWidth((float)2.0f);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            if (player != null && player.func_71039_bw()) {
                drawback = Math.min(((float)player.func_71057_bx() + ClientEventHandler.renderTick) / 10.0f, 1.0f) / 3.5f;
            }
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y, (float)z);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)140.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.035f, (float)0.1735f, (float)-0.725f);
            this.renderBow(player, item);
            this.renderArrow(player, drawback);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glLineWidth((float)2.0f);
            this.drawCables(drawback, 0.0f, type, x, y, z);
            GL11.glLineWidth((float)2.0f);
            GL11.glPopMatrix();
        }
    }

    private void renderBow(EntityPlayer player, ItemStack itemstack) {
        this.mc.func_110434_K().func_110577_a(this.texture);
        this.model.render();
    }

    private void renderArrow(EntityPlayer player, float drawback) {
        if (player != null && player.func_71039_bw()) {
            ArrowType arrowType;
            ArrowRenderer arrowRenderer;
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.075f, (float)(-0.225f + drawback * 1.3f), (float)0.0f);
            float scale = 0.9f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            InventoryQuiver quiver = QuiverHelper.getQuiverInventory(player);
            ItemStack itemstack = QuiverHelper.getArrowToFire(player);
            if (itemstack != null && (arrowRenderer = SuperHeroesAPIClient.getRendererForArrow(arrowType = SuperHeroesAPI.getArrowTypeForItem(itemstack.func_77973_b(), itemstack.func_77960_j()))) != null) {
                String texture = SHHelper.getHero(player) != null ? SHHelper.getHero(player).getCustomArrowTexture() : "arrow";
                arrowRenderer.render(new EntityTrickArrow(player.field_70170_p, (EntityLivingBase)player, 0.0f).setArrowTexture(texture), 0.0, 0.0, 0.0, 0.0625f, false);
            }
        }
    }

    private void drawCables(float drawback, float shade, IItemRenderer.ItemRenderType type, float offsetX, float offsetY, float offsetZ) {
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glPushMatrix();
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glColor4f((float)shade, (float)shade, (float)shade, (float)1.0f);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78371_b(3);
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            float cableLength = 0.425f;
            tessellator.func_78377_a((double)(offsetX + 0.075f), (double)(offsetY + 0.975f), (double)(offsetZ + 0.0775f));
            tessellator.func_78377_a((double)(offsetX + 0.075f + cableLength * 1.15f - drawback * 0.9f), (double)(offsetY + 0.975f - cableLength - drawback), (double)(offsetZ + 0.0775f + cableLength * 0.085f));
            tessellator.func_78377_a((double)(offsetX + 1.2f), (double)offsetY, (double)(offsetZ + 0.1625f));
            tessellator.func_78381_a();
            tessellator.func_78371_b(3);
            tessellator.func_78377_a((double)(offsetX + 0.075f), (double)(offsetY + 0.975f), (double)(offsetZ + 0.0775f));
            tessellator.func_78377_a((double)(offsetX + 0.46875f), (double)(offsetY + 0.9f), (double)(offsetZ + 0.08425f));
            tessellator.func_78381_a();
            tessellator.func_78371_b(3);
            tessellator.func_78377_a((double)(offsetX + 1.2f), (double)offsetY, (double)(offsetZ + 0.1625f));
            tessellator.func_78377_a((double)(offsetX + 1.04375f), (double)(offsetY + 0.4f), (double)(offsetZ + 0.12825f));
            tessellator.func_78381_a();
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3553);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            GL11.glPushMatrix();
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glColor4f((float)shade, (float)shade, (float)shade, (float)1.0f);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78371_b(3);
            float cableLength = 0.525f;
            tessellator.func_78377_a((double)offsetX, (double)(offsetY + 0.75f), (double)(offsetZ + 0.035f));
            tessellator.func_78377_a((double)(offsetX + cableLength * 0.8f - drawback * 1.2f), (double)(offsetY + 0.75f - cableLength - drawback), (double)(offsetZ + 0.035f));
            tessellator.func_78377_a((double)(offsetX + 0.94f), (double)(offsetY + 0.75f - 1.175f), (double)(offsetZ + 0.035f));
            tessellator.func_78381_a();
            tessellator.func_78371_b(3);
            tessellator.func_78377_a((double)offsetX, (double)(offsetY + 0.75f), (double)(offsetZ + 0.035f));
            tessellator.func_78377_a((double)(offsetX + 0.35f), (double)(offsetY + 0.6f), (double)(offsetZ + 0.035f));
            tessellator.func_78381_a();
            tessellator.func_78371_b(3);
            tessellator.func_78377_a((double)(offsetX + 0.94f), (double)(offsetY + 0.75f - 1.175f), (double)(offsetZ + 0.035f));
            tessellator.func_78377_a((double)(offsetX + 0.85f), (double)offsetY, (double)(offsetZ + 0.035f));
            tessellator.func_78381_a();
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3553);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }
}

