/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.client.trail;

import fiskfille.heroes.client.render.LightningData;
import fiskfille.heroes.client.trail.SpeedTrailRenderer;
import fiskfille.heroes.client.trail.TrailRenderHandler;
import fiskfille.heroes.client.trail.TrailType;
import fiskfille.heroes.common.data.SHData;
import fiskfille.heroes.common.entity.EntitySpeedMirage;
import fiskfille.heroes.common.event.ClientEventHandler;
import fiskfille.heroes.common.helper.SHRenderHelper;
import fiskfille.heroes.common.helper.VectorHelper;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class SpeedTrailRendererLightnings
extends SpeedTrailRenderer {
    @Override
    public void renderTrail(EntityLivingBase entity, TrailType type) {
        EntityClientPlayerMP clientPlayer = Minecraft.func_71410_x().field_71439_g;
        float partialTicks = ClientEventHandler.renderTick;
        GL11.glPushMatrix();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            double x = -SHRenderHelper.median(player.field_70165_t, player.field_70169_q) - (SHRenderHelper.median(clientPlayer.field_70165_t, clientPlayer.field_70169_q) - SHRenderHelper.median(player.field_70165_t, player.field_70169_q));
            double y = -SHRenderHelper.median(player.field_70163_u, player.field_70167_r) - (SHRenderHelper.median(clientPlayer.field_70163_u, clientPlayer.field_70167_r) - SHRenderHelper.median(player.field_70163_u, player.field_70167_r));
            double z = -SHRenderHelper.median(player.field_70161_v, player.field_70166_s) - (SHRenderHelper.median(clientPlayer.field_70161_v, clientPlayer.field_70166_s) - SHRenderHelper.median(player.field_70161_v, player.field_70166_s));
            GL11.glTranslatef((float)((float)x), (float)((float)y + (player != clientPlayer ? 1.62f : 0.0f)), (float)((float)z));
            int amountOfLightnings = 6;
            float lightningSpace = player.field_70131_O / (float)amountOfLightnings;
            LinkedList<EntitySpeedMirage> list = TrailRenderHandler.getSpeedMiragesFromPlayer(player);
            SHRenderHelper.setupRenderLightning();
            for (int i = 0; i < amountOfLightnings; ++i) {
                Vec3 add = Vec3.func_72443_a((double)0.0, (double)((float)i * lightningSpace), (double)0.0);
                float differ = 0.435f * (player.field_70131_O / 1.8f);
                if (list.size() <= 0) continue;
                Vec3 firstStart = VectorHelper.add(list.getLast().getLightningPosVector(i).func_72444_a(list.getLast().func_70666_h(partialTicks)), player.func_70666_h(partialTicks).func_72441_c(0.0, (double)(-1.62f * (clientPlayer.field_70131_O / 1.8f)), 0.0));
                Vec3 firstEnd = list.getLast().getLightningPosVector(i);
                float alpha = 1.0f - ((float)list.getLast().progress + ClientEventHandler.renderTick) / 10.0f;
                SHRenderHelper.drawLightningLine(VectorHelper.add(firstStart, add.func_72441_c(0.0, (double)(list.getFirst().lightningFactor[i] * differ), 0.0)), VectorHelper.add(firstEnd, add.func_72441_c(0.0, (double)(list.getLast().lightningFactor[i] * differ), 0.0)), 5.0f, 1.0f, type, alpha);
                for (int j = 0; j < list.size(); ++j) {
                    if (j >= list.size() - 1) continue;
                    EntitySpeedMirage speedMirage = list.get(j);
                    EntitySpeedMirage speedMirage2 = list.get(j + 1);
                    Vec3 start = speedMirage.getLightningPosVector(i);
                    Vec3 end = speedMirage2.getLightningPosVector(i);
                    float progress = 1.0f - ((float)speedMirage.progress + ClientEventHandler.renderTick) / 10.0f;
                    SHRenderHelper.drawLightningLine(VectorHelper.add(start, add.func_72441_c(0.0, (double)(speedMirage.lightningFactor[i] * differ), 0.0)), VectorHelper.add(end, add.func_72441_c(0.0, (double)(speedMirage2.lightningFactor[i] * differ), 0.0)), 5.0f, 1.0f, type, progress);
                }
            }
            SHRenderHelper.finishRenderLightning();
        }
        GL11.glPopMatrix();
    }

    @Override
    public void renderFlickering(EntityLivingBase entity, TrailType type) {
        EntityClientPlayerMP clientPlayer = Minecraft.func_71410_x().field_71439_g;
        float partialTicks = ClientEventHandler.renderTick;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && player == clientPlayer) {
                return;
            }
            SHRenderHelper.setupRenderLightning();
            LinkedList<LightningData> list = TrailRenderHandler.getLightningDataFromPlayer(player);
            for (int i = 0; i < list.size(); ++i) {
                LightningData data = list.get(i);
                float progress = 1.0f - ((float)data.progress + ClientEventHandler.renderTick) / 4.0f;
                GL11.glPushMatrix();
                GL11.glTranslated((double)data.pos.field_72450_a, (double)(data.pos.field_72448_b - (double)(player == clientPlayer ? 1.62f : 0.0f)), (double)data.pos.field_72449_c);
                SHRenderHelper.renderLightning(data.lightning, progress);
                GL11.glPopMatrix();
            }
            SHRenderHelper.finishRenderLightning();
        }
    }

    @Override
    public void preRenderSpeedMirage(EntitySpeedMirage entity, TrailType type) {
    }

    @Override
    public boolean shouldRenderSpeedMirage(EntitySpeedMirage entity, TrailType type) {
        return false;
    }

    public TrailType getTrailType(EntityPlayer player, EntitySpeedMirage entity, TrailType origType, int index) {
        if (SHData.getInt(player, 31) > 0) {
            return TrailType.lightnings_blue;
        }
        return origType;
    }
}

