/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.container;

import fiskfille.heroes.SuperHeroesAPI;
import fiskfille.heroes.common.data.SHData;
import fiskfille.heroes.common.item.ModItems;
import java.util.concurrent.Callable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ReportedException;

public class InventoryQuiver
implements IInventory {
    private static final int INVENTORY_SIZE = 5;
    public EntityPlayer player;
    public ItemStack quiverItem;
    public ItemStack[] inventory = new ItemStack[5];

    public InventoryQuiver(EntityPlayer player, ItemStack itemstack) {
        this.player = player;
        this.quiverItem = itemstack;
        if (itemstack != null) {
            if (!itemstack.func_77942_o()) {
                itemstack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound nbt = itemstack.func_77978_p();
            for (int i = 0; i < 5; ++i) {
                if (!nbt.func_74764_b("ext" + i)) continue;
                this.inventory[i] = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("ext" + i));
            }
        }
    }

    public ItemStack getCurrentArrow() {
        int i = this.getFirstSlotID();
        int k = SHData.getInt(this.player, 3);
        if (this.inventory[k] != null) {
            i = k;
        }
        if (i < 0) {
            i = 0;
        }
        return this.func_70301_a(i);
    }

    public ItemStack getFirstItemStack() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack == null) continue;
            return itemstack;
        }
        return null;
    }

    public int getFirstSlotID() {
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack itemstack = this.inventory[i];
            if (itemstack == null) continue;
            return i;
        }
        return -1;
    }

    public void consumeArrowItemStack() {
        int i = this.getFirstSlotID();
        int k = SHData.getInt(this.player, 3);
        if (this.inventory[k] != null) {
            i = k;
        }
        if (i >= 0 && --this.inventory[i].field_77994_a <= 0) {
            this.inventory[i] = null;
        }
        if (this.quiverItem != null) {
            NBTTagCompound nbt = this.quiverItem.func_77978_p();
            for (int j = 0; j < 5; ++j) {
                if (this.inventory[j] != null) {
                    nbt.func_74782_a("ext" + j, (NBTBase)this.inventory[j].func_77955_b(nbt.func_74775_l("ext" + j)));
                    continue;
                }
                if (!nbt.func_74764_b("ext" + j)) continue;
                nbt.func_82580_o("ext" + j);
            }
        }
    }

    public boolean addItemStackToInventory(ItemStack itemstack) {
        boolean flag = this.addItemStackToInventoryTemp(itemstack);
        if (flag && this.quiverItem != null) {
            NBTTagCompound nbt = this.quiverItem.func_77978_p();
            for (int j = 0; j < 5; ++j) {
                if (this.inventory[j] != null) {
                    nbt.func_74782_a("ext" + j, (NBTBase)this.inventory[j].func_77955_b(nbt.func_74775_l("ext" + j)));
                    continue;
                }
                if (!nbt.func_74764_b("ext" + j)) continue;
                nbt.func_82580_o("ext" + j);
            }
        }
        return flag;
    }

    private boolean addItemStackToInventoryTemp(final ItemStack itemstack) {
        if (itemstack != null && itemstack.field_77994_a != 0 && itemstack.func_77973_b() != null) {
            try {
                int i;
                if (itemstack.func_77951_h()) {
                    int i2 = this.getFirstEmptyStack();
                    if (i2 >= 0) {
                        this.inventory[i2] = ItemStack.func_77944_b((ItemStack)itemstack);
                        this.inventory[i2].field_77992_b = 5;
                        itemstack.field_77994_a = 0;
                        return true;
                    }
                    if (this.player.field_71075_bZ.field_75098_d) {
                        itemstack.field_77994_a = 0;
                        return true;
                    }
                    return false;
                }
                do {
                    i = itemstack.field_77994_a;
                    itemstack.field_77994_a = this.storePartialItemStack(itemstack);
                } while (itemstack.field_77994_a > 0 && itemstack.field_77994_a < i);
                if (itemstack.field_77994_a == i && this.player.field_71075_bZ.field_75098_d) {
                    itemstack.field_77994_a = 0;
                    return true;
                }
                return itemstack.field_77994_a < i;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Adding item to inventory");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being added");
                crashreportcategory.func_71507_a("Item ID", (Object)Item.func_150891_b((Item)itemstack.func_77973_b()));
                crashreportcategory.func_71507_a("Item data", (Object)itemstack.func_77960_j());
                crashreportcategory.func_71500_a("Item name", new Callable(){

                    public String call() {
                        return itemstack.func_82833_r();
                    }
                });
                throw new ReportedException(crashreport);
            }
        }
        return false;
    }

    public int getFirstEmptyStack() {
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] != null) continue;
            return i;
        }
        return -1;
    }

    private int storePartialItemStack(ItemStack itemstack) {
        Item item = itemstack.func_77973_b();
        int i = itemstack.field_77994_a;
        if (itemstack.func_77976_d() == 1) {
            int j = this.getFirstEmptyStack();
            if (j < 0) {
                return i;
            }
            if (this.inventory[j] == null) {
                this.inventory[j] = ItemStack.func_77944_b((ItemStack)itemstack);
            }
            return 0;
        }
        int j = this.storeItemStack(itemstack);
        if (j < 0) {
            j = this.getFirstEmptyStack();
        }
        if (j < 0) {
            return i;
        }
        if (this.inventory[j] == null) {
            this.inventory[j] = new ItemStack(item, 0, itemstack.func_77960_j());
            if (itemstack.func_77942_o()) {
                this.inventory[j].func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
            }
        }
        int k = i;
        if (i > this.inventory[j].func_77976_d() - this.inventory[j].field_77994_a) {
            k = this.inventory[j].func_77976_d() - this.inventory[j].field_77994_a;
        }
        if (k > this.func_70297_j_() - this.inventory[j].field_77994_a) {
            k = this.func_70297_j_() - this.inventory[j].field_77994_a;
        }
        if (k == 0) {
            return i;
        }
        this.inventory[j].field_77994_a += k;
        this.inventory[j].field_77992_b = 5;
        return i -= k;
    }

    private int storeItemStack(ItemStack itemstack) {
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null || this.inventory[i].func_77973_b() != itemstack.func_77973_b() || !this.inventory[i].func_77985_e() || this.inventory[i].field_77994_a >= this.inventory[i].func_77976_d() || this.inventory[i].field_77994_a >= this.func_70297_j_() || this.inventory[i].func_77981_g() && this.inventory[i].func_77960_j() != itemstack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)this.inventory[i], (ItemStack)itemstack)) continue;
            return i;
        }
        return -1;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a > amount) {
                stack = stack.func_77979_a(amount);
                this.func_70296_d();
            } else {
                this.func_70299_a(slot, null);
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        this.func_70299_a(slot, null);
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "Quiver";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        ItemStack itemstack;
        ItemStack itemStack = itemstack = this.player.func_70694_bm() != null && this.player.func_70694_bm().func_77973_b() == ModItems.quiver ? this.player.func_70694_bm() : this.quiverItem;
        if (itemstack != null) {
            NBTTagCompound nbt = itemstack.func_77978_p();
            for (int i = 0; i < 5; ++i) {
                if (this.inventory[i] != null) {
                    nbt.func_74782_a("ext" + i, (NBTBase)this.inventory[i].func_77955_b(nbt.func_74775_l("ext" + i)));
                    continue;
                }
                if (!nbt.func_74764_b("ext" + i)) continue;
                nbt.func_82580_o("ext" + i);
            }
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return SuperHeroesAPI.getArrowTypeForItem(stack.func_77973_b(), stack.func_77960_j()) != null;
    }
}

