/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.data;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import fiskfille.heroes.SuperHeroesAPI;
import fiskfille.heroes.common.arrowtype.ArrowType;
import fiskfille.heroes.common.data.ArrowInEntityData;
import fiskfille.heroes.common.data.SHData;
import fiskfille.heroes.common.data.SHEntityData;
import fiskfille.heroes.common.data.SHPlayerData;
import fiskfille.heroes.common.entity.arrow.EntityTrickArrow;
import fiskfille.heroes.common.network.PacketAddArrowToEntity;
import fiskfille.heroes.common.network.PacketPlayerJoin;
import fiskfille.heroes.common.network.PacketSetCollectedSuits;
import fiskfille.heroes.common.network.PacketSyncMovements;
import fiskfille.heroes.common.network.SHNetworkManager;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class DataManager {
    public static double getVelocity(EntityPlayer player) {
        if (player.field_70173_aa == 0) {
            player.field_70142_S = player.field_70165_t;
            player.field_70137_T = player.field_70163_u;
            player.field_70136_U = player.field_70161_v;
        }
        double diffX = player.field_70165_t - player.field_70142_S;
        double diffY = player.field_70163_u - player.field_70137_T;
        double diffZ = player.field_70161_v - player.field_70136_U;
        double blocksMoved = Math.sqrt(diffX * diffX + diffY * diffY + diffZ * diffZ);
        return blocksMoved / 50.0 * 60.0 * 60.0;
    }

    public static float getSwingProgress(EntityPlayer player, float partialTicks) {
        float f1 = SHData.getFloat(player, 28) - SHData.getFloat(player, 27);
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return SHData.getFloat(player, 27) + f1 * partialTicks;
    }

    public static void addArrowToEntityWithoutNotify(EntityLivingBase entity, EntityTrickArrow arrow) {
        EntityTrickArrow arrow1 = null;
        try {
            ArrowType type = SuperHeroesAPI.getArrowTypeFromId(arrow.getArrowId());
            if (type == null) {
                return;
            }
            arrow1 = (EntityTrickArrow)type.entity.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE).newInstance(arrow.field_70170_p, arrow.field_70165_t, arrow.field_70163_u, arrow.field_70161_v);
            arrow1.setArrowItem(arrow.getArrowItem());
            arrow1.setArrowId(arrow.getArrowId());
            arrow1.setArrowTexture(arrow.getArrowTexture());
            arrow1.field_70250_c = arrow.field_70250_c;
            arrow1.field_70251_a = arrow.field_70251_a;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        SHEntityData.getData((EntityLivingBase)entity).arrowsInEntity.add(new ArrowInEntityData(arrow1));
    }

    public static void addArrowToEntity(EntityLivingBase entity, EntityTrickArrow arrow) {
        if (entity.field_70170_p.field_72995_K) {
            SHNetworkManager.networkWrapper.sendToServer((IMessage)new PacketAddArrowToEntity(entity, arrow));
        } else {
            SHNetworkManager.networkWrapper.sendToDimension((IMessage)new PacketAddArrowToEntity(entity, arrow), entity.field_71093_bK);
        }
        DataManager.addArrowToEntityWithoutNotify(entity, arrow);
    }

    public static List<ArrowInEntityData> getArrowsInEntity(EntityLivingBase entity) {
        return SHEntityData.getData((EntityLivingBase)entity).arrowsInEntity;
    }

    public static void addSpeedExperience(EntityPlayer player, int amount) {
        int speedExperienceLevel = SHData.getInt(player, 17);
        int speedExperienceTotal = SHData.getInt(player, 18);
        float speedExperience = SHData.getFloat(player, 19);
        int j = Integer.MAX_VALUE - speedExperienceTotal;
        if (amount > j) {
            amount = j;
        }
        if (speedExperienceLevel < 30) {
            speedExperience += (float)amount / (float)SHPlayerData.getData(player).speedXpBarCap();
            speedExperienceTotal += amount;
            while (speedExperience >= 1.0f) {
                speedExperience = (speedExperience - 1.0f) * (float)SHPlayerData.getData(player).speedXpBarCap();
                DataManager.addSpeedExperienceLevel(player, 1);
                speedExperience /= (float)SHPlayerData.getData(player).speedXpBarCap();
            }
        }
        speedExperienceTotal = Math.max(speedExperienceTotal, 0);
        SHData.cap(player, 17, 0, 30);
        SHData.set(player, 18, speedExperienceTotal);
        SHData.set(player, 19, Float.valueOf(speedExperience));
    }

    public static void addSpeedExperienceLevel(EntityPlayer player, int amount) {
        int speedExperienceLevel = SHData.getInt(player, 17);
        int speedExperienceTotal = SHData.getInt(player, 18);
        float speedExperience = SHData.getFloat(player, 19);
        if (speedExperienceLevel < 30 || amount < 0) {
            if ((speedExperienceLevel += amount) < 0) {
                speedExperienceLevel = 0;
                speedExperience = 0.0f;
                speedExperienceTotal = 0;
            }
            if (amount > 0 && (float)SHData.getInt(player, 20) < (float)player.field_70173_aa - 20.0f) {
                float f = speedExperienceLevel > 30 ? 1.0f : (float)speedExperienceLevel / 30.0f;
                player.field_70170_p.func_72956_a((Entity)player, "random.levelup", f * 0.75f, 1.0f);
                SHData.setWithoutNotify(player, 20, player.field_70173_aa);
            }
        }
        speedExperienceLevel = MathHelper.func_76125_a((int)speedExperienceLevel, (int)0, (int)30);
        speedExperienceTotal = Math.max(speedExperienceTotal, 0);
        SHData.set(player, 17, speedExperienceLevel);
        SHData.set(player, 18, speedExperienceTotal);
        SHData.set(player, 19, Float.valueOf(speedExperience));
    }

    public static void setCollectedSuitsWithoutNotify(EntityPlayer player, List<Item> list) {
        SHPlayerData.getData((EntityPlayer)player).suitsCollected = list;
    }

    public static void setCollectedSuits(EntityPlayer player, List<Item> list) {
        if (player.field_70170_p.field_72995_K) {
            SHNetworkManager.networkWrapper.sendToServer((IMessage)new PacketSetCollectedSuits(player, list));
        } else {
            SHNetworkManager.networkWrapper.sendToDimension((IMessage)new PacketSetCollectedSuits(player, list), player.field_71093_bK);
        }
        DataManager.setCollectedSuitsWithoutNotify(player, list);
    }

    public static void updatePlayerWithServerInfo(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            SHNetworkManager.networkWrapper.sendTo((IMessage)new PacketPlayerJoin(player), (EntityPlayerMP)player);
        }
    }

    public static void syncMovements(EntityPlayer player) {
        SHNetworkManager.networkWrapper.sendToServer((IMessage)new PacketSyncMovements(player, player.field_71075_bZ.field_75100_b, player.field_70122_E, player.field_70701_bs));
    }
}

