/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.data;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import fiskfille.heroes.common.data.SHPlayerData;
import fiskfille.heroes.common.data.type.DataType;
import fiskfille.heroes.common.helper.SHHelper;
import fiskfille.heroes.common.hero.Hero;
import fiskfille.heroes.common.network.PacketPlayerData;
import fiskfille.heroes.common.network.SHNetworkManager;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;

public class SHData {
    public static final int SPEEDING = 0;
    public static final int SPEED = 1;
    public static final int SLOW_MOTION = 2;
    public static final int SELECTED_ARROW = 3;
    public static final int TIME_SINCE_DAMAGED = 4;
    public static final int AIMING = 5;
    public static final int SCALE = 6;
    public static final int MASK_OPEN = 7;
    public static final int MASK_OPEN_TIMER = 8;
    public static final int DISGUISE = 9;
    public static final int SHAPE_SHIFT_TIMER = 10;
    public static final int SHAPE_SHIFTING = 11;
    public static final int INTANGIBLE = 12;
    public static final int INVISIBLE = 13;
    public static final int SHRINKING = 14;
    public static final int GROWING = 15;
    public static final int SHOOTING = 16;
    public static final int SPEED_EXPERIENCE_LEVEL = 17;
    public static final int SPEED_EXPERIENCE_TOTAL = 18;
    public static final int SPEED_EXPERIENCE_BAR = 19;
    public static final int SPEED_LEVEL_UP_COOLDOWN = 20;
    public static final int PREV_ON_GROUND = 21;
    public static final int SHRINK_COOLDOWN = 22;
    public static final int SHAPE_SHIFTING_FROM = 23;
    public static final int SHAPE_SHIFTING_TO = 24;
    public static final int IS_SWING_IN_PROGRESS = 25;
    public static final int SWING_PROGRESS_INT = 26;
    public static final int PREV_SWING_PROGRESS = 27;
    public static final int SWING_PROGRESS = 28;
    public static final int RIGHT_TONFA_STATE = 29;
    public static final int LEFT_TONFA_STATE = 30;
    public static final int VEL_9_DURATION = 31;
    public static final int VEL_9_AMPLIFIER = 32;
    public static final int PREV_HERO = 33;
    public static final int PREV_SCALE = 34;
    public static final int CRYO_CHARGE = 35;
    public static final int CRYO_CHARGING = 36;
    public static final int UTILITY_BELT_TYPE = 37;
    public static final int TACHYON_CHARGE = 38;
    public static final int PREV_TACHYON_CHARGE = 39;
    public static final int SUIT_OPEN = 40;
    public static final int SUIT_OPEN_TIMER = 41;
    public static final int GLIDING = 42;
    public static final int PREV_GLIDING = 43;
    public static final int TICKS_GLIDING = 44;
    public static final int PREV_JUMPING = 45;
    public static final int WING_ANIMATION_TIMER = 46;
    public static final int PREV_WING_ANIMATION_TIMER = 47;
    public static final int QR_ORIGIN_DIMENSION = 48;
    public static final int QR_ORIGIN_X = 49;
    public static final int QR_ORIGIN_Y = 50;
    public static final int QR_ORIGIN_Z = 51;
    public static final int PREV_AIMING = 52;
    public static final int HOVERING = 53;
    public static final int TICKS_SINCE_GLIDING = 54;
    public static final int PREV_UTILITY_BELT_TYPE = 55;
    public static final int PENETRATE_MARTIAN_INVIS = 56;
    public static final int TREADMILL_DECREASING = 57;
    public static final int TREADMILL_LIMB_FACTOR = 58;
    public static final int PREV_TREADMILL_LIMB_FACTOR = 59;
    public static final int TREADMILL_LIMB_PROGRESS = 60;
    public static final int PREV_TREADMILL_LIMB_PROGRESS = 61;
    public static final int MAX_VALUE = 62;
    public static final boolean[] shouldSave = new boolean[62];
    public static final Class[] dataTypes = new Class[62];
    public static final String[] keys = new String[62];

    public static void setWithoutNotify(EntityPlayer player, int i, Object object) {
        if (!(SHData.get(player, i) != null && SHData.get(player, i).equals(object) || object != null && object.equals(SHData.get(player, i)) || object == SHData.get(player, i))) {
            Class dataType = dataTypes[i];
            SHPlayerData.getData((EntityPlayer)player).data[i] = dataType.cast(object);
            switch (i) {
                case 12: {
                    if (!((Boolean)object).booleanValue()) {
                        player.field_70145_X = false;
                    }
                }
                case 13: {
                    if (((Boolean)object).booleanValue() || player.func_70644_a(Potion.field_76441_p)) break;
                    player.func_82142_c(false);
                }
            }
        }
    }

    public static void set(EntityPlayer player, int i, Object object) {
        if (!(SHData.get(player, i) != null && SHData.get(player, i).equals(object) || object != null && object.equals(SHData.get(player, i)) || object == SHData.get(player, i))) {
            if (player.field_70170_p.field_72995_K) {
                SHNetworkManager.networkWrapper.sendToServer((IMessage)new PacketPlayerData(player, i, object));
            } else {
                SHNetworkManager.networkWrapper.sendToDimension((IMessage)new PacketPlayerData(player, i, object), player.field_71093_bK);
            }
        }
        SHData.setWithoutNotify(player, i, object);
    }

    public static void incr(EntityPlayer player, int i, Object amount) {
        if (amount instanceof Integer) {
            SHData.set(player, i, (Integer)SHData.get(player, i) + (Integer)amount);
        } else if (amount instanceof Float) {
            SHData.set(player, i, Float.valueOf(((Float)SHData.get(player, i)).floatValue() + ((Float)amount).floatValue()));
        } else if (amount instanceof Double) {
            SHData.set(player, i, (Double)SHData.get(player, i) + (Double)amount);
        } else if (amount instanceof String) {
            SHData.set(player, i, (String)SHData.get(player, i) + amount);
        } else {
            throw new RuntimeException("Cannot increment a non-numerical data type unless a String!");
        }
    }

    public static void incrWithoutNotify(EntityPlayer player, int i, Object amount) {
        if (amount instanceof Integer) {
            SHData.setWithoutNotify(player, i, SHData.getInt(player, i) + (Integer)amount);
        } else if (amount instanceof Float) {
            SHData.setWithoutNotify(player, i, Float.valueOf(SHData.getFloat(player, i) + ((Float)amount).floatValue()));
        } else if (amount instanceof Double) {
            SHData.setWithoutNotify(player, i, SHData.getDouble(player, i) + (Double)amount);
        } else if (amount instanceof String) {
            SHData.setWithoutNotify(player, i, SHData.getString(player, i) + amount);
        } else {
            throw new RuntimeException("Cannot increment a non-numerical data type unless a String!");
        }
    }

    public static void cap(EntityPlayer player, int i, Object min, Object max) {
        if (min instanceof Integer) {
            if (SHData.getInt(player, i) < (Integer)min) {
                SHData.set(player, i, min);
            }
            if (SHData.getInt(player, i) > (Integer)max) {
                SHData.set(player, i, max);
            }
        } else if (min instanceof Float) {
            if (SHData.getFloat(player, i) < ((Float)min).floatValue()) {
                SHData.set(player, i, min);
            }
            if (SHData.getFloat(player, i) > ((Float)max).floatValue()) {
                SHData.set(player, i, max);
            }
        } else if (min instanceof Double) {
            if (SHData.getDouble(player, i) < (Double)min) {
                SHData.set(player, i, min);
            }
            if (SHData.getDouble(player, i) > (Double)max) {
                SHData.set(player, i, max);
            }
        } else {
            throw new RuntimeException("Cannot cap a non-numerical data type!");
        }
    }

    public static void capWithoutNotify(EntityPlayer player, int i, Object min, Object max) {
        if (min instanceof Integer && max instanceof Integer) {
            if (SHData.getInt(player, i) < (Integer)min) {
                SHData.setWithoutNotify(player, i, min);
            }
            if (SHData.getInt(player, i) > (Integer)max) {
                SHData.setWithoutNotify(player, i, max);
            }
        } else if (min instanceof Float && max instanceof Float) {
            if (SHData.getFloat(player, i) < ((Float)min).floatValue()) {
                SHData.setWithoutNotify(player, i, min);
            }
            if (SHData.getFloat(player, i) > ((Float)max).floatValue()) {
                SHData.setWithoutNotify(player, i, max);
            }
        } else if (min instanceof Double && max instanceof Double) {
            if (SHData.getDouble(player, i) < (Double)min) {
                SHData.setWithoutNotify(player, i, min);
            }
            if (SHData.getDouble(player, i) > (Double)max) {
                SHData.setWithoutNotify(player, i, max);
            }
        } else {
            throw new RuntimeException("Cannot cap a non-numerical data type!");
        }
    }

    public static Object get(EntityPlayer player, int i) {
        return SHPlayerData.getData((EntityPlayer)player).data[i];
    }

    public static int getInt(EntityPlayer player, int i) {
        if (SHData.get(player, i) == null) {
            return 0;
        }
        return (Integer)SHData.get(player, i);
    }

    public static float getFloat(EntityPlayer player, int i) {
        if (SHData.get(player, i) == null) {
            return 0.0f;
        }
        return ((Float)SHData.get(player, i)).floatValue();
    }

    public static double getDouble(EntityPlayer player, int i) {
        if (SHData.get(player, i) == null) {
            return 0.0;
        }
        return (Double)SHData.get(player, i);
    }

    public static boolean getBoolean(EntityPlayer player, int i) {
        if (SHData.get(player, i) == null) {
            return false;
        }
        return (Boolean)SHData.get(player, i);
    }

    public static String getString(EntityPlayer player, int i) {
        return (String)SHData.get(player, i);
    }

    public static void toBytes(ByteBuf buf, int i, Object object) {
        Class dataType = dataTypes[i];
        if (dataType == Integer.class) {
            buf.writeInt(((Integer)object).intValue());
        } else if (dataType == Float.class) {
            buf.writeFloat(((Float)object).floatValue());
        } else if (dataType == Double.class) {
            buf.writeDouble(((Double)object).doubleValue());
        } else if (dataType == Boolean.class) {
            buf.writeBoolean(((Boolean)object).booleanValue());
        } else if (dataType == String.class) {
            if (object != null) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)object));
            } else {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"");
            }
        } else if (dataType.getSuperclass() == DataType.class) {
            ((DataType)object).toBytes(buf, i);
        }
    }

    public static Object fromBytes(ByteBuf buf, int i) {
        Class dataType = dataTypes[i];
        if (dataType == Integer.class) {
            return buf.readInt();
        }
        if (dataType == Float.class) {
            return Float.valueOf(buf.readFloat());
        }
        if (dataType == Double.class) {
            return buf.readDouble();
        }
        if (dataType == Boolean.class) {
            return buf.readBoolean();
        }
        if (dataType == String.class) {
            String s = ByteBufUtils.readUTF8String((ByteBuf)buf);
            if (s != null && s.isEmpty()) {
                s = null;
            }
            return s;
        }
        if (dataType.getSuperclass() == DataType.class) {
            try {
                DataType data = (DataType)dataType.newInstance();
                return data.fromBytes(buf, i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void writeToNBT(NBTTagCompound nbt, Object[] objects) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        for (int i = 0; i < objects.length; ++i) {
            if (!shouldSave[i]) continue;
            Object object = objects[i];
            Class dataType = dataTypes[i];
            String key = keys[i];
            if (dataType == Integer.class) {
                nbttagcompound.func_74768_a(key, ((Integer)object).intValue());
                continue;
            }
            if (dataType == Float.class) {
                nbttagcompound.func_74776_a(key, ((Float)object).floatValue());
                continue;
            }
            if (dataType == Double.class) {
                nbttagcompound.func_74780_a(key, ((Double)object).doubleValue());
                continue;
            }
            if (dataType == Boolean.class) {
                nbttagcompound.func_74757_a(key, ((Boolean)object).booleanValue());
                continue;
            }
            if (dataType == String.class) {
                String s = (String)object;
                if (s == null || s.isEmpty()) continue;
                nbttagcompound.func_74778_a(key, s);
                continue;
            }
            if (dataType.getSuperclass() != DataType.class) continue;
            try {
                ((DataType)dataType.newInstance()).writeToNBT(nbttagcompound);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        nbt.func_74782_a("DataArray", (NBTBase)nbttagcompound);
    }

    public static Object[] readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound nbttagcompound = nbt.func_74775_l("DataArray");
        Object[] objects = new Object[62];
        for (int i = 0; i < objects.length; ++i) {
            if (!shouldSave[i]) continue;
            Class dataType = dataTypes[i];
            String key = keys[i];
            if (dataType == Integer.class) {
                objects[i] = nbttagcompound.func_74762_e(key);
                continue;
            }
            if (dataType == Float.class) {
                objects[i] = Float.valueOf(nbttagcompound.func_74760_g(key));
                continue;
            }
            if (dataType == Double.class) {
                objects[i] = nbttagcompound.func_74769_h(key);
                continue;
            }
            if (dataType == Boolean.class) {
                objects[i] = nbttagcompound.func_74767_n(key);
                continue;
            }
            if (dataType == String.class) {
                String s = nbttagcompound.func_74779_i(key);
                if (s != null && (s.isEmpty() || s.equals("null"))) {
                    s = null;
                }
                objects[i] = s;
                continue;
            }
            if (dataType.getSuperclass() != DataType.class) continue;
            try {
                objects[i] = ((DataType)dataType.newInstance()).readFromNBT(nbttagcompound);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return objects;
    }

    public static Object[] init() {
        Object[] objects = new Object[62];
        SHData.init(objects, 0, Boolean.class, false);
        SHData.init(objects, 1, Integer.class, 40);
        SHData.init(objects, 2, Boolean.class, false);
        SHData.init(objects, 3, Integer.class, 0);
        SHData.init(objects, 4, Integer.class, 0);
        SHData.init(objects, 5, false, Boolean.class, false);
        SHData.init(objects, 6, Float.class, Float.valueOf(1.0f));
        SHData.init(objects, 7, Boolean.class, false);
        SHData.init(objects, 8, Integer.class, 0);
        SHData.init(objects, 9, String.class, null);
        SHData.init(objects, 10, Float.class, Float.valueOf(0.0f));
        SHData.init(objects, 11, Boolean.class, false);
        SHData.init(objects, 12, Boolean.class, false);
        SHData.init(objects, 13, Boolean.class, false);
        SHData.init(objects, 14, false, Boolean.class, false);
        SHData.init(objects, 15, false, Boolean.class, false);
        SHData.init(objects, 16, false, Boolean.class, false);
        SHData.init(objects, 17, Integer.class, 0);
        SHData.init(objects, 18, Integer.class, 0);
        SHData.init(objects, 19, Float.class, Float.valueOf(0.0f));
        SHData.init(objects, 20, false, Integer.class, 0);
        SHData.init(objects, 21, Boolean.class, false);
        SHData.init(objects, 22, Integer.class, 0);
        SHData.init(objects, 23, String.class, null);
        SHData.init(objects, 24, String.class, null);
        SHData.init(objects, 25, Boolean.class, false);
        SHData.init(objects, 26, Integer.class, 0);
        SHData.init(objects, 27, Float.class, Float.valueOf(0.0f));
        SHData.init(objects, 28, Float.class, Float.valueOf(0.0f));
        SHData.init(objects, 29, Boolean.class, false);
        SHData.init(objects, 30, Boolean.class, false);
        SHData.init(objects, 31, Integer.class, 0);
        SHData.init(objects, 32, Integer.class, 0);
        SHData.init(objects, 33, false, Hero.class, null);
        SHData.init(objects, 34, false, Float.class, Float.valueOf(1.0f));
        SHData.init(objects, 35, Float.class, Float.valueOf(0.0f));
        SHData.init(objects, 36, false, Boolean.class, false);
        SHData.init(objects, 37, Integer.class, 0);
        SHData.init(objects, 38, Float.class, Float.valueOf(0.0f));
        SHData.init(objects, 39, Float.class, Float.valueOf(0.0f));
        SHData.init(objects, 40, Boolean.class, false);
        SHData.init(objects, 41, Integer.class, 0);
        SHData.init(objects, 42, Boolean.class, false);
        SHData.init(objects, 43, Boolean.class, false);
        SHData.init(objects, 44, Integer.class, 0);
        SHData.init(objects, 45, false, Boolean.class, false);
        SHData.init(objects, 46, Float.class, Float.valueOf(0.0f));
        SHData.init(objects, 47, Float.class, Float.valueOf(0.0f));
        SHData.init(objects, 48, Integer.class, 0);
        SHData.init(objects, 49, Double.class, 0.0);
        SHData.init(objects, 50, Double.class, 0.0);
        SHData.init(objects, 51, Double.class, 0.0);
        SHData.init(objects, 52, false, Boolean.class, false);
        SHData.init(objects, 53, Boolean.class, false);
        SHData.init(objects, 54, Integer.class, 0);
        SHData.init(objects, 55, Integer.class, 1);
        SHData.init(objects, 56, Boolean.class, false);
        SHData.init(objects, 57, false, Boolean.class, true);
        SHData.init(objects, 58, false, Float.class, Float.valueOf(0.0f));
        SHData.init(objects, 59, false, Float.class, Float.valueOf(0.0f));
        SHData.init(objects, 60, false, Float.class, Float.valueOf(0.0f));
        SHData.init(objects, 61, false, Float.class, Float.valueOf(0.0f));
        return objects;
    }

    private static void init(Object[] objects, int i, boolean save, Class dataType, Object defaultValue) {
        SHData.shouldSave[i] = save;
        SHData.dataTypes[i] = dataType;
        objects[i] = defaultValue;
    }

    private static void init(Object[] objects, int i, Class dataType, Object defaultValue) {
        SHData.init(objects, i, true, dataType, defaultValue);
    }

    static {
        for (Field field : SHData.class.getFields()) {
            String s = field.getType().getName();
            if (!s.equals("int") || field.getName().equals("MAX_VALUE")) continue;
            try {
                Integer i = (Integer)field.get(null);
                SHData.keys[i.intValue()] = SHHelper.getUnconventionalName(field.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

