/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.data;

import com.google.common.collect.Lists;
import fiskfille.heroes.SuperHeroesAPI;
import fiskfille.heroes.common.achievement.SHAchievements;
import fiskfille.heroes.common.data.SHData;
import fiskfille.heroes.common.entity.attribute.SHAttributes;
import fiskfille.heroes.common.helper.SHHelper;
import fiskfille.heroes.common.hero.Hero;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class SHPlayerData
implements IExtendedEntityProperties {
    public static final String IDENTIFIER = "FiskHeroesPlayer";
    public static final int maxShrinkCooldown = 1200;
    public Object[] data = SHData.init();
    public List<Item> suitsCollected = Lists.newArrayList();
    public EntityPlayer player;

    public static SHPlayerData getData(EntityPlayer player) {
        return (SHPlayerData)player.getExtendedProperties(IDENTIFIER);
    }

    public void onUpdate() {
        float scale = SHData.getFloat(this.player, 6);
        if (scale <= 0.0f) {
            scale = 1.0f;
        }
        SHData.setWithoutNotify(this.player, 6, Float.valueOf(scale));
        for (ItemStack itemstack : this.player.field_71071_by.field_70460_b) {
            this.doItemCheck(itemstack);
        }
        for (ItemStack itemstack : this.player.field_71071_by.field_70462_a) {
            this.doItemCheck(itemstack);
        }
        boolean flag = true;
        for (Hero hero : SuperHeroesAPI.getHeroes()) {
            if (SHHelper.hasCollectedHero(this.player, hero)) continue;
            flag = false;
            break;
        }
        if (flag) {
            this.player.func_71029_a((StatBase)SHAchievements.allSuits);
        }
    }

    public void doItemCheck(ItemStack itemstack) {
        if (SHHelper.getHeroFromArmor(itemstack) != null && !this.suitsCollected.contains(itemstack.func_77973_b())) {
            this.suitsCollected.add(itemstack.func_77973_b());
        }
    }

    public void saveNBTData(NBTTagCompound nbt) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        NBTTagList nbttaglist = new NBTTagList();
        nbttagcompound.func_74757_a("Saved", true);
        SHData.writeToNBT(nbttagcompound, this.data);
        for (Item item : this.suitsCollected) {
            nbttaglist.func_74742_a((NBTBase)new NBTTagString(Item.field_150901_e.func_148750_c((Object)item)));
        }
        nbttagcompound.func_74782_a("CollectedSuits", (NBTBase)nbttaglist);
        nbt.func_74782_a(IDENTIFIER, (NBTBase)nbttagcompound);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        NBTTagCompound nbttagcompound = nbt.func_74775_l(IDENTIFIER);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("CollectedSuits", 8);
        if (nbttagcompound.func_74767_n("Saved")) {
            this.data = SHData.readFromNBT(nbttagcompound);
            if (nbttaglist != null) {
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    Item item = (Item)Item.field_150901_e.func_82594_a(nbttaglist.func_150307_f(i));
                    if (item == null) continue;
                    this.suitsCollected.add(item);
                }
            }
        }
    }

    public void init(Entity entity, World world) {
        if (entity instanceof EntityPlayer) {
            this.player = (EntityPlayer)entity;
            if (this.player.func_110140_aT().func_111152_a(SHAttributes.stepHeight.func_111108_a()) == null) {
                this.player.func_110140_aT().func_111150_b(SHAttributes.stepHeight);
            }
        }
    }

    public int speedXpBarCap() {
        return 20 + SHData.getInt(this.player, 17) * 6;
    }

    public void copy(SHPlayerData props) {
        this.data = props.data;
        this.suitsCollected = props.suitsCollected;
    }
}

