/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.helper;

import com.google.common.collect.Multimap;
import fiskfille.heroes.common.ability.Ability;
import fiskfille.heroes.common.entity.attribute.SHAttributes;
import fiskfille.heroes.common.helper.SHHelper;
import fiskfille.heroes.common.helper.SpeedsterHelper;
import fiskfille.heroes.common.hero.Hero;
import fiskfille.heroes.common.item.ModItems;
import fiskfille.heroes.common.item.armor.ItemHeroArmor;
import fiskfille.heroes.common.tileentity.TileEntitySuitFabricator;
import java.util.Map;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;

public class FabricatorHelper {
    public static int getMaterialCost(Hero hero) {
        int i = hero.getTier() * 1024;
        for (int j = 0; j < hero.getAbilities().length; ++j) {
            Ability ability = hero.getAbilities()[j];
            i += ability.getTier() * 64;
        }
        if (hero.hasAbility(Ability.superSpeed)) {
            ItemStack itemstack = FabricatorHelper.getHeroItem(hero);
            i += (SpeedsterHelper.getSuitBaseSpeed(itemstack) - 3) * 256;
        }
        i += FabricatorHelper.getAttributeCost(hero, SHAttributes.swordDamage, 4.0, 64);
        i += FabricatorHelper.getAttributeCost(hero, SHAttributes.punchDamage, 1.0, 64);
        i += FabricatorHelper.getAttributeCost(hero, SHAttributes.bowDrawback, 25.0, 64);
        i += FabricatorHelper.getAttributeCost(hero, SHAttributes.arrowDamage, 7.0, 64);
        i += FabricatorHelper.getAttributeCost(hero, SHAttributes.attackDamage, 1.0, 128);
        i += FabricatorHelper.getAttributeCost(hero, SHAttributes.fallResistance, 3.0, 32);
        i += FabricatorHelper.getAttributeCost(hero, SHAttributes.jumpHeight, 1.0, 32);
        i += FabricatorHelper.getAttributeCost(hero, SHAttributes.sprintSpeed, 0.098935921634846, 64);
        return (int)((float)((i += FabricatorHelper.getAttributeCost(hero, SHAttributes.stepHeight, 0.5, 64)) * 4) / (float)SHHelper.getPiecesToSet(hero));
    }

    public static int getTotalEnergy(IInventory iinventory) {
        int i = 0;
        for (int j = 0; j < iinventory.func_70302_i_(); ++j) {
            ItemStack itemstack = iinventory.func_70301_a(j);
            i += FabricatorHelper.getEnergy(itemstack);
        }
        if (iinventory instanceof TileEntitySuitFabricator) {
            i += ((TileEntitySuitFabricator)iinventory).energy;
        }
        return i;
    }

    public static int getEnergy(ItemStack itemstack) {
        if (itemstack != null) {
            Item item = itemstack.func_77973_b();
            int i = 1;
            if (item == ModItems.tutridiumGem) {
                i = 512;
            } else if (item == ModItems.vibraniumPlate) {
                i = 32;
            }
            return itemstack.field_77994_a * i;
        }
        return 0;
    }

    public static ItemStack getHeroItem(Hero hero) {
        if (hero != null && hero.getChestplate() != null) {
            return new ItemStack(hero.getChestplate());
        }
        return null;
    }

    public static int getAttributeCost(Hero hero, IAttribute attribute, double baseValue, int factor) {
        Multimap multimap;
        ItemStack itemstack = FabricatorHelper.getHeroItem(hero);
        double modifiedValue = baseValue;
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemHeroArmor && !(multimap = itemstack.func_111283_C()).isEmpty()) {
            for (Object o : multimap.entries()) {
                Map.Entry entry = (Map.Entry)o;
                AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                String s = (String)entry.getKey();
                double amount = attributemodifier.func_111164_d();
                int operation = attributemodifier.func_111169_c();
                if (!s.equals(attribute.func_111108_a())) continue;
                if (operation == 0) {
                    modifiedValue += amount;
                    continue;
                }
                if (operation == 1) {
                    modifiedValue += baseValue * amount;
                    continue;
                }
                modifiedValue *= amount;
            }
        }
        return factor * MathHelper.func_76128_c((double)(modifiedValue / baseValue));
    }
}

