/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fiskfille.heroes.client.trail.TrailType;
import fiskfille.heroes.common.data.SHData;
import fiskfille.heroes.common.helper.SHHelper;
import fiskfille.heroes.common.helper.TemperatureHelper;
import fiskfille.heroes.common.item.armor.ItemHeroArmor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;

public class SpeedsterHelper {
    public static final String SUIT = "suit";
    public static final String NATURAL = "natural";
    public static final String TACHYON = "tachyon";
    public static final String VELOCITY9 = "velocity9";

    public static int getSuitBaseSpeed(ItemStack itemstack) {
        Multimap multimap;
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemHeroArmor && !(multimap = itemstack.func_111283_C()).isEmpty()) {
            for (Object o : multimap.entries()) {
                Map.Entry entry = (Map.Entry)o;
                AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                String s = (String)entry.getKey();
                double d = attributemodifier.func_111164_d();
                if (!s.equals("armor.baseSpeedLevels")) continue;
                return MathHelper.func_76128_c((double)d) - 1;
            }
        }
        return -1;
    }

    public static List<String> getSpeedSettingList(EntityPlayer player) {
        int j;
        int i;
        ArrayList list = Lists.newArrayList();
        if (SHHelper.getSpeedster(player) != null) {
            for (i = 0; i <= SpeedsterHelper.getSuitBaseSpeed(player.func_82169_q(2)); ++i) {
                list.add(SUIT);
            }
        }
        if (SHHelper.isPlayerSpeedster(player)) {
            for (i = 0; i < SHData.getInt(player, 17); ++i) {
                list.add(NATURAL);
            }
            if (SHHelper.hasTachyonDevice(player)) {
                i = MathHelper.func_76128_c((double)(4.0f * SHData.getFloat(player, 38)));
                for (j = 0; j < i; ++j) {
                    list.add(TACHYON);
                }
            }
            if (SHHelper.getTachyonCharge(player) > 0.0f) {
                float f = SHHelper.getTachyonCharge(player);
                f = f > 0.5f ? 1.0f : f * 2.0f;
                int i2 = MathHelper.func_76128_c((double)(f * 3.0f + 1.0f));
                for (int j2 = 0; j2 < i2; ++j2) {
                    list.add(TACHYON);
                }
            }
        }
        if (SHData.getInt(player, 31) > 0) {
            int i3 = SHData.getInt(player, 32);
            for (j = 0; j <= i3; ++j) {
                list.add(VELOCITY9);
            }
        }
        return list;
    }

    public static int getMaxSpeedSetting(EntityPlayer player) {
        return SpeedsterHelper.getSpeedSettingList(player).size() - 1;
    }

    public static int getFilteredMaxSpeedSetting(EntityPlayer player, String type) {
        List<String> list = SpeedsterHelper.getSpeedSettingList(player);
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equals(type)) continue;
            list.remove(i);
        }
        return list.size() - 1;
    }

    public static float getPlayerTopSpeed(EntityPlayer player) {
        float f = (float)((SHData.getInt(player, 1) + 1) * 50) * Math.min(TemperatureHelper.getCurrentBodyTemperature((EntityLivingBase)player) / 36.0f, 1.0f);
        return Math.max(f, 20.0f);
    }

    public static TrailType getTrailType(EntityPlayer player) {
        if (SHData.getInt(player, 31) > 0) {
            return TrailType.lightnings_blue;
        }
        return SHHelper.getSpeedster(player) != null ? SHHelper.getSpeedster(player).getTrailType() : TrailType.lightnings_gold;
    }
}

