/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.helper;

import fiskfille.heroes.SuperHeroes;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class VectorHelper {
    public static Vec3 getOffsetCoords(EntityPlayer player, double xOffset, double yOffset, double zOffset, float partialTicks) {
        Vec3 vec3 = Vec3.func_72443_a((double)xOffset, (double)yOffset, (double)zOffset);
        vec3.func_72440_a(-(player.field_70125_A + (player.field_70125_A - player.field_70127_C) * partialTicks) * (float)Math.PI / 180.0f);
        vec3.func_72442_b(-(player.field_70177_z - (player.field_70177_z - player.field_70126_B) * partialTicks) * (float)Math.PI / 180.0f);
        return Vec3.func_72443_a((double)(player.field_70165_t + vec3.field_72450_a), (double)(VectorHelper.getAccuratePlayerY(player) + vec3.field_72448_b), (double)(player.field_70161_v + vec3.field_72449_c));
    }

    public static Vec3 getOffsetCoords(EntityPlayer player, double xOffset, double yOffset, double zOffset) {
        return VectorHelper.getOffsetCoords(player, xOffset, yOffset, zOffset, 1.0f);
    }

    public static Vec3 copy(Vec3 vec3) {
        return Vec3.func_72443_a((double)vec3.field_72450_a, (double)vec3.field_72448_b, (double)vec3.field_72449_c);
    }

    public static Vec3 add(Vec3 vec3, Vec3 vec31) {
        return vec3.func_72441_c(vec31.field_72450_a, vec31.field_72448_b, vec31.field_72449_c);
    }

    public static Vec3 getBackSideCoords(EntityPlayer player, double amount, boolean side, double backAmount, boolean pitch) {
        Vec3 front = VectorHelper.getFrontCoords(player, backAmount, pitch).func_72441_c(-player.field_70165_t, -VectorHelper.getAccuratePlayerY(player), -player.field_70161_v);
        return VectorHelper.getSideCoords(player, amount, side).func_72441_c(front.field_72450_a, front.field_72448_b, front.field_72449_c);
    }

    public static Vec3 getAboveBackSideCoords(EntityPlayer player, double amount, boolean side, double backAmount, boolean pitch, double aboveAmount) {
        Vec3 front = VectorHelper.getBackSideCoords(player, amount, side, backAmount, pitch).func_72441_c(-player.field_70165_t, -VectorHelper.getAccuratePlayerY(player), -player.field_70161_v);
        return VectorHelper.getAboveCoords(player, -90.0f, aboveAmount).func_72441_c(front.field_72450_a, front.field_72448_b, front.field_72449_c);
    }

    public static Vec3 getSideCoords(EntityPlayer player, double amount, int side) {
        return VectorHelper.getSideCoords(player, amount, side, true);
    }

    public static Vec3 getSideCoords(EntityPlayer player, double amount, boolean side) {
        return VectorHelper.getSideCoords(player, amount, side ? -90 : 90);
    }

    public static Vec3 getSideCoords(EntityPlayer player, double amount, int side, boolean applyPitch) {
        float pitch = applyPitch ? player.field_70125_A : 0.0f;
        float yaw = player.field_70177_z + (float)side;
        float f3 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float yScale = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float xScale = f4 * f5;
        float zScale = f3 * f5;
        return Vec3.func_72443_a((double)player.field_70165_t, (double)VectorHelper.getAccuratePlayerY(player), (double)player.field_70161_v).func_72441_c((double)xScale * amount, (double)yScale * amount, (double)zScale * amount);
    }

    public static Vec3 getFrontCoords(EntityPlayer player, double amount, boolean applyPitch) {
        return VectorHelper.getFrontCoords(player, applyPitch ? player.field_70125_A : 0.0f, amount);
    }

    public static Vec3 getFrontCoords(EntityPlayer player, float pitch, double amount) {
        float yaw = player.field_70177_z;
        float f3 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float yScale = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float xScale = f4 * f5;
        float zScale = f3 * f5;
        return Vec3.func_72443_a((double)player.field_70165_t, (double)VectorHelper.getAccuratePlayerY(player), (double)player.field_70161_v).func_72441_c((double)xScale * amount, (double)yScale * amount, (double)zScale * amount);
    }

    public static Vec3 getAboveCoords(EntityPlayer player, float pitch, double amount) {
        float yaw = player.field_70177_z;
        float f3 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float yScale = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float xScale = f4 * f5;
        float zScale = f3 * f5;
        return Vec3.func_72443_a((double)player.field_70165_t, (double)VectorHelper.getAccuratePlayerY(player), (double)player.field_70161_v).func_72441_c((double)xScale * amount, (double)yScale * amount, (double)zScale * amount);
    }

    public static Vec3 getVerticalCoords(EntityPlayer player, float pitchOffset, double amount) {
        float pitch = player.field_70125_A - pitchOffset;
        float f3 = MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float yScale = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float xScale = f4 * f5;
        float zScale = f3 * f5;
        return Vec3.func_72443_a((double)player.field_70165_t, (double)VectorHelper.getAccuratePlayerY(player), (double)player.field_70161_v).func_72441_c((double)xScale * amount, (double)yScale * amount, (double)zScale * amount);
    }

    public static MovingObjectPosition rayTraceBlocks(World world, EntityPlayer player, double distance, boolean flag) {
        float pitch = player.field_70125_A;
        float yaw = player.field_70177_z;
        float f3 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float yScale = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float xScale = f4 * f5;
        float zScale = f3 * f5;
        Vec3 playerPos = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
        Vec3 vec31 = playerPos.func_72441_c((double)xScale * distance, (double)yScale * distance, (double)zScale * distance);
        return world.func_147447_a(playerPos, vec31, flag, !flag, false);
    }

    public static Vec3 getBackSideCoordsRenderYawOffset(EntityPlayer player, double amount, boolean side, double backAmount, boolean pitch) {
        Vec3 front = VectorHelper.getFrontCoordsRenderYawOffset(player, backAmount, pitch).func_72441_c(-player.field_70165_t, -VectorHelper.getAccuratePlayerY(player), -player.field_70161_v);
        return VectorHelper.getSideCoordsRenderYawOffset(player, amount, side).func_72441_c(front.field_72450_a, front.field_72448_b, front.field_72449_c);
    }

    public static Vec3 getSideCoordsRenderYawOffset(EntityPlayer player, double amount, boolean side) {
        return VectorHelper.getSideCoordsRenderYawOffset(player, amount, side ? -90 : 90);
    }

    public static Vec3 getSideCoordsRenderYawOffset(EntityPlayer player, double amount, int side) {
        float pitch = 0.0f;
        float yaw = player.field_70761_aq + (float)side;
        float f3 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float yScale = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float xScale = f4 * f5;
        float zScale = f3 * f5;
        return Vec3.func_72443_a((double)player.field_70165_t, (double)VectorHelper.getAccuratePlayerY(player), (double)player.field_70161_v).func_72441_c((double)xScale * amount, (double)yScale * amount, (double)zScale * amount);
    }

    public static Vec3 getFrontCoordsRenderYawOffset(EntityPlayer player, double amount, boolean applyPitch) {
        float pitch = applyPitch ? player.field_70125_A : 0.0f;
        float yaw = player.field_70761_aq;
        float f3 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float yScale = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float xScale = f4 * f5;
        float zScale = f3 * f5;
        return Vec3.func_72443_a((double)player.field_70165_t, (double)VectorHelper.getAccuratePlayerY(player), (double)player.field_70161_v).func_72441_c((double)xScale * amount, (double)yScale * amount, (double)zScale * amount);
    }

    private static double getAccuratePlayerY(EntityPlayer player) {
        return player.field_70163_u + (SuperHeroes.proxy.isClientPlayer(player) ? 0.0 : -0.2) + (double)player.func_70047_e();
    }

    public static List<EntityLivingBase> getEntitiesNear(World world, double x, double y, double z, double amount) {
        return world.func_82733_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(x - amount), (double)(y - amount), (double)(z - amount), (double)(x + amount), (double)(y + amount), (double)(z + amount)), IEntitySelector.field_94557_a);
    }
}

