/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.item.armor;

import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fiskfille.heroes.SuperHeroes;
import fiskfille.heroes.client.SuperHeroesAPIClient;
import fiskfille.heroes.client.model.ModelBipedMultiLayer;
import fiskfille.heroes.client.render.hero.HeroRenderer;
import fiskfille.heroes.common.ability.Ability;
import fiskfille.heroes.common.entity.attribute.SHAttributes;
import fiskfille.heroes.common.hero.Hero;
import fiskfille.heroes.common.item.IDualItem;
import fiskfille.heroes.common.item.ModItems;
import fiskfille.heroes.common.item.Tiers;
import fiskfille.heroes.common.weakness.Weakness;
import java.util.List;
import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.api.core.InventoryPlayerBattle;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.ISpecialArmor;

public abstract class ItemHeroArmor
extends ItemArmor
implements ISpecialArmor {
    public ItemHeroArmor(int armorPiece) {
        super(ModItems.SUPERHEROMATERIAL, 4, armorPiece);
        this.func_77656_e(1024 + (this.getHero().getTier() - 1) * 256);
    }

    public boolean func_82789_a(ItemStack itemstack1, ItemStack itemstack2) {
        return itemstack2.func_77973_b() == ModItems.tutridiumGem || super.func_82789_a(itemstack1, itemstack2);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, (double)0.01f, armor.func_77958_k() + 1 - armor.func_77960_j());
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        stack.func_77972_a((int)Math.max((float)damage / 4.0f, 1.0f), entity);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return SuperHeroesAPIClient.getRendererForHero(this.getHero()).getTexture(stack, entity, slot, type).toString();
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean b) {
        int i;
        String s = this.getHero().getName();
        if (s.contains("/")) {
            String name = s.substring(s.indexOf("/") + 1);
            list.add(EnumChatFormatting.WHITE + name);
        }
        Ability[] abilities = this.getHero().getAbilities();
        Weakness[] weaknesses = this.getHero().getWeaknesses();
        list.add(StatCollector.func_74837_a((String)"tooltip.tier", (Object[])new Object[]{this.getHero().getTier()}));
        if (itemstack.func_77942_o() && (i = itemstack.func_77978_p().func_74762_e("TachyonCharge")) > 0) {
            list.add(StatCollector.func_74837_a((String)"tooltip.tachyonCharge", (Object[])new Object[]{i, 200}));
            list.add("");
        }
        if (abilities.length > 0 || weaknesses.length > 0 || !this.getAttributeModifiers(itemstack).isEmpty()) {
            list.add(StatCollector.func_74838_a((String)"tooltip.fullSet"));
        }
        if (abilities.length > 0 || weaknesses.length > 0) {
            list.add("");
        }
        for (Ability ability : abilities) {
            list.add(EnumChatFormatting.GREEN + "* " + ability.getNameTranslated());
        }
        for (Weakness weakness : weaknesses) {
            list.add(EnumChatFormatting.YELLOW + "* " + weakness.getNameTranslated());
        }
        if (itemstack.func_77948_v()) {
            list.add("");
        }
    }

    public void addAttribute(Multimap multimap, ItemStack itemstack, IAttribute attribute, double amount, int operation) {
        multimap.put((Object)attribute.func_111108_a(), (Object)new AttributeModifier(field_111210_e, attribute.func_111108_a(), amount, operation));
    }

    public Multimap getAttributeModifiers(ItemStack itemstack) {
        Multimap multimap = super.getAttributeModifiers(itemstack);
        this.addAttribute(multimap, itemstack, SHAttributes.damageReduction, Tiers.getProtection(this.getHero().getTier()), 1);
        return multimap;
    }

    public abstract Hero getHero();

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemstack, int armorSlot) {
        HeroRenderer renderer = SuperHeroesAPIClient.getRendererForHero(this.getHero());
        ModelBiped armorModel = renderer.getModel();
        if (itemstack != null && armorModel != null) {
            armorModel.field_78116_c.field_78806_j = armorSlot == 0;
            armorModel.field_78114_d.field_78806_j = armorSlot == 0;
            armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
            armorModel.field_78112_f.field_78806_j = armorSlot == 1;
            armorModel.field_78113_g.field_78806_j = armorSlot == 1;
            armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
            boolean bl = armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
            if (armorModel instanceof ModelBipedMultiLayer) {
                ModelBipedMultiLayer model = (ModelBipedMultiLayer)armorModel;
                model.hatLayer.field_78806_j = armorSlot == 0;
                model.armorSlot = armorSlot;
                model.renderer = renderer;
            }
            if (entityLiving != null) {
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_70115_ae();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                armorModel.field_78120_m = entityLiving.func_71124_b(0) != null ? 1 : 0;
                int n = armorModel.field_78119_l = entityLiving.func_71124_b(0) != null && entityLiving.func_71124_b(0).func_77973_b() instanceof IDualItem ? 1 : 0;
                if (entityLiving instanceof EntityPlayer) {
                    ItemStack offhand;
                    EntityPlayer player = (EntityPlayer)entityLiving;
                    ItemStack heldItem = entityLiving.func_70694_bm();
                    boolean bl2 = armorModel.field_78118_o = player.func_71057_bx() > 0 && heldItem != null && heldItem.func_77975_n() == EnumAction.bow;
                    int n2 = player.func_71057_bx() > 0 && heldItem != null && heldItem.func_77975_n() == EnumAction.block ? 3 : (armorModel.field_78120_m = entityLiving.func_71124_b(0) != null ? 1 : 0);
                    int n3 = player.func_71057_bx() > 0 && heldItem != null && heldItem.func_77973_b() instanceof IDualItem && heldItem.func_77975_n() == EnumAction.block ? 3 : (armorModel.field_78119_l = player.func_71124_b(0) != null && player.func_71124_b(0).func_77973_b() instanceof IDualItem ? 1 : 0);
                    if (SuperHeroes.isBattlegearLoaded && (offhand = ((InventoryPlayerBattle)player.field_71071_by).getCurrentOffhandWeapon()) != null) {
                        armorModel.field_78119_l = 1;
                        if (player.func_71052_bv() > 0 && player.func_71011_bu() == offhand) {
                            EnumAction enumaction = offhand.func_77975_n();
                            if (enumaction == EnumAction.block) {
                                armorModel.field_78119_l = 3;
                            } else if (enumaction == EnumAction.bow) {
                                armorModel.field_78118_o = true;
                            }
                            ItemStack mainhand = player.field_71071_by.func_70448_g();
                            armorModel.field_78120_m = mainhand != null ? 1 : 0;
                        } else if (((IBattlePlayer)player).isBlockingWithShield()) {
                            armorModel.field_78119_l = 3;
                        }
                    }
                }
            }
            return armorModel;
        }
        return null;
    }
}

