/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import fiskfille.heroes.SuperHeroes;
import fiskfille.heroes.common.data.DataManager;
import fiskfille.heroes.common.data.SHData;
import fiskfille.heroes.common.helper.QuiverHelper;
import fiskfille.heroes.common.helper.SHHelper;
import fiskfille.heroes.common.helper.TemperatureHelper;
import fiskfille.heroes.common.item.ModItems;
import fiskfille.heroes.common.network.PacketSyncBase;
import fiskfille.heroes.common.network.PacketSyncHasItem;
import fiskfille.heroes.common.network.PacketSyncItem;
import fiskfille.heroes.common.network.SHNetworkManager;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketBroadcastState
extends PacketSyncBase {
    private int id;

    public PacketBroadcastState() {
    }

    public PacketBroadcastState(EntityPlayer player) {
        super(player);
        this.id = player.func_145782_y();
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.id = buf.readInt();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.id);
    }

    public static class Handler
    implements IMessageHandler<PacketBroadcastState, IMessage> {
        public IMessage onMessage(PacketBroadcastState message, MessageContext ctx) {
            Object[] playerData = message.playerData;
            if (ctx.side.isClient()) {
                EntityPlayer player = SuperHeroes.proxy.getPlayer();
                Entity lookupEntity = player.field_70170_p.func_73045_a(message.id);
                if (lookupEntity instanceof EntityPlayer && player != lookupEntity) {
                    EntityPlayer lookupPlayer = (EntityPlayer)lookupEntity;
                    for (int i = 0; i < playerData.length; ++i) {
                        if (!SHData.shouldSave[i]) continue;
                        SHData.set(lookupPlayer, i, playerData[i]);
                    }
                    DataManager.setCollectedSuits(player, message.suits);
                    TemperatureHelper.setTemperature((EntityLivingBase)lookupPlayer, message.temperature);
                    SHNetworkManager.networkWrapper.sendToServer((IMessage)new PacketSyncItem((Entity)player, QuiverHelper.getEquippedQuiver(player), 0));
                    SHNetworkManager.networkWrapper.sendToServer((IMessage)new PacketSyncItem((Entity)player, SHHelper.getEquippedTachyonDevice(player), 1));
                    SHNetworkManager.networkWrapper.sendToServer((IMessage)new PacketSyncHasItem((Entity)player, player.field_71071_by.func_146028_b(ModItems.captainAmericasShield), 2));
                    SHNetworkManager.networkWrapper.sendToServer((IMessage)new PacketSyncHasItem((Entity)player, player.field_71071_by.func_146028_b(ModItems.deadpoolsSwords), 3));
                }
            } else {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                for (int i = 0; i < playerData.length; ++i) {
                    if (!SHData.shouldSave[i]) continue;
                    SHData.setWithoutNotify((EntityPlayer)player, i, playerData[i]);
                }
                DataManager.setCollectedSuitsWithoutNotify((EntityPlayer)player, message.suits);
                TemperatureHelper.setTemperatureWithoutNotify((EntityLivingBase)player, message.temperature);
            }
            return null;
        }
    }
}

