/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import fiskfille.heroes.SuperHeroes;
import fiskfille.heroes.common.config.SHConfig;
import fiskfille.heroes.common.data.DataManager;
import fiskfille.heroes.common.data.SHData;
import fiskfille.heroes.common.helper.QuiverHelper;
import fiskfille.heroes.common.helper.SHHelper;
import fiskfille.heroes.common.helper.TemperatureHelper;
import fiskfille.heroes.common.item.ModItems;
import fiskfille.heroes.common.network.PacketSyncBase;
import fiskfille.heroes.common.network.PacketSyncHasItem;
import fiskfille.heroes.common.network.PacketSyncItem;
import fiskfille.heroes.common.network.SHNetworkManager;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class PacketPlayerJoin
extends PacketSyncBase {
    public boolean durabilityScaledProtection;
    public boolean heatGunFire;
    public boolean geomancerExplosions;
    public String[] unphasableBlocks;
    public boolean heatVisionGriefing;
    public boolean canaryCryGriefing;

    public PacketPlayerJoin() {
    }

    public PacketPlayerJoin(EntityPlayer player) {
        super(player);
        this.durabilityScaledProtection = SHConfig.durabilityScaledProtection;
        this.heatGunFire = SHConfig.heatGunFire;
        this.geomancerExplosions = SHConfig.geomancerExplosions;
        this.unphasableBlocks = SHConfig.unphasableBlocks;
        this.heatVisionGriefing = SHConfig.heatVisionGriefing;
        this.canaryCryGriefing = SHConfig.canaryCryGriefing;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.durabilityScaledProtection = buf.readBoolean();
        this.heatGunFire = buf.readBoolean();
        this.geomancerExplosions = buf.readBoolean();
        this.heatVisionGriefing = buf.readBoolean();
        this.canaryCryGriefing = buf.readBoolean();
        this.unphasableBlocks = new String[buf.readInt()];
        for (int i = 0; i < this.unphasableBlocks.length; ++i) {
            this.unphasableBlocks[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.durabilityScaledProtection);
        buf.writeBoolean(this.heatGunFire);
        buf.writeBoolean(this.geomancerExplosions);
        buf.writeBoolean(this.heatVisionGriefing);
        buf.writeBoolean(this.canaryCryGriefing);
        buf.writeInt(this.unphasableBlocks.length);
        for (int i = 0; i < this.unphasableBlocks.length; ++i) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.unphasableBlocks[i]);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketPlayerJoin, IMessage> {
        public IMessage onMessage(PacketPlayerJoin message, MessageContext ctx) {
            Object[] playerData = message.playerData;
            if (ctx.side.isClient()) {
                EntityPlayer player = SuperHeroes.proxy.getPlayer();
                SHConfig.clientDurabilityScaledProtection = message.durabilityScaledProtection;
                SHConfig.clientHeatGunFire = message.heatGunFire;
                SHConfig.clientGeomancerExplosions = message.geomancerExplosions;
                SHConfig.clientUnphasableBlocks = message.unphasableBlocks;
                SHConfig.clientHeatVisionGriefing = message.heatVisionGriefing;
                SHConfig.clientCanaryCryGriefing = message.canaryCryGriefing;
                SHConfig.syncServerOptions();
                for (int i = 0; i < playerData.length; ++i) {
                    if (!SHData.shouldSave[i]) continue;
                    SHData.setWithoutNotify(player, i, playerData[i]);
                }
                DataManager.setCollectedSuitsWithoutNotify(player, message.suits);
                TemperatureHelper.setTemperatureWithoutNotify((EntityLivingBase)player, message.temperature);
                SHNetworkManager.networkWrapper.sendToServer((IMessage)new PacketSyncItem((Entity)player, QuiverHelper.getEquippedQuiver(player), 0));
                SHNetworkManager.networkWrapper.sendToServer((IMessage)new PacketSyncItem((Entity)player, SHHelper.getEquippedTachyonDevice(player), 1));
                SHNetworkManager.networkWrapper.sendToServer((IMessage)new PacketSyncHasItem((Entity)player, player.field_71071_by.func_146028_b(ModItems.captainAmericasShield), 2));
                SHNetworkManager.networkWrapper.sendToServer((IMessage)new PacketSyncHasItem((Entity)player, player.field_71071_by.func_146028_b(ModItems.deadpoolsSwords), 3));
            }
            return null;
        }
    }
}

