/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import fiskfille.heroes.SuperHeroes;
import fiskfille.heroes.SuperHeroesAPI;
import fiskfille.heroes.common.hero.Hero;
import fiskfille.heroes.common.network.SHNetworkManager;
import fiskfille.heroes.common.tileentity.TileEntitySuitFabricator;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class PacketSetSelectedHero
implements IMessage {
    private int x;
    private int y;
    private int z;
    private String name;

    public PacketSetSelectedHero() {
    }

    public PacketSetSelectedHero(int x, int y, int z, Hero hero) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.name = hero != null ? hero.getName() : "";
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
    }

    public static class Handler
    implements IMessageHandler<PacketSetSelectedHero, IMessage> {
        public IMessage onMessage(PacketSetSelectedHero message, MessageContext ctx) {
            EntityPlayer player = ctx.side.isClient() ? SuperHeroes.proxy.getPlayer() : ctx.getServerHandler().field_147369_b;
            World world = player.field_70170_p;
            TileEntitySuitFabricator tile = (TileEntitySuitFabricator)world.func_147438_o(message.x, message.y, message.z);
            Hero hero = SuperHeroesAPI.getHeroFromName(message.name);
            if (tile != null) {
                tile.hero = hero;
                if (ctx.side.isServer()) {
                    SHNetworkManager.networkWrapper.sendToAll((IMessage)message);
                }
            }
            return null;
        }
    }
}

