/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import fiskfille.heroes.SuperHeroes;
import fiskfille.heroes.client.particle.SHParticleType;
import fiskfille.heroes.client.particle.SHParticles;
import fiskfille.heroes.common.damagesource.ModDamageSources;
import fiskfille.heroes.common.data.SHData;
import fiskfille.heroes.common.entity.EntityCactus;
import fiskfille.heroes.common.entity.EntityCactusSpike;
import fiskfille.heroes.common.entity.EntityFireBlast;
import fiskfille.heroes.common.entity.EntityIcicle;
import fiskfille.heroes.common.helper.DonatorHelper;
import fiskfille.heroes.common.helper.VectorHelper;
import fiskfille.heroes.common.network.SHNetworkManager;
import fiskfille.heroes.common.utilitybelt.EnumUtilityBelt;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class PacketShoot
implements IMessage {
    public int id;
    public int blastType;
    public int blastTypeMeta;

    public PacketShoot() {
    }

    public PacketShoot(EntityPlayer player, int type, int meta) {
        this.id = player.func_145782_y();
        this.blastType = type;
        this.blastTypeMeta = meta;
    }

    public PacketShoot(EntityPlayer player, int type) {
        this(player, type, 0);
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.blastType = buf.readInt();
        this.blastTypeMeta = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.blastType);
        buf.writeInt(this.blastTypeMeta);
    }

    public static class Handler
    implements IMessageHandler<PacketShoot, IMessage> {
        public IMessage onMessage(PacketShoot message, MessageContext ctx) {
            int type = message.blastType;
            int meta = message.blastTypeMeta;
            if (ctx.side.isClient()) {
                EntityPlayer player = SuperHeroes.proxy.getPlayer();
                Entity entity = player.field_70170_p.func_73045_a(message.id);
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player1 = (EntityPlayer)entity;
                    this.onMessage(player1, message, ctx);
                }
            } else {
                Entity entity;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (player != null && (entity = player.field_70170_p.func_73045_a(message.id)) instanceof EntityPlayer) {
                    EntityPlayer player1 = (EntityPlayer)entity;
                    if (player.field_70170_p.field_72995_K) {
                        SHNetworkManager.networkWrapper.sendToServer((IMessage)new PacketShoot(player1, type, meta));
                    } else {
                        SHNetworkManager.networkWrapper.sendToDimension((IMessage)new PacketShoot(player1, type, meta), player.field_71093_bK);
                    }
                    this.onMessage(player1, message, ctx);
                }
            }
            return null;
        }

        public void onMessage(EntityPlayer player, PacketShoot message, MessageContext ctx) {
            World world = player.field_70170_p;
            int type = message.blastType;
            int meta = message.blastTypeMeta;
            if (type == 0) {
                double range = 32.0;
                double frontOffset = 0.6;
                double sideOffset = -0.3;
                Vec3 src = VectorHelper.getOffsetCoords(player, sideOffset, -0.4f, frontOffset);
                Vec3 dest = VectorHelper.getOffsetCoords(player, sideOffset, 0.0, frontOffset + range);
                MovingObjectPosition rayTrace = world.func_72933_a(VectorHelper.copy(src), VectorHelper.copy(dest));
                Vec3 hitVec = null;
                hitVec = rayTrace == null ? dest : rayTrace.field_72307_f;
                double distance = player.func_70011_f(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c);
                for (double point = 0.0; point <= distance; point += 0.15) {
                    Vec3 particleVec = VectorHelper.getOffsetCoords(player, sideOffset, -0.4f, frontOffset + point);
                    for (EntityLivingBase entity : VectorHelper.getEntitiesNear(world, particleVec.field_72450_a, particleVec.field_72448_b, particleVec.field_72449_c, 0.5)) {
                        if (entity == null || entity == player) continue;
                        hitVec.field_72450_a = entity.field_70165_t;
                        hitVec.field_72448_b = entity.field_70163_u;
                        hitVec.field_72449_c = entity.field_70161_v;
                        rayTrace = new MovingObjectPosition((Entity)entity, hitVec);
                        distance = player.func_70011_f(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c);
                        break;
                    }
                    Random rand = new Random();
                    for (int i = 0; i < 2; ++i) {
                        double spread = Math.sin((float)(1.0 - point / distance) / 10.0f);
                        double spread1 = 0.0;
                        SHParticles.spawnParticle(SHParticleType.REPULSOR_BLAST, particleVec.field_72450_a + (double)(rand.nextFloat() - 0.5f) * spread, particleVec.field_72448_b + (double)(rand.nextFloat() - 0.5f) * spread, particleVec.field_72449_c + (double)(rand.nextFloat() - 0.5f) * spread, (double)(rand.nextFloat() - 0.5f) * spread1, (double)(rand.nextFloat() - 0.5f) * spread1, (double)(rand.nextFloat() - 0.5f) * spread1);
                    }
                }
                if (rayTrace != null && rayTrace.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && rayTrace.field_72308_g instanceof EntityLivingBase) {
                    EntityLivingBase entity = (EntityLivingBase)rayTrace.field_72308_g;
                    entity.func_70097_a(ModDamageSources.causeRepulsorDamage((Entity)player), 12.0f);
                }
                player.func_85030_a("fiskheroes:repulsor_blast", 1.0f, 1.0f);
            } else if (type == 1) {
                EntityFireBlast entity = new EntityFireBlast(world, (EntityLivingBase)player);
                if (!player.field_70170_p.field_72995_K) {
                    world.func_72838_d((Entity)entity);
                }
                player.func_85030_a("mob.ghast.fireball", 1.0f, 1.0f);
            } else if (type == 2) {
                float f = SHData.getFloat(player, 35);
                float spread = 0.5f;
                for (int i = 0; i <= (int)(f * 5.0f); ++i) {
                    EntityIcicle entity = new EntityIcicle(world, (EntityLivingBase)player);
                    if (i > 0) {
                        entity.field_70159_w += (Math.random() - 0.5) * (double)spread;
                        entity.field_70181_x += (Math.random() - 0.5) * (double)spread;
                        entity.field_70179_y += (Math.random() - 0.5) * (double)spread;
                    }
                    if (player.field_70170_p.field_72995_K) continue;
                    world.func_72838_d((Entity)entity);
                }
            } else if (type == 3) {
                EnumUtilityBelt utilType = EnumUtilityBelt.values()[meta % EnumUtilityBelt.values().length];
                if (utilType.type == EnumUtilityBelt.Type.PROJECTILE) {
                    try {
                        Entity entity = utilType.entityClass.getConstructor(World.class, EntityLivingBase.class).newInstance(world, player);
                        if (!world.field_72995_K) {
                            world.func_72838_d(entity);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (type == 4) {
                Random rand = new Random();
                float spread = 0.5f;
                world.func_72956_a((Entity)player, "fiskheroes:bow", 1.0f, 1.0f / (rand.nextFloat() * 0.4f + 1.2f) + 0.75f);
                if (meta == 0) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_71020_j(1.0f);
                    }
                    for (int i = 0; i <= 10; ++i) {
                        EntityCactusSpike entity = new EntityCactusSpike(world, (EntityLivingBase)player);
                        if (i > 0) {
                            entity.field_70159_w += (Math.random() - 0.5) * (double)spread;
                            entity.field_70181_x += (Math.random() - 0.5) * (double)spread;
                            entity.field_70179_y += (Math.random() - 0.5) * (double)spread;
                        }
                        if (player.field_70170_p.field_72995_K) continue;
                        world.func_72838_d((Entity)entity);
                    }
                } else {
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_71020_j(6.0f);
                    }
                    int spikes = 72;
                    float prevYaw = player.field_70177_z;
                    for (int i = 0; i < spikes; ++i) {
                        player.field_70177_z = (float)i * (360.0f / (float)spikes);
                        EntityCactusSpike entity = new EntityCactusSpike(world, (EntityLivingBase)player);
                        Vec3 vec3 = Vec3.func_72443_a((double)0.0, (double)0.01f, (double)0.0);
                        float pitch = 0.0f;
                        float yaw = i;
                        vec3.func_72440_a(-pitch * (float)Math.PI / 180.0f);
                        vec3.func_72442_b(-yaw * (float)Math.PI / 180.0f);
                        if (player.field_70170_p.field_72995_K) continue;
                        world.func_72838_d((Entity)entity);
                    }
                    player.field_70177_z = prevYaw;
                }
            } else if (type == 5) {
                int z;
                int y;
                int x;
                double range = 16.0;
                Vec3 src = VectorHelper.getOffsetCoords(player, 0.0, 0.0, 0.0);
                Vec3 dest = VectorHelper.getOffsetCoords(player, 0.0, 0.0, range);
                MovingObjectPosition rayTrace = world.func_72933_a(VectorHelper.copy(src), VectorHelper.copy(dest));
                Vec3 hitVec = null;
                hitVec = rayTrace == null ? dest : rayTrace.field_72307_f;
                if (rayTrace != null && rayTrace.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && world.func_147439_a(x = rayTrace.field_72311_b, y = rayTrace.field_72312_c, z = rayTrace.field_72309_d) == Blocks.field_150434_aF) {
                    int start = y;
                    int end = y;
                    while (world.func_147439_a(x, start - 1, z) == Blocks.field_150434_aF) {
                        --start;
                    }
                    while (world.func_147439_a(x, end + 1, z) == Blocks.field_150434_aF) {
                        ++end;
                    }
                    int height = end - start + 1;
                    String s = world.func_82736_K().func_82767_a("doTileDrops");
                    world.func_82736_K().func_82764_b("doTileDrops", "false");
                    for (int i = 0; i <= height; ++i) {
                        world.func_147468_f(x, start + i, z);
                    }
                    world.func_82736_K().func_82764_b("doTileDrops", s);
                    if (!world.field_72995_K) {
                        EntityCactus entity = new EntityCactus(world);
                        entity.func_70107_b((float)x + 0.5f, start, (float)z + 0.5f);
                        entity.setCactusSize(height);
                        entity.setDonatorSummoned(DonatorHelper.isDonator(player));
                        world.func_72838_d((Entity)entity);
                    }
                }
            }
        }
    }
}

