/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.network;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import fiskfille.heroes.common.data.SHData;
import fiskfille.heroes.common.data.SHPlayerData;
import fiskfille.heroes.common.helper.TemperatureHelper;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;

public abstract class PacketSyncBase
implements IMessage {
    public Object[] playerData;
    public List<Item> suits;
    public float temperature;

    public PacketSyncBase() {
    }

    public PacketSyncBase(EntityPlayer player) {
        this.playerData = SHPlayerData.getData((EntityPlayer)player).data;
        this.suits = SHPlayerData.getData((EntityPlayer)player).suitsCollected;
        this.temperature = TemperatureHelper.getTemperature((EntityLivingBase)player);
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        this.playerData = new Object[buf.readInt()];
        for (i = 0; i < this.playerData.length; ++i) {
            if (!SHData.shouldSave[i]) continue;
            this.playerData[i] = SHData.fromBytes(buf, i);
        }
        i = buf.readInt();
        this.suits = Lists.newArrayList();
        for (int j = 0; j < i; ++j) {
            Item item = (Item)Item.field_150901_e.func_82594_a(ByteBufUtils.readUTF8String((ByteBuf)buf));
            if (item == null) continue;
            this.suits.add(item);
        }
        this.temperature = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        int i;
        buf.writeInt(this.playerData.length);
        for (i = 0; i < this.playerData.length; ++i) {
            if (!SHData.shouldSave[i]) continue;
            SHData.toBytes(buf, i, this.playerData[i]);
        }
        buf.writeInt(this.suits.size());
        for (i = 0; i < this.suits.size(); ++i) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)Item.field_150901_e.func_148750_c((Object)this.suits.get(i)));
        }
        buf.writeFloat(this.temperature);
    }
}

