/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.common.utilitybelt;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import fiskfille.heroes.common.ability.Ability;
import fiskfille.heroes.common.helper.SHHelper;
import fiskfille.heroes.common.helper.SHRenderHelper;
import fiskfille.heroes.common.hero.Hero;
import fiskfille.heroes.common.network.PacketShoot;
import fiskfille.heroes.common.network.SHNetworkManager;
import fiskfille.heroes.common.utilitybelt.EnumUtilityBelt;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class UtilityBeltHandler {
    private Minecraft mc = Minecraft.func_71410_x();
    public static int[] useCooldown = new int[EnumUtilityBelt.values().length];
    public static int[] prevUseCooldown = new int[useCooldown.length];
    public static int[] timesUsed = new int[useCooldown.length];
    public static final int utilityBeltCooldownMax = 25;
    public static int utilityBeltCooldown;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        EntityPlayer player = event.entityPlayer;
        Hero hero = SHHelper.getHero(player);
        PlayerInteractEvent.Action action = event.action;
        if ((action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR || action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) && hero != null && hero.hasAbility(Ability.utilityBelt)) {
            EnumUtilityBelt type = SHHelper.getUtilityBelt(player);
            if (type.type != EnumUtilityBelt.Type.NONE && player.func_70694_bm() == null) {
                int i = type.ordinal();
                if (useCooldown[i] == 0) {
                    player.func_71038_i();
                    SHNetworkManager.networkWrapper.sendToServer((IMessage)new PacketShoot(player, 3, type.ordinal()));
                    int n = i;
                    timesUsed[n] = timesUsed[n] + 1;
                    if (timesUsed[n] >= type.maxUses) {
                        UtilityBeltHandler.useCooldown[i] = type.useCooldown;
                    }
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (player == this.mc.field_71439_g && event.phase == TickEvent.Phase.END) {
            for (int i = 0; i < useCooldown.length; ++i) {
                UtilityBeltHandler.prevUseCooldown[i] = useCooldown[i];
                if (useCooldown[i] > 0) {
                    int n = i;
                    useCooldown[n] = useCooldown[n] - 1;
                }
                if (useCooldown[i] != 0 || prevUseCooldown[i] != 1) continue;
                UtilityBeltHandler.timesUsed[i] = 0;
            }
            if (utilityBeltCooldown > 0) {
                --utilityBeltCooldown;
            }
        }
    }

    public static float getCooldownCompletion(EnumUtilityBelt type) {
        return 1.0f - SHRenderHelper.median(useCooldown[type.ordinal()], prevUseCooldown[type.ordinal()]) / (float)type.useCooldown;
    }
}

