/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.heroes.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import fiskfille.heroes.SuperHeroesAPI;
import fiskfille.heroes.client.gui.GuiSuitFabricator;
import fiskfille.heroes.common.helper.FabricatorHelper;
import fiskfille.heroes.common.helper.SHHelper;
import fiskfille.heroes.common.hero.Hero;
import fiskfille.heroes.common.item.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class SuitFabricatorRecipeHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiSuitFabricator.class;
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"recipe.suit_fabricator");
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadCraftingRecipes(ItemStack result) {
        Hero hero = SHHelper.getHeroFromArmor(result);
        if (hero != null) {
            Object[] items = new Object[6];
            ItemStack itemstack = new ItemStack(ModItems.tutridiumGem);
            while (FabricatorHelper.getEnergy(itemstack) < FabricatorHelper.getMaterialCost(hero)) {
                ++itemstack.field_77994_a;
            }
            for (int i = 0; i < 6 && itemstack.field_77994_a > 0; ++i) {
                items[i] = new ItemStack(ModItems.tutridiumGem, Math.min(itemstack.field_77994_a, 64));
                itemstack.field_77994_a -= 64;
            }
            CachedSuitFabricatorRecipe recipe = new CachedSuitFabricatorRecipe(result, items);
            recipe.computeVisuals();
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient.func_77973_b() == ModItems.tutridiumGem) {
            for (Hero hero : SuperHeroesAPI.getHeroes()) {
                for (Item item : new Item[]{hero.getHelmet(), hero.getChestplate(), hero.getLeggings(), hero.getBoots()}) {
                    if (item == null) continue;
                    Object[] items = new Object[6];
                    ItemStack itemstack = new ItemStack(ModItems.tutridiumGem);
                    ItemStack result = new ItemStack(item);
                    while (FabricatorHelper.getEnergy(itemstack) < FabricatorHelper.getMaterialCost(hero)) {
                        ++itemstack.field_77994_a;
                    }
                    for (int i = 0; i < 6 && itemstack.field_77994_a > 0; ++i) {
                        items[i] = new ItemStack(ModItems.tutridiumGem, Math.min(itemstack.field_77994_a, 64));
                        itemstack.field_77994_a -= 64;
                    }
                    CachedSuitFabricatorRecipe recipe = new CachedSuitFabricatorRecipe(result, items);
                    recipe.computeVisuals();
                    this.arecipes.add(recipe);
                }
            }
        }
    }

    public String getGuiTexture() {
        return "fiskheroes:textures/gui/container/suit_fabricator_nei.png";
    }

    public String getOverlayIdentifier() {
        return "suit_fabricator";
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)41);
        CachedSuitFabricatorRecipe recipe1 = (CachedSuitFabricatorRecipe)((Object)this.arecipes.get(recipe));
        ItemStack itemstack = recipe1.result.item;
        if (itemstack != null) {
            boolean flag = GuiDraw.fontRenderer.func_82883_a();
            GuiDraw.fontRenderer.func_78264_a(true);
            String s = SHHelper.formatHero(SHHelper.getHeroFromArmor(itemstack));
            String s1 = GuiDraw.fontRenderer.func_78269_a(s, 104 - GuiDraw.fontRenderer.func_78256_a("..."));
            if (GuiDraw.fontRenderer.func_78256_a(s) > GuiDraw.fontRenderer.func_78256_a(s1)) {
                s1 = s1 + "...";
            }
            GuiDraw.drawString((String)s1, (int)13, (int)8, (int)-1);
            GuiDraw.fontRenderer.func_78264_a(flag);
        }
    }

    public class CachedSuitFabricatorRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;

        public CachedSuitFabricatorRecipe(ItemStack out, Object[] items) {
            super((TemplateRecipeHandler)SuitFabricatorRecipeHandler.this);
            this.result = new PositionedStack((Object)out, 140, 16);
            this.ingredients = new ArrayList();
            this.setIngredients(items);
        }

        public void setIngredients(Object[] items) {
            for (int i = 0; i < 6; ++i) {
                this.addSlotToContainer(i, 15 + 18 * i, 35, items);
            }
        }

        private void addSlotToContainer(int id, int x, int y, Object[] items) {
            if (items[id] != null) {
                PositionedStack stack = new PositionedStack(items[id], x - 5, y - 11, false);
                this.ingredients.add(stack);
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(SuitFabricatorRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
        }
    }
}

