/*
 * Decompiled with CFR 0.152.
 */
package at.flabs.betterfurnaces.core;

import at.flabs.betterfurnaces.BetterFurnaces;
import at.flabs.betterfurnaces.api.IBFUpgrade;
import at.flabs.betterfurnaces.api.IBetterFurnace;
import at.flabs.betterfurnaces.api.IElectricFuelItem;
import at.flabs.betterfurnaces.api.LiquidFuels;
import at.flabs.betterfurnaces.network.BFMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityBetterFurnace
extends TileEntity
implements IBetterFurnace,
IFluidHandler {
    private boolean loaded = false;
    private byte facing = 0;
    private String name = null;
    public boolean storage = false;
    private ItemStack[] inventory = new ItemStack[9];
    public int ticksrunning = 0;
    public int ticksburning = 0;
    public boolean burning = false;
    public int tickswouldburn = 0;
    public FluidTank tank = new FluidTank(4000);
    public boolean hasChanged = false;
    int fu = 0;

    public int getBurnTimeRemainingScaled(int max) {
        return this.ticksburning * max / this.tickswouldburn;
    }

    public int getCookProgressScaled(int max) {
        return this.ticksrunning * max / this.getBurnTime();
    }

    public int getEnergyScaled(int max) {
        if (this.inventory[3] != null && this.inventory[3].func_77973_b() instanceof IElectricFuelItem) {
            return ((IElectricFuelItem)this.inventory[3].func_77973_b()).getEnergyScaled(this, max);
        }
        return 0;
    }

    public void blockUpdate() {
        for (int i = 6; i < 9; ++i) {
            if (this.inventory[i] == null || !(this.inventory[i].func_77973_b() instanceof IBFUpgrade)) continue;
            ((IBFUpgrade)this.inventory[i].func_77973_b()).blockUpdate(this, i, (IInventory)this);
        }
        if (this.inventory[3] != null && this.inventory[3].func_77973_b() instanceof IElectricFuelItem) {
            ((IElectricFuelItem)this.inventory[3].func_77973_b()).blockUpdate(this);
        }
    }

    public boolean isBurning() {
        return this.ticksburning > 0;
    }

    public boolean canSmelt() {
        boolean can = this.canSmeltIntern();
        for (int i = 6; i < 9; ++i) {
            if (this.inventory[i] == null || !(this.inventory[i].func_77973_b() instanceof IBFUpgrade)) continue;
            can = ((IBFUpgrade)this.inventory[i].func_77973_b()).canSmelt(this, i, (IInventory)this) && can;
        }
        return can;
    }

    public void smeltItem() {
        int i;
        if (!this.canSmelt()) {
            return;
        }
        ItemStack[] results = this.getSmeltingResult(this.inventory[1]);
        for (i = 6; i < 9; ++i) {
            if (this.inventory[i] == null || !(this.inventory[i].func_77973_b() instanceof IBFUpgrade)) continue;
            ((IBFUpgrade)this.inventory[i].func_77973_b()).onSmelting(this, results, i, (IInventory)this);
        }
        if (results.length == 2) {
            this.fit(4, results[0]);
            this.fit(5, results[1]);
        }
        if (results.length == 1) {
            ItemStack left = this.fit(4, results[0]);
            if (this.storage) {
                this.fit(5, left);
            }
        }
        --this.inventory[1].field_77994_a;
        if (this.inventory[1].field_77994_a == 0) {
            this.inventory[1] = this.inventory[1].func_77973_b().getContainerItem(this.inventory[1]);
        }
        for (i = 6; i < 9; ++i) {
            if (this.inventory[i] == null || !(this.inventory[i].func_77973_b() instanceof IBFUpgrade)) continue;
            ((IBFUpgrade)this.inventory[i].func_77973_b()).afterSmelting(this, results, i, (IInventory)this);
        }
    }

    private boolean canSmeltIntern() {
        if (this.inventory[1] == null) {
            return false;
        }
        ItemStack[] results = this.getSmeltingResult(this.inventory[1]);
        if (results == null || results.length <= 0 || results.length > 2) {
            return false;
        }
        if (results.length == 2 && this.storage && this.canFit(4, results[0]) && this.canFit(5, results[1])) {
            return true;
        }
        if (results.length == 1) {
            if (!this.storage) {
                return this.canFit(4, results[0]);
            }
            if (this.canFit(4, results[0])) {
                return true;
            }
            if (results[0] != null) {
                ItemStack res = results[0].func_77946_l();
                int result = this.inventory[4].field_77994_a + res.field_77994_a;
                int max = Math.min(this.func_70297_j_(), res.func_77976_d());
                if (result > max) {
                    res.field_77994_a = result - max;
                }
                return this.canFit(5, res);
            }
        }
        return false;
    }

    private boolean canFit(int slot, ItemStack fill) {
        if (fill == null || slot < 0 || slot >= this.inventory.length) {
            return false;
        }
        if (this.inventory[slot] == null) {
            return true;
        }
        if (!this.inventory[slot].func_77969_a(fill)) {
            return false;
        }
        int result = this.inventory[slot].field_77994_a + fill.field_77994_a;
        return result <= this.func_70297_j_() && result <= fill.func_77976_d();
    }

    public int getColor() {
        for (int i = 6; i < 9; ++i) {
            IBFUpgrade ib;
            if (this.inventory[i] == null || !(this.inventory[i].func_77973_b() instanceof IBFUpgrade) || !(ib = (IBFUpgrade)this.inventory[i].func_77973_b()).changesColor(this, i, (IInventory)this)) continue;
            return ib.getColor(this, i, (IInventory)this);
        }
        return -1;
    }

    public ItemStack fit(int slot, ItemStack is) {
        if (is == null || slot < 0 || slot >= this.inventory.length) {
            return is;
        }
        if (this.inventory[slot] == null) {
            this.inventory[slot] = is.func_77946_l();
            return null;
        }
        if (!is.func_77969_a(this.inventory[slot])) {
            return is;
        }
        int result = this.inventory[slot].field_77994_a + is.field_77994_a;
        int max = Math.min(this.func_70297_j_(), is.func_77976_d());
        this.inventory[slot].field_77994_a = Math.min(max, result);
        if (result - max <= 0) {
            return null;
        }
        return new ItemStack(is.func_77973_b(), result - max, is.func_77960_j());
    }

    public int getBurnTime() {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (meta == 0) {
            return 150;
        }
        if (meta == 1) {
            return 100;
        }
        if (meta == 2) {
            return 50;
        }
        if (meta == 3) {
            return 8;
        }
        if (meta == 4) {
            return 4;
        }
        return 200;
    }

    public void func_145845_h() {
        boolean wasBurning = this.isBurning();
        boolean invChanged = false;
        if (this.ticksburning > 0) {
            --this.ticksburning;
        }
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 6; i < 9; ++i) {
                if (this.inventory[i] == null || !(this.inventory[i].func_77973_b() instanceof IBFUpgrade)) continue;
                ((IBFUpgrade)this.inventory[i].func_77973_b()).updateTick(this, i, (IInventory)this);
            }
            if (this.inventory[3] != null && this.inventory[3].func_77973_b() instanceof IElectricFuelItem) {
                ((IElectricFuelItem)this.inventory[3].func_77973_b()).update(this);
            }
            this.inventory[0] = this.fit(1, this.inventory[0]);
            this.inventory[2] = this.fit(3, this.inventory[2]);
            for (Item upgrade : LiquidFuels.upgrades) {
                FluidStack newFluid;
                LiquidFuels newFuel;
                if (!this.hasUpgrade(upgrade) || (newFuel = LiquidFuels.getFuelForLiquid(newFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inventory[3]))) == null || newFuel.upgrade != upgrade || this.tank.fill(newFluid, false) != newFluid.amount) continue;
                this.tank.fill(newFluid, true);
                if (this.inventory[3] == null) continue;
                --this.inventory[3].field_77994_a;
                if (this.inventory[3].field_77994_a != 0) continue;
                this.inventory[3] = this.inventory[3].func_77973_b().getContainerItem(this.inventory[3]);
            }
            if (this.ticksburning == 0 && this.canSmelt()) {
                if (this.inventory[3] != null && !this.isLava(this.inventory[3])) {
                    this.tickswouldburn = this.ticksburning = this.getItemBurnTime(this.inventory[3]);
                }
                if (this.ticksburning > 0) {
                    invChanged = true;
                    if (this.inventory[3] != null) {
                        --this.inventory[3].field_77994_a;
                        if (this.inventory[3].field_77994_a == 0) {
                            this.inventory[3] = this.inventory[3].func_77973_b().getContainerItem(this.inventory[3]);
                        }
                    }
                }
                for (Item i : LiquidFuels.upgrades) {
                    LiquidFuels fuel;
                    if (this.ticksburning != 0 || !this.hasUpgrade(i) || (fuel = LiquidFuels.getFuelForLiquid(this.tank.getFluid())) == null || fuel.upgrade != i || this.tank.getFluid().amount < 10) continue;
                    this.tickswouldburn = this.ticksburning = fuel.totalBurningTime * this.getBurnTime() / 20000;
                    this.tank.getFluid().amount -= 10;
                    if (this.tank.getFluid().amount > 0) continue;
                    this.tank.setFluid(null);
                }
                if (this.ticksburning == 0 && this.inventory[3] != null && this.inventory[3].func_77973_b() instanceof IElectricFuelItem && ((IElectricFuelItem)this.inventory[3].func_77973_b()).canSmeltAndTakeEnergy(this)) {
                    this.tickswouldburn = this.ticksburning = this.getBurnTime();
                    invChanged = true;
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.ticksrunning;
                if (this.ticksrunning == this.getBurnTime()) {
                    this.ticksrunning = 0;
                    this.smeltItem();
                    invChanged = true;
                }
            } else {
                this.ticksrunning = 0;
            }
            if (wasBurning != this.ticksburning > 0) {
                invChanged = true;
                this.burning = this.ticksburning > 0;
                this.fu = 3;
            }
            if (this.fu > 0) {
                --this.fu;
                if (this.fu == 0) {
                    invChanged = true;
                }
            }
        }
        if (invChanged) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
    }

    private boolean isLava(ItemStack container) {
        FluidStack temp = FluidContainerRegistry.getFluidForFilledItem((ItemStack)container);
        if (temp != null) {
            return temp.getFluid() == FluidRegistry.LAVA;
        }
        return false;
    }

    private int getItemBurnTime(ItemStack is) {
        int fuel = TileEntityFurnace.func_145952_a((ItemStack)is);
        for (int i = 6; i < 9; ++i) {
            if (this.inventory[i] == null || !(this.inventory[i].func_77973_b() instanceof IBFUpgrade)) continue;
            fuel += ((IBFUpgrade)this.inventory[i].func_77973_b()).getFuelValue(i, this, fuel, (IInventory)this);
        }
        return fuel * this.getBurnTime() / 200;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.loaded) {
            this.setDefaultDirection();
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("face", this.facing);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.name);
        }
        nbt.func_74757_a("storage", this.storage);
        NBTTagList items = new NBTTagList();
        for (byte i = 0; i < this.inventory.length; i = (byte)((byte)(i + 1))) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", i);
            this.inventory[i].func_77955_b(itemTag);
            items.func_74742_a((NBTBase)itemTag);
        }
        nbt.func_74782_a("Items", (NBTBase)items);
        nbt.func_74768_a("burntime", this.ticksburning);
        nbt.func_74768_a("smelttime", this.ticksrunning);
        nbt.func_74768_a("itemtime", this.tickswouldburn);
        nbt.func_74757_a("burning", this.burning);
        nbt.func_74757_a("change", true);
        this.tank.writeToNBT(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.facing = nbt.func_74771_c("face");
        if (nbt.func_74764_b("CustomName")) {
            this.name = nbt.func_74779_i("CustomName");
        }
        this.storage = nbt.func_74767_n("storage");
        NBTTagList items = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound itemTag = items.func_150305_b(i);
            byte b = itemTag.func_74771_c("Slot");
            if (b < 0 || b >= this.inventory.length) continue;
            this.inventory[b] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        }
        this.ticksburning = nbt.func_74762_e("burntime");
        this.ticksrunning = nbt.func_74762_e("smelttime");
        this.tickswouldburn = nbt.func_74762_e("itemtime");
        this.burning = nbt.func_74767_n("burning");
        this.hasChanged = nbt.func_74767_n("change");
        this.tank.readFromNBT(nbt);
        this.loaded = true;
    }

    public boolean canUpdate() {
        return true;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public int getLightValue() {
        return this.burning ? 15 : 0;
    }

    protected void setDefaultDirection() {
        if (!this.field_145850_b.field_72995_K) {
            Block i = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
            Block j = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
            Block k = this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
            Block l = this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
            if (i.func_149730_j() && !j.func_149730_j()) {
                this.facing = (byte)3;
            }
            if (j.func_149730_j() && !i.func_149730_j()) {
                this.facing = (byte)2;
            }
            if (k.func_149730_j() && !l.func_149730_j()) {
                this.facing = (byte)5;
            }
            if (l.func_149730_j() && !k.func_149730_j()) {
                this.facing = (byte)4;
            }
        }
    }

    public void placedBy(EntityLivingBase el, ItemStack is) {
        int l = MathHelper.func_76128_c((double)((double)(el.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        this.facing = (byte)(l == 0 ? 2 : (l == 1 ? 5 : (l == 2 ? 3 : (l == 3 ? 4 : 0))));
        if (is.func_82837_s()) {
            this.name = is.func_82833_r();
        }
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == this.facing) {
            return new int[]{6, 7, 8};
        }
        ItemStack is = this.getUpgrade(BetterFurnaces.instance.upg.itemPiping);
        if (is != null) {
            byte out = this.getAbsoluteSide(BetterFurnaces.instance.upg.itemPiping.getSide("Out", is), (byte)0);
            byte in = this.getAbsoluteSide(BetterFurnaces.instance.upg.itemPiping.getSide("In", is), (byte)1);
            byte fin = this.getAbsoluteSide(BetterFurnaces.instance.upg.itemPiping.getSide("Fin", is), (byte)1);
            int[] res = new int[]{};
            if (side == out) {
                res = Arrays.copyOf(res, res.length + (this.storage ? 2 : 1));
                if (this.storage) {
                    res[res.length - 2] = 4;
                }
                int n = res[res.length - 1] = this.storage ? 5 : 4;
            }
            if (side == in) {
                res = Arrays.copyOf(res, res.length + (this.storage ? 2 : 1));
                if (this.storage) {
                    res[res.length - 2] = 1;
                }
                int n = res[res.length - 1] = this.storage ? 0 : 1;
            }
            if (side == fin) {
                res = Arrays.copyOf(res, res.length + (this.storage ? 2 : 1));
                if (this.storage) {
                    res[res.length - 2] = 3;
                }
                res[res.length - 1] = this.storage ? 2 : 3;
            }
            System.out.println(Arrays.toString(res) + " " + out + ", " + in + ", " + fin);
            return res;
        }
        if (side == 1) {
            int[] nArray2;
            if (this.storage) {
                int[] nArray3 = new int[2];
                nArray3[0] = 1;
                nArray2 = nArray3;
                nArray3[1] = 0;
            } else {
                int[] nArray4 = new int[1];
                nArray2 = nArray4;
                nArray4[0] = 1;
            }
            return nArray2;
        }
        if (side == 0) {
            int[] nArray5;
            if (this.storage) {
                int[] nArray6 = new int[2];
                nArray6[0] = 4;
                nArray5 = nArray6;
                nArray6[1] = 5;
            } else {
                int[] nArray7 = new int[1];
                nArray5 = nArray7;
                nArray7[0] = 4;
            }
            return nArray5;
        }
        if (this.storage) {
            int[] nArray8 = new int[2];
            nArray8[0] = 3;
            nArray = nArray8;
            nArray8[1] = 2;
        } else {
            int[] nArray9 = new int[1];
            nArray = nArray9;
            nArray9[0] = 3;
        }
        return nArray;
    }

    public byte getAbsoluteSide(byte relative, byte standart) {
        if (relative == 1) {
            return this.rotateLeft(this.rotateLeft(this.facing));
        }
        if (relative == 2) {
            return this.rotateLeft(this.facing);
        }
        if (relative == 0) {
            return this.rotateLeft(this.rotateLeft(this.rotateLeft(this.facing)));
        }
        return standart;
    }

    public byte rotateLeft(byte facing) {
        if (facing == 2) {
            return 4;
        }
        if (facing == 4) {
            return 3;
        }
        if (facing == 3) {
            return 5;
        }
        if (facing == 5) {
            return 2;
        }
        return 0;
    }

    public boolean func_102007_a(int slot, ItemStack is, int side) {
        return slot != 4 && slot != 5;
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return true;
    }

    public int func_70302_i_() {
        return 9;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int i) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= i) {
                ItemStack is = this.inventory[slot];
                this.inventory[slot] = null;
                if (slot > 5 && slot < 9) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                return is;
            }
            ItemStack is = this.inventory[slot].func_77979_a(i);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            if (slot > 5 && slot < 9) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return is;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack is = this.inventory[slot];
            this.inventory[slot] = null;
            return is;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack is) {
        this.inventory[slot] = is;
        if (is != null && is.field_77994_a > this.func_70297_j_()) {
            is.field_77994_a = this.func_70297_j_();
        }
        if (slot > 5 && slot < 9) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public String func_145825_b() {
        return this.name == null ? "tile.flabs.bf." + this.func_145832_p() + ".name" : this.name;
    }

    public boolean func_145818_k_() {
        return this.name != null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer ep) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return true;
    }

    public double func_96107_aA() {
        return this.field_145851_c;
    }

    public double func_96109_aB() {
        return this.field_145848_d;
    }

    public double func_96108_aC() {
        return this.field_145849_e;
    }

    @Override
    public byte getFacing() {
        return this.facing;
    }

    @Override
    public ItemStack[] getSmeltingResult(ItemStack input) {
        ItemStack[] smelt = this.getInternalSmelting(input);
        for (int i = 6; i < 9; ++i) {
            if (this.inventory[i] == null || !(this.inventory[i].func_77973_b() instanceof IBFUpgrade)) continue;
            ((IBFUpgrade)this.inventory[i].func_77973_b()).modifySmeltingResult(this, smelt, i, (IInventory)this);
        }
        return smelt;
    }

    public ItemStack[] getInternalSmelting(ItemStack input) {
        for (int i = 6; i < 9; ++i) {
            ItemStack[] is;
            if (this.inventory[i] == null || !(this.inventory[i].func_77973_b() instanceof IBFUpgrade) || (is = ((IBFUpgrade)this.inventory[i].func_77973_b()).getSmeltingResult(input, this, i, (IInventory)this)) == null) continue;
            return is;
        }
        return new ItemStack[]{FurnaceRecipes.func_77602_a().func_151395_a(input)};
    }

    @Override
    public boolean hasExtraStorage() {
        return this.storage;
    }

    @Override
    public boolean hasUpgrade(Item upgrade) {
        return this.getUpgrade(upgrade) != null;
    }

    @Override
    public boolean hasElectricUpgrade() {
        return this.inventory[3] != null && this.inventory[3].func_77973_b() instanceof IElectricFuelItem;
    }

    @Override
    public ItemStack getUpgrade(Item upgrade) {
        for (int i = 6; i < 9; ++i) {
            ItemStack sub;
            if (this.inventory[i] == null) continue;
            if (this.inventory[i].func_77973_b() == upgrade) {
                return this.inventory[i];
            }
            if (this.inventory[i].func_77973_b() != BetterFurnaces.instance.upg.itemPackage || (sub = BetterFurnaces.instance.upg.itemPackage.getUpgrade(upgrade, this, i, (IInventory)this)) == null) continue;
            return sub;
        }
        return null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        for (LiquidFuels lf : LiquidFuels.fuels) {
            if (lf.liquid.getFluid() != fluid) continue;
            return true;
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public static void recieveData(byte[] data) {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
        try {
            int x = dis.readInt();
            int y = dis.readInt();
            int z = dis.readInt();
            byte[] b = new byte[dis.readInt()];
            dis.read(b);
            NBTTagCompound nbt = CompressedStreamTools.func_152457_a((byte[])b, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
            Minecraft.func_71410_x().field_71441_e.func_147438_o(x, y, z).func_145839_a(nbt);
            Minecraft.func_71410_x().field_71441_e.func_147471_g(x, y, z);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BFMessage getDeleteMessage() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(this.field_145851_c);
            dos.writeInt(this.field_145848_d);
            dos.writeInt(this.field_145849_e);
            NBTTagCompound nbt = new NBTTagCompound();
            this.func_145841_b(nbt);
            byte[] b = CompressedStreamTools.func_74798_a((NBTTagCompound)nbt);
            dos.writeInt(b.length);
            dos.write(b);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new BFMessage(1, baos.toByteArray());
    }
}

