/*
 * Decompiled with CFR 0.152.
 */
package toast.apocalypse;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Random;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import toast.apocalypse.CommandSetDifficulty;
import toast.apocalypse.CommonProxy;
import toast.apocalypse.EventHandler;
import toast.apocalypse.ItemBucketHelm;
import toast.apocalypse.MessageWorldDifficulty;
import toast.apocalypse.PropHelper;
import toast.apocalypse.Properties;
import toast.apocalypse.WorldDifficultyManager;
import toast.apocalypse.entity.EntityDestroyerFireball;
import toast.apocalypse.entity.EntityMonsterFishHook;
import toast.apocalypse.entity.EntitySeekerFireball;

@Mod(modid="Apocalypse", name="Apocalypse", version="0.0.7")
public class ApocalypseMod {
    public static final String MODID = "Apocalypse";
    public static final String VERSION = "0.0.7";
    public static boolean debug = false;
    @SidedProxy(clientSide="toast.apocalypse.client.ClientProxy", serverSide="toast.apocalypse.CommonProxy")
    public static CommonProxy proxy;
    public static final Random random;
    public static SimpleNetworkWrapper CHANNEL;
    public static final String TEXTURE_PATH = "Apocalypse:textures/";
    public static final String[] ENTITIES;
    public static final int[][] ENTITY_EGG_COLORS;
    public static ItemBucketHelm bucketHelm;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Properties.init(new File(event.getModConfigurationDirectory(), MODID));
        debug = Properties.getBoolean("_general", "debug");
        ApocalypseMod.logDebug("Loading in debug mode!");
        PropHelper.class.getName();
        CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("Apocalypse|Info");
        int id = 0;
        CHANNEL.registerMessage(MessageWorldDifficulty.Handler.class, MessageWorldDifficulty.class, id++, Side.CLIENT);
        String texture = "Apocalypse:";
        bucketHelm = (ItemBucketHelm)new ItemBucketHelm().func_77655_b("bucketHelm").func_77637_a(CreativeTabs.field_78037_j).func_111206_d(texture + "bucket_helm");
        GameRegistry.registerItem((Item)bucketHelm, (String)bucketHelm.func_77658_a().substring(5));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        new WorldDifficultyManager();
        new EventHandler();
        this.registerMobs();
        proxy.registerRenderers();
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)bucketHelm), (Object[])new Object[]{Items.field_151133_ar});
    }

    private void registerMobs() {
        int id = 0;
        boolean makeSpawnEggs = Properties.getBoolean("_general", "spawn_eggs");
        Method eggIdClaimer = null;
        if (makeSpawnEggs) {
            try {
                eggIdClaimer = EntityRegistry.class.getDeclaredMethod("validateAndClaimId", Integer.TYPE);
                eggIdClaimer.setAccessible(true);
            }
            catch (Exception ex) {
                ApocalypseMod.log("Error claiming spawn egg ID! Spawn eggs will probably be overwritten.");
                ex.printStackTrace();
            }
        }
        for (int i = 0; i < ENTITIES.length; ++i) {
            try {
                Class<?> entityClass = Class.forName("toast.apocalypse.entity.Entity" + ENTITIES[i]);
                EntityRegistry.registerModEntity(entityClass, (String)ENTITIES[i], (int)id++, (Object)this, (int)80, (int)3, (boolean)true);
                if (!makeSpawnEggs) continue;
                int eggId = EntityRegistry.findGlobalUniqueEntityId();
                try {
                    if (eggIdClaimer != null) {
                        eggId = (Integer)eggIdClaimer.invoke((Object)EntityRegistry.instance(), eggId);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                EntityList.field_75623_d.put(eggId, entityClass);
                EntityList.field_75627_a.put(eggId, new EntityList.EntityEggInfo(eggId, ENTITY_EGG_COLORS[i][0], ENTITY_EGG_COLORS[i][1]));
                continue;
            }
            catch (ClassNotFoundException ex) {
                ApocalypseMod.logError("@" + ENTITIES[i] + ": class not found!");
            }
        }
        EntityRegistry.registerModEntity(EntitySeekerFireball.class, (String)"SeekerFireball", (int)id++, (Object)this, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityDestroyerFireball.class, (String)"DestroyerFireball", (int)id++, (Object)this, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityMonsterFishHook.class, (String)"FishHook", (int)id++, (Object)this, (int)64, (int)5, (boolean)true);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        WorldDifficultyManager.init(event.getServer());
        ServerCommandManager commandManager = (ServerCommandManager)event.getServer().func_71187_D();
        commandManager.func_71560_a((ICommand)new CommandSetDifficulty());
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        WorldDifficultyManager.cleanup();
    }

    public static void log(String message) {
        System.out.println("[Apocalypse] " + message);
    }

    public static void logDebug(String message) {
        if (debug) {
            System.out.println("[Apocalypse] [debug] " + message);
        }
    }

    public static void logWarning(String message) {
        System.out.println("[Apocalypse] [WARNING] " + message);
    }

    public static void logError(String message) {
        if (debug) {
            throw new RuntimeException("[Apocalypse] " + message);
        }
        ApocalypseMod.log("[ERROR] " + message);
    }

    public static void exception(String message) {
        throw new RuntimeException("[Apocalypse] " + message);
    }

    static {
        random = new Random();
        ENTITIES = new String[]{"Breecher", "Grump", "Seeker", "Ghost", "Destroyer"};
        ENTITY_EGG_COLORS = new int[][]{{894731, 0xF9F9F9}, {0xF9F9F9, 2966004}, {0xF9F9F9, 11013646}, {0xBCBCBC, 7375001}, {0x7D7D7D, 11013646}};
    }
}

