/*
 * Decompiled with CFR 0.152.
 */
package toast.apocalypse;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import toast.apocalypse.PropHelper;

public class BlockHelper {
    public static boolean shouldDamage(Block block, EntityLiving entity, boolean needsTool, World world, int x, int y, int z) {
        ItemStack held = entity.func_70694_bm();
        int metadata = world.func_72805_g(x, y, z);
        return block.func_149712_f(world, x, y, z) >= 0.0f && (!needsTool || block.func_149688_o().func_76229_l() || held != null && ForgeHooks.canToolHarvestBlock((Block)block, (int)metadata, (ItemStack)held));
    }

    public static float getDamageAmount(Block block, EntityLiving entity, World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        float hardness = block.func_149712_f(world, x, y, z);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!BlockHelper.canHarvestBlock(entity.func_70694_bm(), block)) {
            return PropHelper.BREAK_SPEED / hardness / 100.0f;
        }
        return BlockHelper.getCurrentStrengthVsBlock(entity, block, metadata) * PropHelper.BREAK_SPEED / hardness / 30.0f;
    }

    public static boolean canHarvestBlock(ItemStack itemStack, Block block) {
        return block.func_149688_o().func_76229_l() || itemStack != null && itemStack.func_150998_b(block);
    }

    public static float getCurrentStrengthVsBlock(EntityLiving entity, Block block, int metadata) {
        int efficiency;
        float strength;
        ItemStack held = entity.func_70694_bm();
        float f = strength = held == null ? 1.0f : held.func_77973_b().getDigSpeed(held, block, metadata);
        if (strength > 1.0f && (efficiency = EnchantmentHelper.func_77509_b((EntityLivingBase)entity)) > 0 && held != null) {
            strength += (float)(efficiency * efficiency + 1);
        }
        if (entity.func_70644_a(Potion.field_76422_e)) {
            strength *= 1.0f + (float)(entity.func_70660_b(Potion.field_76422_e).func_76458_c() + 1) * 0.2f;
        }
        if (entity.func_70644_a(Potion.field_76419_f)) {
            strength *= 1.0f - (float)(entity.func_70660_b(Potion.field_76419_f).func_76458_c() + 1) * 0.2f;
        }
        if (entity.func_70055_a(Material.field_151586_h) && !EnchantmentHelper.func_77510_g((EntityLivingBase)entity)) {
            strength /= 5.0f;
        }
        if (!entity.field_70122_E) {
            strength /= 5.0f;
        }
        return strength < 0.0f ? 0.0f : strength;
    }

    private BlockHelper() {
    }
}

