/*
 * Decompiled with CFR 0.152.
 */
package toast.apocalypse;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import toast.apocalypse.ApocalypseMod;
import toast.apocalypse.PropHelper;

public class EquipmentHelper {
    public static final Item[][] ARMOR_TIERS = new Item[][]{{Items.field_151021_T, Items.field_151029_X, Items.field_151167_ab, Items.field_151175_af}, {Items.field_151026_S, Items.field_151022_W, Items.field_151165_aa, Items.field_151173_ae}, {Items.field_151027_R, Items.field_151023_V, Items.field_151030_Z, Items.field_151163_ad}, {Items.field_151024_Q, Items.field_151020_U, Items.field_151028_Y, Items.field_151161_ac}};
    public static final Item[][] WEAPON_TIERS = new Item[][]{{Items.field_151041_m, Items.field_151052_q, Items.field_151040_l, Items.field_151048_u}, {Items.field_151053_p, Items.field_151049_t, Items.field_151036_c, Items.field_151056_x}, {Items.field_151039_o, Items.field_151050_s, Items.field_151035_b, Items.field_151046_w}, {Items.field_151038_n, Items.field_151051_r, Items.field_151037_a, Items.field_151047_v}};
    public static final Item[] ANCIENT_ARMOR = new Item[]{Items.field_151151_aj, Items.field_151149_ai, Items.field_151171_ah, Items.field_151169_ag};
    public static final Item[] ANCIENT_WEAPONS = new Item[]{Items.field_151010_B, Items.field_151006_E, Items.field_151005_D, Items.field_151011_C};
    public static final Enchantment[][] ANCIENT_ENCHANTS = new Enchantment[][]{{Enchantment.field_77332_c, Enchantment.field_77329_d, Enchantment.field_77330_e, Enchantment.field_77327_f, Enchantment.field_77328_g, Enchantment.field_77340_h, Enchantment.field_77341_i, Enchantment.field_92091_k}, {Enchantment.field_77338_j, Enchantment.field_77339_k, Enchantment.field_77336_l, Enchantment.field_77337_m, Enchantment.field_77334_n, Enchantment.field_77335_o, Enchantment.field_77349_p, Enchantment.field_77348_q, Enchantment.field_77346_s}, {Enchantment.field_77335_o, Enchantment.field_77345_t, Enchantment.field_77344_u, Enchantment.field_77343_v, Enchantment.field_77342_w}};

    public static int nextOpenArmorSlot(EntityLivingBase entity) {
        int[] slots = new int[4];
        int count = 0;
        int s = 5;
        while (s-- > 1) {
            if (entity.func_71124_b(s) != null) continue;
            slots[count++] = s;
        }
        if (count > 0) {
            return slots[entity.func_70681_au().nextInt(count)];
        }
        return -1;
    }

    public static int nextWeaponType(EntityLivingBase entity) {
        int type = 0;
        if (PropHelper.WEAPON_WEIGHTS_TOTAL > 0) {
            int choice = entity.func_70681_au().nextInt(PropHelper.WEAPON_WEIGHTS_TOTAL);
            for (int weight : PropHelper.WEAPON_WEIGHTS) {
                if ((choice -= weight) < 0) break;
                ++type;
            }
            if (type > 3) {
                ApocalypseMod.logError("Invalid weapon weights!");
                type = 0;
            }
        }
        return type;
    }

    public static void forcePotion(EntityLivingBase entity, PotionEffect potion) {
        if (!entity.func_70687_e(potion)) {
            NBTTagCompound tag = new NBTTagCompound();
            entity.func_70109_d(tag);
            if (!tag.func_74764_b("ActiveEffects")) {
                tag.func_74782_a("ActiveEffects", (NBTBase)new NBTTagList());
            }
            tag.func_150295_c("ActiveEffects", (int)tag.func_74732_a()).func_74742_a((NBTBase)potion.func_82719_a(new NBTTagCompound()));
            entity.func_70020_e(tag);
        } else {
            entity.func_70690_d(potion);
        }
    }

    public static void forceEnchant(ItemStack itemStack, Enchantment enchantment, int level, boolean insert) {
        NBTTagCompound enchTag;
        int tagCount;
        if (!itemStack.field_77990_d.func_74764_b("ench")) {
            itemStack.field_77990_d.func_74782_a("ench", (NBTBase)new NBTTagList());
        }
        NBTTagList enchList = itemStack.func_77986_q();
        int i = tagCount = enchList.func_74745_c();
        while (i-- > 0) {
            enchTag = enchList.func_150305_b(i);
            if (enchTag.func_74765_d("id") != enchantment.field_77352_x) continue;
            enchTag.func_74777_a("lvl", (short)((byte)Math.max(level, enchTag.func_74765_d("lvl"))));
            if (insert && tagCount > 1) {
                enchList.func_74744_a(i);
                enchList.func_150304_a(0, (NBTBase)enchTag);
            }
            return;
        }
        enchTag = new NBTTagCompound();
        enchTag.func_74777_a("id", (short)enchantment.field_77352_x);
        enchTag.func_74777_a("lvl", (short)((byte)level));
        if (insert && tagCount > 0) {
            enchList.func_150304_a(0, (NBTBase)enchTag);
        } else {
            enchList.func_74742_a((NBTBase)enchTag);
        }
    }

    private EquipmentHelper() {
    }
}

