/*
 * Decompiled with CFR 0.152.
 */
package toast.apocalypse;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import toast.apocalypse.ApocalypseMod;
import toast.apocalypse.EquipmentHelper;
import toast.apocalypse.NameHelper;
import toast.apocalypse.PropHelper;
import toast.apocalypse.WorldDifficultyManager;

public class EventHandler {
    public static final Potion[] ALLOWED_POTIONS = new Potion[]{Potion.field_76420_g, Potion.field_76426_n, Potion.field_76424_c, Potion.field_76428_l, Potion.field_76429_m, Potion.field_76427_o};
    public static final int[] POTION_LEVELS = new int[]{0, 0, 2, 2, 1, 0};

    public static void applyGravity(EntityPlayer player, int duration) {
        NBTTagCompound data = WorldDifficultyManager.getData(player);
        data.func_74768_a("Gravity", duration);
    }

    public static void onPlayerUpdate(EntityPlayer player, NBTTagCompound data) {
        int gravityTime;
        if (PropHelper.RAIN_DAMAGE_TICKS > 0 && !EnchantmentHelper.func_77510_g((EntityLivingBase)player) && player.field_70170_p.func_72951_B((int)Math.floor(player.field_70165_t), (int)Math.floor(player.field_70163_u + (double)player.field_70131_O), (int)Math.floor(player.field_70161_v))) {
            int rainTime = data.func_74762_e("Rain") + 5;
            if (rainTime >= PropHelper.RAIN_DAMAGE_TICKS) {
                data.func_82580_o("Rain");
                float damage = 1.0f;
                ItemStack helmet = player.func_71124_b(4);
                if (helmet != null) {
                    damage = helmet.func_77973_b() == ApocalypseMod.bucketHelm ? 0.0f : (damage *= 0.5f);
                    if (helmet.func_77984_f()) {
                        helmet.func_77964_b(helmet.func_77952_i() + player.func_70681_au().nextInt(2));
                        if (helmet.func_77952_i() >= helmet.func_77958_k()) {
                            player.func_70669_a(helmet);
                            player.func_70062_b(4, (ItemStack)null);
                        }
                    }
                }
                if (damage > 0.0f) {
                    player.func_70097_a(WorldDifficultyManager.RAIN_DAMAGE, damage);
                }
            } else {
                data.func_74768_a("Rain", rainTime);
            }
        }
        if ((gravityTime = data.func_74762_e("Gravity")) > 0) {
            if ((gravityTime -= 5) <= 0) {
                data.func_82580_o("Gravity");
            } else {
                data.func_74768_a("Gravity", gravityTime);
            }
            if (!player.field_70122_E) {
                player.field_70181_x -= 0.41;
                if (player instanceof EntityPlayerMP) {
                    try {
                        ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity((Entity)player));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    public static void initializeEntity(EntityLivingBase entity) {
        Class<?> entityClass = entity.getClass();
        long worldDifficulty = WorldDifficultyManager.getWorldDifficulty();
        if (worldDifficulty <= 0L) {
            return;
        }
        boolean fullMoon = WorldDifficultyManager.isFullMoon(entity.field_70170_p);
        EventHandler.initializeAncient(entity, entityClass, worldDifficulty, fullMoon);
        EventHandler.initializeEquipment(entity, entityClass, worldDifficulty, fullMoon);
        EventHandler.initializePotions(entity, entityClass, worldDifficulty, fullMoon);
        EventHandler.initializeAttributes(entity, entityClass, worldDifficulty, fullMoon);
    }

    public EventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.world.field_73013_u != EnumDifficulty.PEACEFUL && !PropHelper.THUNDER_BLACKLIST.contains(event.entityLiving.getClass()) && event.world.func_72911_I() && event.world.field_73012_v.nextDouble() < PropHelper.THUNDER_SPAWNING && event.world.func_72855_b(event.entityLiving.field_70121_D) && event.world.func_72945_a((Entity)event.entityLiving, event.entityLiving.field_70121_D).isEmpty() && !event.world.func_72953_d(event.entityLiving.field_70121_D)) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.world.field_72995_K && event.entity instanceof EntityLivingBase && !(event.entity instanceof EntityPlayer) && !PropHelper.BLACKLIST.contains(event.entity.getClass())) {
            WorldDifficultyManager.markForInit((EntityLivingBase)event.entity);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerSleepInBed(PlayerSleepInBedEvent event) {
        if (PropHelper.FULL_MOON_SLEEP || event.entityPlayer.func_70608_bn() || !event.entityPlayer.func_70089_S() || !event.entityPlayer.field_70170_p.field_73011_w.func_76569_d() || event.entityPlayer.field_70170_p.func_72935_r()) {
            return;
        }
        if (WorldDifficultyManager.isFullMoon(event.entityPlayer.field_70170_p)) {
            event.result = EntityPlayer.EnumStatus.OTHER_PROBLEM;
            event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.bed.Apocalypse.fullMoon", new Object[0]));
        }
    }

    private static void initializeAncient(EntityLivingBase entity, Class entityClass, long worldDifficulty, boolean fullMoon) {
        if (!PropHelper.ANCIENT_BLACKLIST.contains(entityClass)) {
            double effectiveDifficulty = (double)worldDifficulty / (double)PropHelper.ANCIENT_TIME;
            double bonus = PropHelper.ANCIENT_CHANCE * effectiveDifficulty;
            if (PropHelper.ANCIENT_CHANCE_MAX >= 0.0 && bonus > PropHelper.ANCIENT_CHANCE_MAX) {
                bonus = PropHelper.ANCIENT_CHANCE_MAX;
            }
            if (fullMoon) {
                bonus += PropHelper.ANCIENT_LUNAR_CHANCE;
            }
            if (entity.func_70681_au().nextDouble() < bonus) {
                IAttributeInstance attribute;
                if (PropHelper.ANCIENT_REGEN >= 0) {
                    EquipmentHelper.forcePotion(entity, new PotionEffect(Potion.field_76428_l.field_76415_H, Integer.MAX_VALUE, PropHelper.ANCIENT_REGEN, true));
                }
                if (PropHelper.ANCIENT_RESIST >= 0) {
                    EquipmentHelper.forcePotion(entity, new PotionEffect(Potion.field_76429_m.field_76415_H, Integer.MAX_VALUE, PropHelper.ANCIENT_RESIST, true));
                }
                if (PropHelper.ANCIENT_FIRE_RESIST) {
                    EquipmentHelper.forcePotion(entity, new PotionEffect(Potion.field_76426_n.field_76415_H, Integer.MAX_VALUE, 0, true));
                }
                if (PropHelper.ANCIENT_WATER_BREATH) {
                    EquipmentHelper.forcePotion(entity, new PotionEffect(Potion.field_76427_o.field_76415_H, Integer.MAX_VALUE, 0, true));
                }
                if ((attribute = entity.func_110148_a(SharedMonsterAttributes.field_111264_e)) != null) {
                    if (PropHelper.ANCIENT_DAMAGE_BONUS != 0.0) {
                        attribute.func_111121_a(new AttributeModifier("AncientFlatDAMAGE", PropHelper.ANCIENT_DAMAGE_BONUS, 0));
                    }
                    if (PropHelper.ANCIENT_DAMAGE_MULT != 0.0) {
                        attribute.func_111121_a(new AttributeModifier("AncientMultDAMAGE", PropHelper.ANCIENT_DAMAGE_MULT, 1));
                    }
                }
                if ((attribute = entity.func_110148_a(SharedMonsterAttributes.field_111267_a)) != null) {
                    if (PropHelper.ANCIENT_HEALTH_BONUS != 0.0) {
                        attribute.func_111121_a(new AttributeModifier("AncientFlatHEALTH", PropHelper.ANCIENT_HEALTH_BONUS, 0));
                    }
                    if (PropHelper.ANCIENT_HEALTH_MULT != 0.0) {
                        attribute.func_111121_a(new AttributeModifier("AncientMultHEALTH", PropHelper.ANCIENT_HEALTH_MULT, 1));
                    }
                }
                if ((attribute = entity.func_110148_a(SharedMonsterAttributes.field_111266_c)) != null && PropHelper.ANCIENT_KNOCKBACK_RESIST_BONUS != 0.0) {
                    attribute.func_111121_a(new AttributeModifier("AncientFlatRESIST", PropHelper.ANCIENT_KNOCKBACK_RESIST_BONUS, 0));
                }
                if ((attribute = entity.func_110148_a(SharedMonsterAttributes.field_111263_d)) != null && PropHelper.ANCIENT_SPEED_MULT != 0.0) {
                    attribute.func_111121_a(new AttributeModifier("AncientMultSPEED", PropHelper.ANCIENT_SPEED_MULT, 1));
                }
                entity.func_70606_j(entity.func_110138_aP());
                String name = NameHelper.setEntityName(entity.func_70681_au(), entity);
                if (entity.func_71124_b(0) == null || !(entity.func_71124_b(0).func_77973_b() instanceof ItemBow)) {
                    entity.func_70062_b(0, new ItemStack(EquipmentHelper.ANCIENT_WEAPONS[EquipmentHelper.nextWeaponType(entity)]));
                }
                int slot = 5;
                while (slot-- > 1) {
                    entity.func_70062_b(slot, new ItemStack(EquipmentHelper.ANCIENT_ARMOR[slot - 1]));
                }
                int uniqueSlot = entity.func_70681_au().nextBoolean() ? 0 : entity.func_70681_au().nextInt(4) + 1;
                ItemStack uniqueItem = entity.func_71124_b(uniqueSlot);
                if (uniqueItem != null) {
                    if (entity instanceof EntityLiving) {
                        ((EntityLiving)entity).func_96120_a(uniqueSlot, 2.0f);
                    }
                    int enchantType = uniqueSlot > 0 ? 0 : (uniqueItem.func_77973_b() instanceof ItemBow ? 2 : 1);
                    Enchantment enchantment = EquipmentHelper.ANCIENT_ENCHANTS[enchantType][entity.func_70681_au().nextInt(EquipmentHelper.ANCIENT_ENCHANTS[enchantType].length)];
                    NameHelper.setItemName(entity.func_70681_au(), uniqueItem, name, enchantment);
                    try {
                        EnchantmentHelper.func_77504_a((Random)entity.func_70681_au(), (ItemStack)uniqueItem, (int)30);
                    }
                    catch (Exception ex) {
                        ApocalypseMod.logDebug("Error applying enchantments to unique item! slot:" + uniqueSlot + " entity:" + entity.toString());
                    }
                    EquipmentHelper.forceEnchant(uniqueItem, enchantment, enchantment.func_77325_b() + 1, true);
                    EquipmentHelper.forceEnchant(uniqueItem, Enchantment.field_77347_r, enchantType == 1 ? 5 : 3, false);
                }
            }
        }
    }

    private static void initializeEquipment(EntityLivingBase entity, Class entityClass, long worldDifficulty, boolean fullMoon) {
        int i;
        int tier;
        double level;
        double bonus;
        double effectiveDifficulty;
        boolean[] equipped = new boolean[5];
        if (!PropHelper.ARMOR_BLACKLIST.contains(entityClass)) {
            effectiveDifficulty = (double)worldDifficulty / (double)PropHelper.ARMOR_TIME;
            bonus = PropHelper.ARMOR_CHANCE * effectiveDifficulty;
            double mult = PropHelper.ARMOR_EXTRA * effectiveDifficulty;
            level = PropHelper.ARMOR_TIER * effectiveDifficulty;
            if (PropHelper.ARMOR_CHANCE_MAX >= 0.0 && bonus > PropHelper.ARMOR_CHANCE_MAX) {
                bonus = PropHelper.ARMOR_CHANCE_MAX;
            }
            if (PropHelper.ARMOR_EXTRA_MAX >= 0.0 && mult > PropHelper.ARMOR_EXTRA_MAX) {
                mult = PropHelper.ARMOR_EXTRA_MAX;
            }
            if (PropHelper.ARMOR_TIER_MAX >= 0.0 && level > PropHelper.ARMOR_TIER_MAX) {
                level = PropHelper.ARMOR_TIER_MAX;
            }
            if (fullMoon) {
                bonus += PropHelper.ARMOR_LUNAR_CHANCE;
                mult += PropHelper.ARMOR_LUNAR_EXTRA;
                level += PropHelper.ARMOR_LUNAR_TIER;
            }
            if (entity.func_70681_au().nextDouble() < bonus) {
                int slot;
                tier = 0;
                i = 3;
                while (i-- > 0) {
                    if (!(entity.func_70681_au().nextDouble() < level)) continue;
                    ++tier;
                }
                while ((slot = EquipmentHelper.nextOpenArmorSlot(entity)) >= 0) {
                    entity.func_70062_b(slot, new ItemStack(EquipmentHelper.ARMOR_TIERS[slot - 1][tier]));
                    equipped[slot] = true;
                    if (entity.func_70681_au().nextDouble() < mult) continue;
                }
            }
        }
        if (!PropHelper.WEAPONS_BLACKLIST.contains(entityClass) && entity.func_71124_b(0) == null) {
            effectiveDifficulty = (double)worldDifficulty / (double)PropHelper.WEAPONS_TIME;
            bonus = PropHelper.WEAPONS_CHANCE * effectiveDifficulty;
            level = PropHelper.WEAPONS_TIER * effectiveDifficulty;
            if (PropHelper.WEAPONS_CHANCE_MAX >= 0.0 && bonus > PropHelper.WEAPONS_CHANCE_MAX) {
                bonus = PropHelper.WEAPONS_CHANCE_MAX;
            }
            if (PropHelper.WEAPONS_TIER_MAX >= 0.0 && level > PropHelper.WEAPONS_TIER_MAX) {
                level = PropHelper.WEAPONS_TIER_MAX;
            }
            if (fullMoon) {
                bonus += PropHelper.WEAPONS_LUNAR_CHANCE;
                level += PropHelper.WEAPONS_LUNAR_TIER;
            }
            if (entity.func_70681_au().nextDouble() < bonus) {
                tier = 0;
                i = 3;
                while (i-- > 0) {
                    if (!(entity.func_70681_au().nextDouble() < level)) continue;
                    ++tier;
                }
                entity.func_70062_b(0, new ItemStack(EquipmentHelper.WEAPON_TIERS[EquipmentHelper.nextWeaponType(entity)][tier]));
                equipped[0] = true;
            }
        }
        if (!PropHelper.ENCHANTS_BLACKLIST.contains(entityClass)) {
            effectiveDifficulty = (double)worldDifficulty / (double)PropHelper.ENCHANTS_TIME;
            bonus = PropHelper.ENCHANTS_CHANCE * effectiveDifficulty;
            level = PropHelper.ENCHANTS_LEVEL * effectiveDifficulty;
            if (PropHelper.ENCHANTS_CHANCE_MAX >= 0.0 && bonus > PropHelper.ENCHANTS_CHANCE_MAX) {
                bonus = PropHelper.ENCHANTS_CHANCE_MAX;
            }
            if (fullMoon) {
                bonus += PropHelper.ENCHANTS_LUNAR_CHANCE;
                level += PropHelper.ENCHANTS_LUNAR_LEVEL;
            }
            if (PropHelper.ENCHANTS_LEVEL_MAX >= 0.0 && level > PropHelper.ENCHANTS_LEVEL_MAX) {
                level = PropHelper.ENCHANTS_LEVEL_MAX;
            }
            int slot = equipped.length;
            while (slot-- > 0) {
                if (!equipped[slot] && (entity.func_71124_b(slot) == null || !(entity.func_71124_b(slot).func_77973_b() instanceof ItemBow)) || !(entity.func_70681_au().nextDouble() < bonus)) continue;
                try {
                    EnchantmentHelper.func_77504_a((Random)entity.func_70681_au(), (ItemStack)entity.func_71124_b(slot), (int)Math.max(0, (int)Math.round(level + entity.func_70681_au().nextGaussian() * PropHelper.ENCHANTS_STDEV)));
                }
                catch (Exception ex) {
                    ApocalypseMod.logDebug("Error applying enchantments! slot:" + slot + " entity:" + entity.toString());
                }
            }
        }
    }

    private static void initializePotions(EntityLivingBase entity, Class entityClass, long worldDifficulty, boolean fullMoon) {
        if (!PropHelper.POTIONS_BLACKLIST.contains(entityClass)) {
            double effectiveDifficulty = (double)worldDifficulty / (double)PropHelper.POTIONS_TIME;
            double bonus = PropHelper.POTIONS_CHANCE * effectiveDifficulty;
            if (PropHelper.POTIONS_CHANCE_MAX >= 0.0 && bonus > PropHelper.POTIONS_CHANCE_MAX) {
                bonus = PropHelper.POTIONS_CHANCE_MAX;
            }
            if (fullMoon) {
                bonus += PropHelper.POTIONS_LUNAR_CHANCE;
            }
            if (entity.func_70681_au().nextDouble() < bonus) {
                double mult = PropHelper.POTIONS_EXTRA * effectiveDifficulty;
                if (PropHelper.POTIONS_EXTRA_MAX >= 0.0 && bonus > PropHelper.POTIONS_EXTRA_MAX) {
                    mult = PropHelper.POTIONS_EXTRA_MAX;
                }
                if (fullMoon) {
                    mult += PropHelper.POTIONS_LUNAR_EXTRA;
                }
                int count = 1;
                int i = 2;
                while (i-- > 0) {
                    if (!(entity.func_70681_au().nextDouble() < mult)) continue;
                    ++count;
                }
                while (count-- > 0) {
                    int potionIndex = entity.func_70681_au().nextInt(ALLOWED_POTIONS.length);
                    PotionEffect potion = new PotionEffect(EventHandler.ALLOWED_POTIONS[potionIndex].field_76415_H, Integer.MAX_VALUE, POTION_LEVELS[potionIndex] > 0 ? entity.func_70681_au().nextInt(POTION_LEVELS[potionIndex]) : 0, false);
                    EquipmentHelper.forcePotion(entity, potion);
                }
            }
        }
    }

    private static void initializeAttributes(EntityLivingBase entity, Class entityClass, long worldDifficulty, boolean fullMoon) {
        double mult;
        double bonus;
        double effectiveDifficulty;
        IAttributeInstance attribute = entity.func_110148_a(SharedMonsterAttributes.field_111267_a);
        if (attribute != null && !PropHelper.HEALTH_BLACKLIST.contains(entityClass)) {
            float prevMax = entity.func_110138_aP();
            effectiveDifficulty = (double)worldDifficulty / (double)PropHelper.HEALTH_TIME;
            bonus = PropHelper.HEALTH_BONUS * effectiveDifficulty;
            mult = PropHelper.HEALTH_MULT * effectiveDifficulty;
            if (PropHelper.HEALTH_BONUS_MAX >= 0.0 && bonus > PropHelper.HEALTH_BONUS_MAX) {
                bonus = PropHelper.HEALTH_BONUS_MAX;
            }
            if (PropHelper.HEALTH_MULT_MAX >= 0.0 && mult > PropHelper.HEALTH_MULT_MAX) {
                mult = PropHelper.HEALTH_MULT_MAX;
            }
            if (fullMoon) {
                bonus += PropHelper.HEALTH_LUNAR_BONUS;
                mult += PropHelper.HEALTH_LUNAR_MULT;
            }
            if (bonus != 0.0) {
                attribute.func_111121_a(new AttributeModifier("ApocalypseFlatHEALTH", bonus, 0));
            }
            if (mult != 0.0) {
                attribute.func_111121_a(new AttributeModifier("ApocalypseMultHEALTH", mult, 1));
            }
            entity.func_70606_j(entity.func_110143_aJ() + entity.func_110138_aP() - prevMax);
        }
        if ((attribute = entity.func_110148_a(SharedMonsterAttributes.field_111264_e)) != null && !PropHelper.DAMAGE_BLACKLIST.contains(entityClass)) {
            effectiveDifficulty = (double)worldDifficulty / (double)PropHelper.DAMAGE_TIME;
            bonus = PropHelper.DAMAGE_BONUS * effectiveDifficulty;
            mult = PropHelper.DAMAGE_MULT * effectiveDifficulty;
            if (PropHelper.DAMAGE_BONUS_MAX >= 0.0 && bonus > PropHelper.DAMAGE_BONUS_MAX) {
                bonus = PropHelper.DAMAGE_BONUS_MAX;
            }
            if (PropHelper.DAMAGE_MULT_MAX >= 0.0 && mult > PropHelper.DAMAGE_MULT_MAX) {
                mult = PropHelper.DAMAGE_MULT_MAX;
            }
            if (fullMoon) {
                bonus += PropHelper.DAMAGE_LUNAR_BONUS;
                mult += PropHelper.DAMAGE_LUNAR_MULT;
            }
            if (bonus != 0.0) {
                attribute.func_111121_a(new AttributeModifier("ApocalypseFlatDAMAGE", bonus, 0));
            }
            if (mult != 0.0) {
                attribute.func_111121_a(new AttributeModifier("ApocalypseMultDAMAGE", mult, 1));
            }
        }
        if ((attribute = entity.func_110148_a(SharedMonsterAttributes.field_111263_d)) != null && !PropHelper.SPEED_BLACKLIST.contains(entityClass)) {
            effectiveDifficulty = (double)worldDifficulty / (double)PropHelper.SPEED_TIME;
            mult = PropHelper.SPEED_MULT * effectiveDifficulty;
            if (PropHelper.SPEED_MULT_MAX >= 0.0 && mult > PropHelper.SPEED_MULT_MAX) {
                mult = PropHelper.SPEED_MULT_MAX;
            }
            if (fullMoon) {
                mult += PropHelper.SPEED_LUNAR_MULT;
            }
            if (mult != 0.0) {
                attribute.func_111121_a(new AttributeModifier("ApocalypseMultSPEED", mult, 1));
            }
        }
        if ((attribute = entity.func_110148_a(SharedMonsterAttributes.field_111266_c)) != null && !PropHelper.KNOCKBACK_RESIST_BLACKLIST.contains(entityClass)) {
            effectiveDifficulty = (double)worldDifficulty / (double)PropHelper.KNOCKBACK_RESIST_TIME;
            bonus = PropHelper.KNOCKBACK_RESIST_BONUS * effectiveDifficulty;
            if (PropHelper.KNOCKBACK_RESIST_BONUS_MAX >= 0.0 && bonus > PropHelper.KNOCKBACK_RESIST_BONUS_MAX) {
                bonus = PropHelper.KNOCKBACK_RESIST_BONUS_MAX;
            }
            if (fullMoon) {
                bonus += PropHelper.KNOCKBACK_RESIST_LUNAR_BONUS;
            }
            if (bonus != 0.0) {
                attribute.func_111121_a(new AttributeModifier("ApocalypseFlatRESIST", bonus, 0));
            }
        }
    }
}

