/*
 * Decompiled with CFR 0.152.
 */
package toast.apocalypse;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import toast.apocalypse.WorldDifficultyManager;

public class MessageWorldDifficulty
implements IMessage {
    public byte type;
    public long difficulty;
    public double difficultyRate;

    public MessageWorldDifficulty() {
    }

    public MessageWorldDifficulty(long difficulty, double difficultyRate) {
        this.type = (byte)-1;
        this.difficulty = difficulty;
        this.difficultyRate = difficultyRate;
    }

    public MessageWorldDifficulty(long difficulty) {
        this.type = 0;
        this.difficulty = difficulty;
    }

    public MessageWorldDifficulty(double difficultyRate) {
        this.type = 1;
        this.difficultyRate = difficultyRate;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.type);
        if (this.type == 0 || this.type == -1) {
            buf.writeLong(this.difficulty);
        }
        if (this.type == 1 || this.type == -1) {
            buf.writeDouble(this.difficultyRate);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.type = buf.readByte();
        if (this.type == 0 || this.type == -1) {
            this.difficulty = buf.readLong();
        }
        if (this.type == 1 || this.type == -1) {
            this.difficultyRate = buf.readDouble();
        }
    }

    public static class Handler
    implements IMessageHandler<MessageWorldDifficulty, IMessage> {
        public IMessage onMessage(MessageWorldDifficulty message, MessageContext ctx) {
            if (message.type == 0 || message.type == -1) {
                WorldDifficultyManager.setWorldDifficulty(message.difficulty);
            }
            if (message.type == 1 || message.type == -1) {
                WorldDifficultyManager.setDifficultyRate(message.difficultyRate);
            }
            return null;
        }
    }

    public static class Type {
        public static final byte ALL = -1;
        public static final byte DIFFICULTY = 0;
        public static final byte RATE = 1;
    }
}

