/*
 * Decompiled with CFR 0.152.
 */
package toast.apocalypse;

import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;

public class NameHelper {
    public static final String[] NAMES = new String[]{"Abdul", "Albert", "Andrew", "Ash", "Anderson", "Andy", "Allan", "Arthur", "Aaron", "Allison", "Arielle", "Amanda", "Anne", "Annie", "Amy", "Alana", "Aerin", "Brandon", "Brady", "Bernard", "Ben", "Benjamin", "Bob", "Bobette", "Brooke", "Brandy", "Beatrice", "Bea", "Bella", "Becky", "Bamsy", "Bio", "Brain", "Bart", "Cidolfus", "Carlton", "Christopher", "Charles", "Carl", "Calvin", "Cameron", "Carson", "Chase", "Cassandra", "Cassie", "Cas", "Carol", "Carly", "Cherise", "Charlotte", "Cheryl", "Chasity", "Chaos", "Delita", "Danny", "Drake", "Daniel", "Derrel", "David", "Dave", "Donovan", "Don", "Donald", "Drew", "Derrick", "Darla", "Donna", "Dora", "Danielle", "Dulciphi", "Edward", "Elliot", "Ed", "Edson", "Elton", "Elvis", "Eddison", "Earl", "Eric", "Ericson", "Eddie", "Ediovany", "Emma", "Elizabeth", "Eliza", "Esperanza", "Esper", "Esmeralda", "Emi", "Emily", "Elaine", "Fernando", "Ferdinand", "Fred", "Feddie", "Fredward", "Frank", "Franklin", "Felix", "Felicia", "Fran", "Ford", "Greg", "Gregory", "George", "Gerald", "Gina", "Geraldine", "Gabby", "Gary", "Hendrix", "Henry", "Hobbes", "Herbert", "Heath", "Henderson", "Helga", "Hera", "Heracles", "Helen", "Helena", "Hannah", "Homer", "Ike", "Issac", "Israel", "Ismael", "Irlanda", "Isabelle", "Irene", "Irenia", "Jimmy", "Jim", "Justin", "Jacob", "Jake", "Jon", "Johnson", "Jonny", "Jonathan", "Josh", "Joshua", "Julian", "Jesus", "Jericho", "Jeb", "Jess", "Joan", "Jill", "Jillian", "Jessica", "Jennifer", "Jenny", "Jen", "Judy", "Jarno", "Kenneth", "Kenny", "Ken", "Keith", "Kevin", "Karen", "Kassandra", "Kassie", "Kehaan", "Kiwi", "Leonard", "Leo", "Leroy", "Lee", "Lenny", "Luke", "Lucas", "Liam", "Lorraine", "Latasha", "Lauren", "Laquisha", "Livia", "Lydia", "Lisa", "Lila", "Lilly", "Lillian", "Lilith", "Lana", "Mustadio", "Meliadoul", "Marach", "Mason", "Mike", "Mickey", "Mario", "Manny", "Mark", "Marcus", "Martin", "Marty", "Matthew", "Matt", "Max", "Maximillian", "Marth", "Mia", "Marriah", "Maddison", "Maddie", "Marissa", "Miranda", "Mary", "Martha", "Melonie", "Melody", "Mel", "Minnie", "Marge", "Marvin", "Nathan", "Nathaniel", "Nate", "Ned", "Nick", "Norman", "Nicholas", "Natasha", "Nicki", "Nora", "Nelly", "Nina", "Orville", "Oliver", "Orlandeau", "Owen", "Olsen", "Odin", "Olaf", "Ortega", "Olivia", "Ovelia", "Patrick", "Pat", "Paul", "Perry", "Pinnochio", "Patrice", "Patricia", "Pennie", "Petunia", "Patti", "Pernelle", "Quade", "Quincy", "Quentin", "Quinn", "Ramza", "Rapha", "Roberto", "Robbie", "Rob", "Robert", "Roy", "Roland", "Ronald", "Richard", "Rick", "Ricky", "Rose", "Rosa", "Rhonda", "Rebecca", "Roberta", "Reassembly", "Sparky", "Shiloh", "Stephen", "Steve", "Saul", "Sheen", "Shane", "Sean", "Sampson", "Samuel", "Sammy", "Stefan", "Sasha", "Sam", "Susan", "Suzy", "Shelby", "Samantha", "Sheila", "Sharon", "Sally", "Stephanie", "Sandra", "Sandy", "Sage", "Tim", "Thomas", "Thompson", "Tyson", "Tyler", "Tom", "Tyrone", "Timmothy", "Tamara", "Tabby", "Tabitha", "Tessa", "Tiara", "Tyra", "Tricia", "Uriel", "Ursala", "Uma", "Victor", "Vincent", "Vince", "Vance", "Vinny", "Velma", "Victoria", "Veronica", "Wilson", "Wally", "Wallace", "Will", "Wilard", "William", "Wilhelm", "Wyld", "Xavier", "Xandra", "Young", "Yvonne", "Yolanda", "Zach", "Zachary", "Zaphod"};
    public static final String[] NAME_PARTS = new String[]{"Grab", "Thar", "Ger", "Ald", "Mas", "On", "O", "Din", "Thor", "Jon", "Ath", "Burb", "En", "A", "E", "I", "U", "Hab", "Bloo", "Ena", "Dit", "Aph", "Ern", "Bor", "Dav", "Id", "Toast", "Son", "Dottir", "For", "Wen", "Lob", "Ed", "Die", "Van", "Y", "Zap", "Ear", "Ben", "Don", "Bran", "Gro", "Jen", "Bob", "Ette", "Ere", "Man", "Qua", "Bro", "Cree", "Per", "Skel", "Ton", "Zom", "Bie", "Wolf", "End", "Er", "Pig", "Sil", "Ver", "Fish", "Cow", "Chic", "Ken", "Sheep", "Squid", "Hell", "Cid"};
    public static final String[] SALUTATIONS = new String[]{"Sir", "Mister", "Madam", "Doctor", "Father", "Mother"};
    public static final String[] DESCRIPTORS = new String[]{"Mighty", "Supreme", "Superior", "Ultimate", "Lame", "Wimpy", "Curious", "Sneaky", "Pathetic", "Crying", "Eagle", "Errant", "Unholy", "Questionable", "Mean", "Hungry", "Thirsty", "Feeble", "Wise", "Sage", "Magical", "Mythical", "Legendary", "Not Very Nice", "Jerk", "Doctor", "Misunderstood", "Angry", "Knight", "Bishop", "Godly", "Special", "Toasty", "Shiny", "Shimmering", "Light", "Dark", "Odd-Smelling", "Funky", "Rock Smasher", "Son of Herobrine", "Cracked", "Sticky", "\u00a7kAlien\u00a7r", "Baby", "Manly", "Rough", "Scary", "Undoubtable", "Honest", "Non-Suspicious", "Boring", "Odd", "Lazy", "Super", "Nifty", "Ogre Slayer", "Pig Thief", "Dirt Digger", "Really Cool", "Doominator", "... Something", "Chaotic", "Duel Getter", "Buttered"};
    public static final String[][][] ENCHANT_MODIFIERS = new String[Enchantment.field_77331_b.length][][];

    public static String cap(String string) {
        int length = string.length();
        if (length <= 0) {
            return "";
        }
        if (length == 1) {
            return string.toUpperCase();
        }
        return Character.toString(Character.toUpperCase(string.charAt(0))) + string.substring(1);
    }

    public static String buildName(Random random) {
        String name = NAME_PARTS[random.nextInt(NAME_PARTS.length)] + NAME_PARTS[random.nextInt(NAME_PARTS.length)].toLowerCase();
        if (random.nextInt(2) == 0) {
            name = name + NAME_PARTS[random.nextInt(NAME_PARTS.length)].toLowerCase();
        }
        return name;
    }

    public static String setEntityName(Random random, EntityLivingBase entity) {
        String root;
        String name = root = random.nextInt(2) == 0 ? NAMES[random.nextInt(NAMES.length)] : NameHelper.buildName(random);
        if (random.nextInt(5) == 0) {
            name = SALUTATIONS[random.nextInt(SALUTATIONS.length)] + " " + name;
        }
        if (random.nextInt(2) == 0) {
            name = name + " ";
            if (random.nextInt(30) == 0) {
                name = random.nextInt(2) == 0 ? name + "Mac" : name + "Mc";
            }
            name = name + NameHelper.buildName(random);
        } else {
            name = name + " the " + DESCRIPTORS[random.nextInt(DESCRIPTORS.length)];
        }
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_94058_c(name);
        }
        return root;
    }

    public static void setItemName(Random random, ItemStack itemStack, String name, Enchantment enchantment) {
        name = name + "'s ";
        boolean prefixed = false;
        if (random.nextInt(5) == 0) {
            prefixed = true;
        } else if (random.nextInt(2) == 0) {
            prefixed = true;
            if (ENCHANT_MODIFIERS[enchantment.field_77352_x] != null) {
                name = name + ENCHANT_MODIFIERS[enchantment.field_77352_x][0][random.nextInt(ENCHANT_MODIFIERS[enchantment.field_77352_x][0].length)] + " ";
            }
        }
        String material = null;
        if (itemStack.func_77973_b() instanceof ItemSword) {
            material = ((ItemSword)itemStack.func_77973_b()).func_150932_j();
        } else if (itemStack.func_77973_b() instanceof ItemTool) {
            material = ((ItemTool)itemStack.func_77973_b()).func_77861_e();
        }
        if (material != null) {
            String[][] materials = new String[][]{{"Wooden", "Wood", "Hardwood", "Balsa Wood", "Mahogany", "Plywood"}, {"Stone", "Rock", "Marble", "Cobblestone"}, {"Iron", "Steel", "Ferrous", "Rusty", "Wrought Iron"}, {"Diamond", "Zircon", "Gemstone", "Jewel", "Crystal"}, {"Golden", "Gold", "Gilt", "Auric", "Ornate"}};
            int index = -1;
            if (material.equals(Item.ToolMaterial.WOOD.toString())) {
                index = 0;
            } else if (material.equals(Item.ToolMaterial.STONE.toString())) {
                index = 1;
            } else if (material.equals(Item.ToolMaterial.IRON.toString())) {
                index = 2;
            } else if (material.equals(Item.ToolMaterial.EMERALD.toString())) {
                index = 3;
            } else if (material.equals(Item.ToolMaterial.GOLD.toString())) {
                index = 4;
            }
            name = index < 0 ? name + NameHelper.cap(material.toLowerCase()) + " " : name + materials[index][random.nextInt(materials[index].length)] + " ";
            String[] type = new String[]{"Tool"};
            if (itemStack.func_77973_b() instanceof ItemSword) {
                type = new String[]{"Sword", "Cutter", "Slicer", "Dicer", "Knife", "Blade", "Machete", "Brand", "Claymore", "Cutlass", "Foil", "Dagger", "Glaive", "Rapier", "Saber", "Scimitar", "Shortsword", "Longsword", "Broadsword", "Calibur"};
            } else if (itemStack.func_77973_b() instanceof ItemAxe) {
                type = new String[]{"Axe", "Chopper", "Hatchet", "Tomahawk", "Cleaver", "Hacker", "Tree-Cutter", "Truncator"};
            } else if (itemStack.func_77973_b() instanceof ItemPickaxe) {
                type = new String[]{"Pickaxe", "Pick", "Mattock", "Rock-Smasher", "Miner"};
            } else if (itemStack.func_77973_b() instanceof ItemSpade) {
                type = new String[]{"Shovel", "Spade", "Digger", "Excavator", "Trowel", "Scoop"};
            }
            name = name + type[random.nextInt(type.length)];
        } else if (itemStack.func_77973_b() instanceof ItemBow) {
            String[] type = new String[]{"Bow", "Shortbow", "Longbow", "Flatbow", "Recurve Bow", "Reflex Bow", "Self Bow", "Composite Bow", "Arrow-Flinger"};
            name = name + type[random.nextInt(type.length)];
        } else if (itemStack.func_77973_b() instanceof ItemArmor) {
            String[][] materials = new String[][]{{"Leather", "Rawhide", "Lamellar", "Cow Skin"}, {"Chainmail", "Chain", "Chain Link", "Scale"}, {"Iron", "Steel", "Ferrous", "Rusty", "Wrought Iron"}, {"Diamond", "Zircon", "Gemstone", "Jewel", "Crystal"}, {"Golden", "Gold", "Gilt", "Auric", "Ornate"}};
            material = ((ItemArmor)itemStack.func_77973_b()).func_82812_d().toString();
            int index = -1;
            if (material.equals(ItemArmor.ArmorMaterial.CLOTH.toString())) {
                index = 0;
            } else if (material.equals(ItemArmor.ArmorMaterial.CHAIN.toString())) {
                index = 1;
            } else if (material.equals(ItemArmor.ArmorMaterial.IRON.toString())) {
                index = 2;
            } else if (material.equals(ItemArmor.ArmorMaterial.DIAMOND.toString())) {
                index = 3;
            } else if (material.equals(ItemArmor.ArmorMaterial.GOLD.toString())) {
                index = 4;
            }
            name = index < 0 ? name + NameHelper.cap(material.toLowerCase()) + " " : name + materials[index][random.nextInt(materials[index].length)] + " ";
            String[] type = new String[]{"Armor"};
            switch (((ItemArmor)itemStack.func_77973_b()).field_77881_a) {
                case 0: {
                    type = new String[]{"Helmet", "Cap", "Crown", "Great Helm", "Bassinet", "Sallet", "Close Helm", "Barbute"};
                    break;
                }
                case 1: {
                    type = new String[]{"Chestplate", "Tunic", "Brigandine", "Hauberk", "Cuirass"};
                    break;
                }
                case 2: {
                    type = new String[]{"Leggings", "Pants", "Tassets", "Cuisses", "Schynbalds"};
                    break;
                }
                case 3: {
                    type = new String[]{"Boots", "Shoes", "Greaves", "Sabatons", "Sollerets"};
                }
            }
            name = name + type[random.nextInt(type.length)];
        } else {
            name = name + itemStack.func_77973_b().func_77653_i(itemStack);
        }
        if (!prefixed && ENCHANT_MODIFIERS[enchantment.field_77352_x] != null) {
            name = name + " of " + ENCHANT_MODIFIERS[enchantment.field_77352_x][1][random.nextInt(ENCHANT_MODIFIERS[enchantment.field_77352_x][1].length)];
        }
        itemStack.func_151001_c("\u00a7d" + name);
    }

    private NameHelper() {
    }

    static {
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77332_c.field_77352_x] = new String[][]{{"Protective", "Shielding", "Fortified", "Tough", "Sturdy", "Defensive"}, {"Resistance", "Protection", "Shielding", "Fortitude", "Toughness", "Sturdiness", "Defense"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77329_d.field_77352_x] = new String[][]{{"Flame-Resistant", "Flameproof", "Fire-Resistant", "Fireproof", "Cold", "Frigid"}, {"Flame Resistance", "Flame Warding", "Fire Resistance", "Fire Warding", "Coldness", "Ice"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77330_e.field_77352_x] = new String[][]{{"Feather", "Feathered", "Mercury", "Hermes", "Winged", "Lightweight", "Soft", "Cushioned"}, {"Feather Falling", "Feathers", "Mercury", "Hermes", "Wings", "Gravity", "Softness", "Cushioning"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77327_f.field_77352_x] = new String[][]{{"Blast-Resistant", "Creeperproof", "Anti-Creeper", "Bomb", "Explosion-Damping", "Bombproof"}, {"Blast Resistance", "Creeper Hugging", "Creeper Slaying", "Bomb Repelling", "Explosion Damping", "Bomb Resistance"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77328_g.field_77352_x] = new String[][]{{"Arrow-Blocking", "Skeletonproof", "Anti-Skeleton", "Arrow-Breaking", "Arrowproof"}, {"Arrow Blocking", "Skeleton Hugging", "Skeleton Slaying", "Arrow Resistance", "Arrow Defense"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77340_h.field_77352_x] = new String[][]{{"Waterbreathing", "Dive", "Diving", "Water", "Scuba", "Fishy", "Underwater", "Deep-sea", "Submarine"}, {"Waterbreathing", "Diving", "Deep-Sea Diving", "Water", "Swimming", "Fishiness", "Underwater Exploration", "Deep-sea Exploration", "Submersion"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77341_i.field_77352_x] = new String[][]{{"Aquatic", "Watery", "Wet", "Deep-Sea Mining", "Fish", "Fishy"}, {"Aquatic Mining", "Water", "Wetness", "Deep-Sea Mining", "Fish"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_92091_k.field_77352_x] = new String[][]{{"Thorned", "Spiked", "Angry", "Vengeful", "Retaliating", "Splintering", "Harmful", "Painful", "Spiny", "Pointy", "Sharp"}, {"Thorns", "Spikes", "Anger", "Vengeance", "Retaliation", "Splinters", "Harm", "Pain", "Spines", "Pointiness", "Sharpness"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77338_j.field_77352_x] = new String[][]{{"Sharp", "Razor Sharp", "Pointy", "Razor-Edged", "Serrated", "Painful", "Smart"}, {"Sharpness", "Razor Sharpness", "Pointiness", "Pain", "Smarting"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77339_k.field_77352_x] = new String[][]{{"Smiting", "Holy", "Banishing", "Burying", "Purging", "Cleansing", "Wrathful", "Zombie-Slaying", "Skeleton-Slaying", "Undead-Slaying"}, {"Smiting", "Holiness", "Banishing", "Burying", "Purging", "Cleansing", "Wrath", "Zombie Slaying", "Skeleton Slaying", "Undead Slaying"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77336_l.field_77352_x] = new String[][]{{"Spider-Slaying", "Bug-Crushing", "Flyswatting", "Bugbane", "Arachnophobic", "Spiderbane"}, {"Spider Slaying", "Bug Crushing", "Flyswatting", "Bugbane", "Arachnophobia", "Spiderbane"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77337_m.field_77352_x] = new String[][]{{"Forceful", "Heavy", "Dull", "Powerful", "Pushing", "Launching", "Furious", "Charging", "Ram's"}, {"Forcefulness", "Knockback", "Dullness", "Power", "Pushing", "Launching", "Fury", "Charging", "The Ram"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77334_n.field_77352_x] = new String[][]{{"Fiery", "Fiery Dragon", "Fire", "Burning", "Hot", "Volcanic", "Lava", "Dragon", "Tree-Slaying"}, {"Fire", "The Fire Dragon", "Flame", "Burning", "Heat", "Volcanoes", "Lava", "The Dragon", "Tree Slaying"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77335_o.field_77352_x] = new String[][]{{"Looting", "Lucky", "Fortunate", "Greedy", "Grubby", "Thievish", "Thieving"}, {"Looting", "Luck", "Fortune", "Greed", "Grubbiness", "Thievishness", "Thieving"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77349_p.field_77352_x] = new String[][]{{"Efficient", "Quick", "Fast", "Speedy", "Quick-Mining", "Rushing"}, {"Efficiency", "Quickness", "Fastness", "Speed", "Quick-Mining", "Rushing"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77348_q.field_77352_x] = new String[][]{{"Careful", "Delicate", "Gentle", "Courteous", "Polite", "Ice-Harvesting", "Glass-Removing"}, {"Carefulness", "Delicate Mining", "Gentleness", "Courtesy", "Politeness", "Ice Harvesting", "Glass Removing"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77347_r.field_77352_x] = new String[][]{{"Unbreaking", "Reliable", "Trusty", "Flexible", "Unbreakable", "Timeless", "Quality", "Made-Like-They-Used-To-Make-Them"}, {"Unbreaking", "Reliabitlity", "Trustiness", "Flexibility", "Unbreakability", "Timelessness", "Quality"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77346_s.field_77352_x] = new String[][]{{"Fortunate", "Lucky", "Greedy", "Effective", "Collector's", "Flint-Finding", "Resourceful"}, {"Fortune", "Luck", "Greed", "Effectiveness", "Collecting", "Flint Finding", "Resourcefulness"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77345_t.field_77352_x] = new String[][]{{"Powerful", "Heart-Seeking", "Head-Seeking", "Killer", "Sniper", "Efficient", "Arrow-Saving", "Ogre-Slaying"}, {"Power", "Heart Seeking", "Head Seeking", "Killing", "Sniping", "Efficiency", "Arrow Saving", "Ogre Slaying"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77344_u.field_77352_x] = new String[][]{{"Forceful", "Heavy", "Self-Defense", "Crushing", "Smashing"}, {"Force", "Heavy Arrows", "Self-Defense", "Crushing", "Smashing"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77343_v.field_77352_x] = new String[][]{{"Fiery", "Fiery Dragon", "Fire", "Burning", "Hot", "Volcanic", "Lava", "Dragon", "Fire-Arrow", "Tree-Slaying"}, {"Fire", "The Fire Dragon", "Flame", "Burning", "Heat", "Volcanoes", "Lava", "The Dragon", "Flaming Arrows", "Tree Slaying"}};
        NameHelper.ENCHANT_MODIFIERS[Enchantment.field_77342_w.field_77352_x] = new String[][]{{"Efficient", "Infinite", "Arrow-Making", "Arrow-Saving", "Boomerang", "Magic Arrow"}, {"Efficiency", "Infinity", "Arrow Making", "Arrow Saving", "Boomerang Arrows", "Magic Arrow Creation"}};
    }
}

