/*
 * Decompiled with CFR 0.152.
 */
package toast.apocalypse;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import toast.apocalypse.ApocalypseMod;
import toast.apocalypse.EventHandler;
import toast.apocalypse.MessageWorldDifficulty;
import toast.apocalypse.PropHelper;
import toast.apocalypse.event.EventBase;

public class WorldDifficultyManager {
    public static final DamageSource RAIN_DAMAGE = new DamageSource("Apocalypse.rain").func_76348_h();
    private static final HashMap<Integer, WorldDifficultyData> WORLD_MAP = new HashMap();
    private static final ArrayDeque<EntityLivingBase> ENTITY_STACK = new ArrayDeque();
    public static final int TICKS_PER_UPDATE = 5;
    public static final String TAG_BASE = "Apocalypse";
    public static final String TAG_RAIN = "Rain";
    public static final String TAG_GRAVITY = "Gravity";
    public static final String TAG_INIT = "Apocalypse|Init";
    public static File worldDir;
    private static long worldDifficulty;
    private static long lastWorldDifficulty;
    private static double difficultyRateMult;
    private static double lastDifficultyRateMult;
    private static EventBase activeEvent;
    private static boolean checkedFullMoon;
    private int updateCounter = 0;

    public static NBTTagCompound getData(EntityPlayer player) {
        NBTTagCompound tag = player.getEntityData();
        if (!tag.func_74764_b("PlayerPersisted")) {
            NBTTagCompound nBTTagCompound = tag;
            tag = new NBTTagCompound();
            nBTTagCompound.func_74782_a("PlayerPersisted", (NBTBase)tag);
        } else {
            tag = tag.func_74775_l("PlayerPersisted");
        }
        if (!tag.func_74764_b(TAG_BASE)) {
            NBTTagCompound nBTTagCompound = tag;
            tag = new NBTTagCompound();
            nBTTagCompound.func_74782_a(TAG_BASE, (NBTBase)tag);
        } else {
            tag = tag.func_74775_l(TAG_BASE);
        }
        return tag;
    }

    public static long getWorldDifficulty() {
        return Math.max(0L, worldDifficulty);
    }

    @SideOnly(value=Side.CLIENT)
    public static void setWorldDifficulty(long difficulty) {
        worldDifficulty = difficulty;
    }

    public static double getDifficultyRate() {
        return difficultyRateMult;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setDifficultyRate(double difficultyRate) {
        difficultyRateMult = difficultyRate;
    }

    public static void processSetCommand(double arg) {
        worldDifficulty = (long)(arg * 24000.0);
        WorldDifficultyManager.updateWorldDifficulty();
    }

    private static void updateWorldDifficulty() {
        if (difficultyRateMult != lastDifficultyRateMult) {
            ApocalypseMod.CHANNEL.sendToAll((IMessage)new MessageWorldDifficulty(difficultyRateMult));
            lastDifficultyRateMult = difficultyRateMult;
        }
        if (activeEvent != null || worldDifficulty != lastWorldDifficulty) {
            if ((int)(worldDifficulty / 24000L) != (int)(lastWorldDifficulty / 24000L) || (int)(worldDifficulty % 24000L / 2400L) != (int)(lastWorldDifficulty % 24000L / 2400L)) {
                ApocalypseMod.CHANNEL.sendToAll((IMessage)new MessageWorldDifficulty(worldDifficulty));
            }
            lastWorldDifficulty = worldDifficulty;
            WorldDifficultyManager.save();
        }
    }

    public static EventBase getActiveEvent() {
        return activeEvent;
    }

    public static boolean startEvent(EventBase event) {
        WorldServer[] worlds;
        if (event == null) {
            return false;
        }
        if (activeEvent != null) {
            if (!activeEvent.canBeInterrupted(event)) {
                return false;
            }
            activeEvent.onEnd();
        }
        event.onStart();
        for (WorldServer world : worlds = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
            if (world == null) continue;
            for (Object player : world.field_73010_i) {
                if (!(player instanceof EntityPlayer)) continue;
                ((EntityPlayer)player).func_145747_a((IChatComponent)new ChatComponentTranslation(event.getStartMessage(), new Object[0]));
            }
        }
        activeEvent = event;
        WorldDifficultyManager.updateWorldDifficulty();
        return true;
    }

    public static void endEvent() {
        if (activeEvent != null) {
            activeEvent.onEnd();
            activeEvent = null;
            WorldDifficultyManager.updateWorldDifficulty();
        }
    }

    public static boolean isFullMoon(World world) {
        return world.field_73011_w.func_76559_b(world.func_72820_D()) == 0;
    }

    public static long updateWorld(WorldServer world, long mostSkippedTime) {
        if (world == null) {
            return mostSkippedTime;
        }
        WorldDifficultyData worldData = WORLD_MAP.get(world.field_73011_w.field_76574_g);
        long skippedTime = 0L;
        if (world.field_73011_w.field_76574_g == 0 && difficultyRateMult > 0.0 && worldData != null && PropHelper.SLEEP_PENALTY > 0.0) {
            skippedTime = world.func_72820_D() - worldData.lastWorldTime;
        }
        if (worldDifficulty > 0L && activeEvent != EventBase.fullMoon) {
            int dayTime = (int)(world.func_72820_D() % 24000L);
            if (dayTime < 13000) {
                checkedFullMoon = false;
            } else if (!checkedFullMoon && WorldDifficultyManager.isFullMoon((World)world)) {
                checkedFullMoon = true;
                if (world.field_73012_v.nextDouble() < PropHelper.FULL_MOON_EVENT) {
                    WorldDifficultyManager.startEvent(EventBase.fullMoon);
                }
            }
        }
        if (activeEvent != null) {
            activeEvent.update(world);
        }
        EntityPlayer player = null;
        for (Object entity : new ArrayList(world.field_73010_i)) {
            if (!(entity instanceof EntityPlayer)) continue;
            player = (EntityPlayer)entity;
            NBTTagCompound data = WorldDifficultyManager.getData(player);
            if (activeEvent != null) {
                activeEvent.update(player);
            }
            EventHandler.onPlayerUpdate(player, data);
        }
        if (worldData == null) {
            worldData = new WorldDifficultyData(world.field_73011_w.field_76574_g);
            WORLD_MAP.put(world.field_73011_w.field_76574_g, worldData);
        }
        worldData.lastWorldTime = world.func_72820_D();
        if (mostSkippedTime < skippedTime) {
            return skippedTime;
        }
        return mostSkippedTime;
    }

    public static void markForInit(EntityLivingBase entity) {
        if (entity.getEntityData().func_74771_c(TAG_INIT) == 0) {
            ENTITY_STACK.add(entity);
        }
    }

    public static void init(MinecraftServer server) {
        try {
            worldDir = server.func_71209_f("saves/" + server.func_71270_I() + "/" + TAG_BASE);
            worldDir.mkdirs();
            WorldDifficultyManager.load();
        }
        catch (Exception ex) {
            ApocalypseMod.log("Failed to initialize data storage! You should probably reload the world as soon as possible.");
            ex.printStackTrace();
            worldDir = null;
        }
    }

    public static void cleanup() {
        WORLD_MAP.clear();
        ENTITY_STACK.clear();
        worldDifficulty = 0L;
        worldDir = null;
    }

    public WorldDifficultyManager() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            ApocalypseMod.CHANNEL.sendTo((IMessage)new MessageWorldDifficulty(worldDifficulty, difficultyRateMult), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (++this.updateCounter >= 5) {
                this.updateCounter = 0;
                if (activeEvent != null) {
                    activeEvent.update();
                }
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                WorldServer[] worlds = server.field_71305_c;
                difficultyRateMult = server.func_71233_x();
                if (difficultyRateMult > 1.0) {
                    difficultyRateMult = (difficultyRateMult - 1.0) * PropHelper.DIFFICULTY_PER_PERSON + 1.0;
                }
                if (PropHelper.DIMENSION_PENALTY > 0.0) {
                    for (Object player : server.func_71203_ab().field_72404_b) {
                        if (!(player instanceof EntityPlayer) || ((EntityPlayer)player).field_71093_bK == 0) continue;
                        difficultyRateMult *= 1.0 + PropHelper.DIMENSION_PENALTY;
                        break;
                    }
                }
                worldDifficulty = (long)((double)worldDifficulty + 5.0 * difficultyRateMult);
                long mostSkippedTime = 0L;
                for (WorldServer world : worlds) {
                    mostSkippedTime = WorldDifficultyManager.updateWorld(world, mostSkippedTime);
                }
                if (mostSkippedTime > 20L) {
                    worldDifficulty = (long)((double)worldDifficulty + (double)mostSkippedTime * PropHelper.SLEEP_PENALTY * difficultyRateMult);
                    for (Object player : server.func_71203_ab().field_72404_b) {
                        if (!(player instanceof EntityPlayer)) continue;
                        ((EntityPlayer)player).func_146105_b((IChatComponent)new ChatComponentTranslation("event.Apocalypse.sleepPenalty", new Object[0]));
                    }
                }
                WorldDifficultyManager.updateWorldDifficulty();
            }
            if (!ENTITY_STACK.isEmpty()) {
                EntityLivingBase entity;
                int count = 10;
                while (count-- > 0 && (entity = ENTITY_STACK.pollFirst()) != null) {
                    EventHandler.initializeEntity(entity);
                    entity.getEntityData().func_74774_a(TAG_INIT, (byte)1);
                }
            }
        }
    }

    private static void save() {
        try {
            File fileTmp = new File(worldDir, "data.bin.tmp");
            File file = new File(worldDir, "data.bin");
            fileTmp.createNewFile();
            FileOutputStream stream = new FileOutputStream(fileTmp, true);
            DataOutputStream out = new DataOutputStream(stream);
            out.writeLong(worldDifficulty);
            if (activeEvent != null) {
                out.writeByte(WorldDifficultyManager.activeEvent.EVENT_ID);
                activeEvent.save(out);
            } else {
                out.writeByte(-1);
            }
            stream.close();
            file.delete();
            fileTmp.renameTo(file);
        }
        catch (Exception ex) {
            ApocalypseMod.log("[ERROR] Failed to save world data!");
            ex.printStackTrace();
        }
    }

    private static void load() {
        try {
            File file = new File(worldDir, "data.bin");
            if (file.exists()) {
                FileInputStream stream = new FileInputStream(file);
                DataInputStream in = new DataInputStream(stream);
                worldDifficulty = in.readLong();
                byte eventId = in.readByte();
                if (eventId >= 0) {
                    activeEvent = EventBase.EVENTS[eventId % EventBase.EVENTS.length];
                    activeEvent.load(in);
                }
                stream.close();
            } else {
                worldDifficulty = -PropHelper.GRACE_PERIOD;
            }
        }
        catch (Exception ex) {
            ApocalypseMod.log("Failed to load world data!");
            ex.printStackTrace();
        }
    }

    static {
        difficultyRateMult = 1.0;
        lastDifficultyRateMult = 1.0;
        checkedFullMoon = true;
    }

    public static class WorldDifficultyData {
        public final int dimension;
        public long lastWorldTime;

        public WorldDifficultyData(int dimension) {
            this.dimension = dimension;
        }
    }
}

