/*
 * Decompiled with CFR 0.152.
 */
package toast.apocalypse.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;
import toast.apocalypse.Properties;
import toast.apocalypse.WorldDifficultyManager;

@SideOnly(value=Side.CLIENT)
public class GuiDifficulty {
    public static final int[] COLORS = new int[]{0xFFFFFF, 0x88FFFF, 0x88FF88, 0xFFFF88, 0xFFBB88, 0xFF8888};
    public static final long COLOR_CHANGE = (long)(Properties.getDouble("gui_display", "color_change") * 24000.0);
    public static final int POSITION_X = GuiDifficulty.getPositionX();
    public static final int POSITION_Y = GuiDifficulty.getPositionY();
    public static final int OFFSET_X = Properties.getInt("gui_display", "offset_h") * (POSITION_X == 1 ? -1 : 1);
    public static final int OFFSET_Y = Properties.getInt("gui_display", "offset_v") * (POSITION_Y == 1 ? -1 : 1);
    private final Minecraft mc = FMLClientHandler.instance().getClient();

    private static int getPositionX() {
        String pos = Properties.getString("gui_display", "position_h");
        if (pos.equalsIgnoreCase("LEFT")) {
            return 0;
        }
        if (pos.equalsIgnoreCase("RIGHT")) {
            return 1;
        }
        if (pos.equalsIgnoreCase("CENTER")) {
            return 2;
        }
        return -1;
    }

    private static int getPositionY() {
        String pos = Properties.getString("gui_display", "position_v");
        if (pos.equalsIgnoreCase("TOP")) {
            return 0;
        }
        if (pos.equalsIgnoreCase("BOTTOM")) {
            return 1;
        }
        if (pos.equalsIgnoreCase("CENTER")) {
            return 2;
        }
        return -1;
    }

    public GuiDifficulty() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void afterRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.BOSSHEALTH || POSITION_X < 0 || POSITION_Y < 0) {
            return;
        }
        int width = event.resolution.func_78326_a();
        int height = event.resolution.func_78328_b();
        int color = COLORS[0];
        long difficulty = WorldDifficultyManager.getWorldDifficulty();
        int partialDifficulty = (int)(difficulty % 24000L / 2400L);
        if (COLOR_CHANGE >= 0L && difficulty >= 0L) {
            color = difficulty >= COLOR_CHANGE ? COLORS[COLORS.length - 1] : COLORS[(int)((double)difficulty / (double)COLOR_CHANGE * (double)COLORS.length)];
        }
        String difficultyInfo = "Difficulty level: " + (difficulty /= 24000L) + "." + partialDifficulty;
        double difficultyRate = WorldDifficultyManager.getDifficultyRate();
        if (difficultyRate != 1.0) {
            difficultyInfo = difficultyInfo + " Rate: " + (int)(difficultyRate * 100.0) + "%";
        }
        switch (POSITION_X) {
            case 0: {
                int x = 2;
                break;
            }
            case 1: {
                int x = width - this.mc.field_71466_p.func_78256_a(difficultyInfo) - 2;
                break;
            }
            case 2: {
                int x = (width >> 1) - (this.mc.field_71466_p.func_78256_a(difficultyInfo) >> 1);
                break;
            }
            default: {
                return;
            }
        }
        switch (POSITION_Y) {
            case 0: {
                int y = 2;
                break;
            }
            case 1: {
                int y = height - 10;
                break;
            }
            case 2: {
                int y = (height >> 1) - 4;
                break;
            }
            default: {
                return;
            }
        }
        this.mc.field_71466_p.func_78261_a(difficultyInfo, x += OFFSET_X, y += OFFSET_Y, color);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

