/*
 * Decompiled with CFR 0.152.
 */
package toast.apocalypse.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import toast.apocalypse.MobHelper;
import toast.apocalypse.WorldDifficultyManager;
import toast.apocalypse.entity.EntityDestroyerFireball;
import toast.apocalypse.entity.IFullMoonMob;

public class EntityDestroyer
extends EntityGhast
implements IFullMoonMob {
    public int field_92014_j = 1;
    public Entity field_70792_g;
    public int field_70798_h;
    public boolean prevInRange;

    public EntityDestroyer(World world) {
        super(world);
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected String func_70639_aQ() {
        return null;
    }

    public byte getFireTexture() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setFireTexture(boolean fire) {
        this.field_70180_af.func_75692_b(16, (Object)(fire ? (byte)1 : 0));
    }

    public void func_70636_d() {
        if (!WorldDifficultyManager.isFullMoon(this.field_70170_p)) {
            this.field_70708_bq += 4;
        }
        super.func_70636_d();
    }

    protected void func_70626_be() {
        this.func_70623_bb();
        this.field_70794_e = this.field_70791_f;
        this.updateEntityGoal();
        if (!this.field_70170_p.field_72995_K) {
            boolean shouldBeShooting;
            boolean shooting = this.getFireTexture() == 1;
            boolean bl = shouldBeShooting = this.field_70791_f > 10;
            if (shooting != shouldBeShooting) {
                this.setFireTexture(shouldBeShooting);
            }
        }
    }

    protected void updateEntityGoal() {
        this.updateEntityTarget();
        float distanceSq = Float.POSITIVE_INFINITY;
        if (this.field_70792_g != null) {
            distanceSq = (float)this.field_70792_g.func_70068_e((Entity)this);
        }
        boolean inRange = (double)distanceSq < 256.0;
        double vX = this.field_70795_b - this.field_70165_t;
        double vY = this.field_70796_c - this.field_70163_u;
        double vZ = this.field_70793_d - this.field_70161_v;
        double v = vX * vX + vY * vY + vZ * vZ;
        if (v < 1.0 || v > 3600.0 || inRange != this.prevInRange) {
            if (inRange) {
                this.setRandomWaypoints(6.0f);
            } else if (this.field_70792_g != null) {
                this.field_70795_b = this.field_70792_g.field_70165_t;
                this.field_70796_c = this.field_70792_g.field_70163_u + (double)(this.field_70792_g.field_70131_O / 2.0f);
                this.field_70793_d = this.field_70792_g.field_70161_v;
                if (!this.isCourseTraversable(Math.sqrt(v))) {
                    this.setRandomWaypoints(32.0f);
                }
            } else {
                this.setRandomWaypoints(32.0f);
                this.field_70796_c = Math.max(this.field_70796_c, Math.max(70.0, (double)this.field_70170_p.func_72976_f((int)Math.floor(this.field_70795_b), (int)Math.floor(this.field_70793_d)) + 16.0));
            }
        }
        if (this.field_70797_a-- <= 0) {
            this.field_70797_a += this.field_70146_Z.nextInt(5) + 2;
            if (this.isCourseTraversable(v = Math.sqrt(v))) {
                double speed = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() / v;
                this.field_70159_w += vX * speed;
                this.field_70181_x += vY * speed;
                this.field_70179_y += vZ * speed;
            } else {
                this.clearWaypoints();
            }
        }
        if ((double)distanceSq < 4096.0) {
            double x = this.field_70792_g.field_70165_t - this.field_70165_t;
            double z = this.field_70792_g.field_70161_v - this.field_70161_v;
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(x, z)) * 180.0f / (float)Math.PI;
            if (this.field_70791_f == 10) {
                this.field_70170_p.func_72889_a((EntityPlayer)null, 1007, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
            }
            ++this.field_70791_f;
            if (this.field_70791_f == 20) {
                if (!this.field_70170_p.field_72995_K) {
                    this.shootFireballAtEntity(this.field_70792_g);
                }
                this.field_70791_f = -40;
            }
        } else {
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
            if (this.field_70791_f > 0) {
                --this.field_70791_f;
            }
        }
        this.prevInRange = inRange;
    }

    public void setRandomWaypoints(float range) {
        this.field_70795_b = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() - 0.5f) * range);
        this.field_70796_c = this.field_70163_u + (double)((this.field_70146_Z.nextFloat() - 0.5f) * range);
        this.field_70793_d = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() - 0.5f) * range);
    }

    public void clearWaypoints() {
        this.field_70795_b = this.field_70165_t;
        this.field_70796_c = this.field_70163_u;
        this.field_70793_d = this.field_70161_v;
    }

    public boolean isCourseTraversable(double v) {
        double dX = (this.field_70795_b - this.field_70165_t) / v;
        double dY = (this.field_70796_c - this.field_70163_u) / v;
        double dZ = (this.field_70793_d - this.field_70161_v) / v;
        AxisAlignedBB aabb = this.field_70121_D.func_72329_c();
        int i = 1;
        while ((double)i < v) {
            aabb.func_72317_d(dX, dY, dZ);
            if (!this.field_70170_p.func_72945_a((Entity)this, aabb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void updateEntityTarget() {
        if (this.field_70792_g != null && this.field_70792_g.field_70128_L) {
            this.field_70792_g = null;
        }
        if (this.field_70792_g == null || this.field_70798_h-- <= 0) {
            this.field_70792_g = this.field_70170_p.func_72856_b((Entity)this, -1.0);
            if (this.field_70792_g != null) {
                this.field_70798_h = 20;
            }
        }
    }

    public void shootFireballAtEntity(Entity target) {
        double x = target.field_70165_t - this.field_70165_t;
        double y = target.field_70121_D.field_72338_b - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
        double z = target.field_70161_v - this.field_70161_v;
        this.field_70170_p.func_72889_a((EntityPlayer)null, 1008, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
        EntityDestroyerFireball fireball = new EntityDestroyerFireball(this.field_70170_p, this, x, y, z);
        Vec3 vec3 = this.func_70676_i(1.0f);
        fireball.field_70165_t = this.field_70165_t + vec3.field_72450_a * (double)this.field_70130_N;
        fireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f);
        fireball.field_70161_v = this.field_70161_v + vec3.field_72449_c * (double)this.field_70130_N;
        this.field_70170_p.func_72838_d((Entity)fireball);
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("ExplosionPower", this.field_92014_j);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("ExplosionPower")) {
            this.field_92014_j = tag.func_74762_e("ExplosionPower");
        }
    }

    protected void func_70628_a(boolean hit, int looting) {
        int i = this.field_70146_Z.nextInt(3) + 1;
        while (i-- > 0) {
            this.func_145779_a(Items.field_151016_H, 1);
        }
        i = this.field_70146_Z.nextInt(2);
        while (i-- > 0) {
            this.func_145779_a(Items.field_151062_by, 1);
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_85032_ar()) {
            return false;
        }
        if ("fireball".equals(source.func_76355_l()) && source.func_76346_g() instanceof EntityPlayer) {
            super.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)source.func_76346_g())), damage * 2.0f + this.func_110138_aP() / 2.0f);
            return true;
        }
        if (source.func_76346_g() == this) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public boolean func_70601_bi() {
        return MobHelper.canSpawn((EntityLiving)this) && (this.field_71093_bK != 0 || this.field_70170_p.func_72937_j((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v)));
    }
}

