/*
 * Decompiled with CFR 0.152.
 */
package toast.apocalypse.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import toast.apocalypse.EventHandler;
import toast.apocalypse.MobHelper;
import toast.apocalypse.WorldDifficultyManager;
import toast.apocalypse.entity.IFullMoonMob;

public class EntityGhost
extends EntityFlying
implements IMob,
IFullMoonMob {
    public int courseChangeCooldown;
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    public Entity targetedEntity;
    public int aggroCooldown;
    public int prevAttackCounter;
    public int attackCounter;

    public EntityGhost(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.field_70145_X = true;
        this.field_70728_aV = 3;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.1);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70058_J() {
        return false;
    }

    public boolean func_70094_T() {
        return false;
    }

    protected String func_70639_aQ() {
        return "mob.blaze.breathe";
    }

    protected String func_70621_aR() {
        return "mob.endermen.scream";
    }

    protected String func_70673_aS() {
        return "mob.blaze.death";
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void func_70636_d() {
        float brightness;
        if (!WorldDifficultyManager.isFullMoon(this.field_70170_p)) {
            this.field_70708_bq += 4;
        }
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && (brightness = this.func_70013_c(1.0f)) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (brightness - 0.4f) * 2.0f && this.field_70170_p.func_72937_j((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v))) {
            ItemStack helmet = this.func_71124_b(4);
            if (helmet != null) {
                if (helmet.func_77984_f()) {
                    helmet.func_77964_b(helmet.func_77952_i() + this.field_70146_Z.nextInt(2));
                    if (helmet.func_77952_i() >= helmet.func_77958_k()) {
                        this.func_70669_a(helmet);
                        this.func_70062_b(4, null);
                    }
                }
            } else {
                this.func_70015_d(8);
            }
        }
        super.func_70636_d();
    }

    protected void func_70626_be() {
        this.func_70623_bb();
        this.prevAttackCounter = this.attackCounter;
        this.updateEntityGoal();
    }

    protected void updateEntityGoal() {
        double vX = this.waypointX - this.field_70165_t;
        double vY = this.waypointY - this.field_70163_u;
        double vZ = this.waypointZ - this.field_70161_v;
        double v = vX * vX + vY * vY + vZ * vZ;
        if (v < 0.1 || v > 3600.0) {
            if (this.targetedEntity != null) {
                this.waypointX = this.targetedEntity.field_70165_t;
                this.waypointY = this.targetedEntity.field_70163_u + (double)(this.targetedEntity.field_70131_O / 2.0f);
                this.waypointZ = this.targetedEntity.field_70161_v;
                if (!this.isCourseTraversable(Math.sqrt(v))) {
                    this.setRandomWaypoints(32.0f);
                }
            } else {
                this.setRandomWaypoints(32.0f);
                this.waypointY = Math.max(this.waypointY, Math.max(70.0, (double)this.field_70170_p.func_72976_f((int)Math.floor(this.waypointX), (int)Math.floor(this.waypointZ)) + 16.0));
            }
        }
        if (this.courseChangeCooldown-- <= 0) {
            this.courseChangeCooldown += this.field_70146_Z.nextInt(5) + 2;
            if (this.isCourseTraversable(v = Math.sqrt(v))) {
                double speed = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() / v;
                this.field_70159_w += vX * speed;
                this.field_70181_x += vY * speed;
                this.field_70179_y += vZ * speed;
            } else {
                this.setRandomWaypoints(8.0f);
            }
        }
        this.updateEntityTarget();
        if (this.attackCounter > 0) {
            --this.attackCounter;
        }
        if (this.targetedEntity != null) {
            double reach;
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(this.targetedEntity.field_70165_t - this.field_70165_t, this.targetedEntity.field_70161_v - this.field_70161_v)) * 180.0f / (float)Math.PI;
            double distance = this.func_70092_e(this.targetedEntity.field_70165_t, this.targetedEntity.field_70163_u + (double)(this.targetedEntity.field_70131_O / 2.0f), this.targetedEntity.field_70161_v);
            if (this.attackCounter <= 0 && distance <= (reach = (double)(this.field_70130_N * this.field_70130_N * 4.0f + this.targetedEntity.field_70130_N))) {
                this.attackCounter = 20;
                this.func_71038_i();
                this.func_70652_k(this.targetedEntity);
            }
        } else {
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
        }
    }

    public void setRandomWaypoints(float range) {
        this.waypointX = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() - 0.5f) * range);
        this.waypointY = this.field_70163_u + (double)((this.field_70146_Z.nextFloat() - 0.5f) * range);
        this.waypointZ = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() - 0.5f) * range);
    }

    public void clearWaypoints() {
        this.waypointX = this.field_70165_t;
        this.waypointY = this.field_70163_u;
        this.waypointZ = this.field_70161_v;
    }

    public boolean isCourseTraversable(double v) {
        return true;
    }

    protected void updateEntityTarget() {
        if (this.targetedEntity != null && this.targetedEntity.field_70128_L) {
            this.targetedEntity = null;
        }
        if (this.targetedEntity == null || this.aggroCooldown-- <= 0) {
            this.targetedEntity = this.field_70170_p.func_72856_b((Entity)this, -1.0);
            if (this.targetedEntity != null) {
                this.aggroCooldown = 20;
            }
        }
    }

    public boolean func_70652_k(Entity target) {
        if (MobHelper.attackEntityForMob((EntityLiving)this, target, 1.0f)) {
            if (target instanceof EntityPlayer) {
                EventHandler.applyGravity((EntityPlayer)target, 80);
            }
            return true;
        }
        return false;
    }

    protected void func_70628_a(boolean hit, int looting) {
        if (hit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_145779_a(Items.field_151123_aH, 1);
        }
        int i = this.field_70146_Z.nextInt(2);
        while (i-- > 0) {
            this.func_145779_a(Items.field_151062_by, 1);
        }
    }

    public boolean func_70601_bi() {
        return true;
    }
}

