/*
 * Decompiled with CFR 0.152.
 */
package toast.apocalypse.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import toast.apocalypse.EventHandler;
import toast.apocalypse.MobHelper;
import toast.apocalypse.WorldDifficultyManager;
import toast.apocalypse.entity.EntityMonsterFishHook;
import toast.apocalypse.entity.IFullMoonMob;

public class EntityGrump
extends EntityGhast
implements IFullMoonMob {
    public Entity field_70792_g;
    public int field_70798_h;
    public int rodTime;

    public EntityGrump(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected String func_70639_aQ() {
        return null;
    }

    public void func_70636_d() {
        if (!WorldDifficultyManager.isFullMoon(this.field_70170_p)) {
            this.field_70708_bq += 4;
        }
        super.func_70636_d();
    }

    protected void func_70626_be() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u.func_151525_a() == 0) {
            this.func_70106_y();
        }
        this.func_70623_bb();
        this.field_70794_e = this.field_70791_f;
        this.updateEntityGoal();
    }

    protected void updateEntityGoal() {
        double vX = this.field_70795_b - this.field_70165_t;
        double vY = this.field_70796_c - this.field_70163_u;
        double vZ = this.field_70793_d - this.field_70161_v;
        double v = vX * vX + vY * vY + vZ * vZ;
        if (v < 0.1 || v > 3600.0) {
            if (this.field_70792_g != null) {
                this.field_70795_b = this.field_70792_g.field_70165_t;
                this.field_70796_c = this.field_70792_g.field_70163_u + (double)(this.field_70792_g.field_70131_O / 2.0f);
                this.field_70793_d = this.field_70792_g.field_70161_v;
                if (!this.isCourseTraversable(Math.sqrt(v))) {
                    this.setRandomWaypoints(32.0f);
                }
            } else {
                this.setRandomWaypoints(32.0f);
                this.field_70796_c = Math.max(this.field_70796_c, Math.max(70.0, (double)this.field_70170_p.func_72976_f((int)Math.floor(this.field_70795_b), (int)Math.floor(this.field_70793_d)) + 16.0));
            }
        }
        if (this.field_70797_a-- <= 0) {
            this.field_70797_a += this.field_70146_Z.nextInt(5) + 2;
            if (this.isCourseTraversable(v = Math.sqrt(v))) {
                double speed = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() / v;
                this.field_70159_w += vX * speed;
                this.field_70181_x += vY * speed;
                this.field_70179_y += vZ * speed;
            } else {
                this.setRandomWaypoints(8.0f);
            }
        }
        this.updateEntityTarget();
        if (this.field_70791_f > 0) {
            --this.field_70791_f;
        }
        if (this.rodTime > 0) {
            --this.rodTime;
        }
        if (this.field_70792_g != null) {
            double reach;
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(this.field_70792_g.field_70165_t - this.field_70165_t, this.field_70792_g.field_70161_v - this.field_70161_v)) * 180.0f / (float)Math.PI;
            double distance = this.func_70092_e(this.field_70792_g.field_70165_t, this.field_70792_g.field_70163_u + (double)(this.field_70792_g.field_70131_O / 2.0f), this.field_70792_g.field_70161_v);
            if (this.field_70791_f <= 0 && distance <= (reach = (double)(this.field_70130_N * this.field_70130_N * 4.0f + this.field_70792_g.field_70130_N))) {
                this.field_70791_f = 20;
                this.func_71038_i();
                this.func_70652_k(this.field_70792_g);
            }
            if (this.rodTime <= 0 && distance > 9.0 && distance < 100.0 && this.func_70635_at().func_75522_a(this.field_70792_g)) {
                this.field_70170_p.func_72838_d((Entity)new EntityMonsterFishHook(this.field_70170_p, (EntityLiving)this, this.field_70792_g));
                this.field_70170_p.func_72956_a((Entity)this, "random.bow", 0.5f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                this.rodTime = this.field_70146_Z.nextInt(32) + 32;
            }
        } else {
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
        }
    }

    public void setRandomWaypoints(float range) {
        this.field_70795_b = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() - 0.5f) * range);
        this.field_70796_c = this.field_70163_u + (double)((this.field_70146_Z.nextFloat() - 0.5f) * range);
        this.field_70793_d = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() - 0.5f) * range);
    }

    public void clearWaypoints() {
        this.field_70795_b = this.field_70165_t;
        this.field_70796_c = this.field_70163_u;
        this.field_70793_d = this.field_70161_v;
    }

    public boolean isCourseTraversable(double v) {
        double dX = (this.field_70795_b - this.field_70165_t) / v;
        double dY = (this.field_70796_c - this.field_70163_u) / v;
        double dZ = (this.field_70793_d - this.field_70161_v) / v;
        AxisAlignedBB aabb = this.field_70121_D.func_72329_c();
        int i = 1;
        while ((double)i < v) {
            aabb.func_72317_d(dX, dY, dZ);
            if (!this.field_70170_p.func_72945_a((Entity)this, aabb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void updateEntityTarget() {
        if (this.field_70792_g != null && this.field_70792_g.field_70128_L) {
            this.field_70792_g = null;
        }
        if (this.field_70792_g == null || this.field_70798_h-- <= 0) {
            this.field_70792_g = this.field_70170_p.func_72856_b((Entity)this, -1.0);
            if (this.field_70792_g != null) {
                this.field_70798_h = 20;
            }
        }
    }

    public boolean func_70652_k(Entity target) {
        if (MobHelper.attackEntityForMob((EntityLiving)this, target, 2.0f)) {
            if (target instanceof EntityPlayer) {
                EventHandler.applyGravity((EntityPlayer)target, 20);
            }
            return true;
        }
        return false;
    }

    protected void func_70628_a(boolean hit, int looting) {
        int i = this.field_70146_Z.nextInt(3);
        while (i-- > 0) {
            this.func_145779_a(Items.field_151106_aX, 1);
        }
        i = this.field_70146_Z.nextInt(2);
        while (i-- > 0) {
            this.func_145779_a(Items.field_151062_by, 1);
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_85032_ar()) {
            return false;
        }
        if ("fireball".equals(source.func_76355_l()) && source.func_76346_g() instanceof EntityPlayer) {
            return super.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)source.func_76346_g())), damage);
        }
        return super.func_70097_a(source, damage);
    }

    public boolean func_70601_bi() {
        return MobHelper.canSpawn((EntityLiving)this) && (this.field_71093_bK != 0 || this.field_70170_p.func_72937_j((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v)));
    }
}

